<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Product Price List</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table thead {
            background-color: #f5f5f5;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: left;
            font-weight: 600;
            font-size: 8pt;
        }
        
        table th:nth-child(5),
        table th:nth-child(6),
        table th:nth-child(7),
        table th:nth-child(8),
        table th:nth-child(9),
        table th:nth-child(10),
        table th:nth-child(11) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 3px;
            font-size: 8pt;
        }
        
        table td:nth-child(5),
        table td:nth-child(6),
        table td:nth-child(7),
        table td:nth-child(8),
        table td:nth-child(9),
        table td:nth-child(10),
        table td:nth-child(11) {
            text-align: right;
        }
        
        .text-right {
            text-align: right;
        }
        
        .footer {
            position: fixed;
            bottom: 1cm;
            left: 1.5cm;
            right: 1.5cm;
            display: table;
            width: calc(100% - 3cm);
            font-size: 8pt;
            color: #4a4a4a;
        }
        
        .footer-left {
            display: table-cell;
            vertical-align: bottom;
            text-align: left;
        }
        
        .footer-right {
            display: table-cell;
            vertical-align: bottom;
            text-align: right;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->landmark ?? '' }}, {{ $business->city ?? '' }}, {{ $business->state ?? '' }}, {{ $business->country ?? '' }}</div>
            </div>
            <div class="header-right">
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Tel: {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <br>E-mail: {{ $business->email }}
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Report Content -->
        @if(count($grouped_data) > 0)
            <table>
                <thead>
                    <tr>
                        <th>Product Group</th>
                        <th>Product Model</th>
                        <th>Product Description</th>
                        <th>Unit</th>
                        <th class="text-right">Purchase Price</th>
                        <th class="text-right">MRP</th>
                        <th class="text-right">Lower Price</th>
                        <th class="text-right">Dealer-A</th>
                        <th class="text-right">Dealer-B</th>
                        <th class="text-right">Dealer-C</th>
                        <th class="text-right">Retailer-A</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($grouped_data as $product_group => $items)
                        @foreach($items as $item)
                            <tr>
                                <td>{{ $item->product_group }}</td>
                                <td>{{ $item->product_model }}</td>
                                <td>{{ $item->product_description }}</td>
                                <td>{{ $item->unit }}</td>
                                <td class="text-right">{{ $util->num_f($item->purchase_price, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->mrp, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->lower_price, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->dealer_a, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->dealer_b, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->dealer_c, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->retailer_a, true) }}</td>
                            </tr>
                        @endforeach
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="no-data">No product price data found for the selected filters.</div>
        @endif
        
    </div>
    
    <!-- Footer -->
    <div class="footer">
        <div class="footer-left">
            {{ date('m/d/Y h:i:sA') }}
        </div>
        <div class="footer-right">
            Page 1 of 1
        </div>
    </div>
</body>
</html>


