@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_stock'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_stock') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStock']), 'method' => 'get', 'id' => 'date_wise_stock_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date', __('report.date') . ':') !!}
                        @php
                            $date_value = '';
                            if (!empty($stock_date)) {
                                $date_value = \Carbon\Carbon::parse($stock_date)->format('d/m/Y');
                            } elseif (!empty(request()->date)) {
                                $date_value = request()->date;
                            }
                        @endphp
                        {!! Form::text('date', $date_value , ['placeholder' => __('businessmanagement::lang.select_date'), 'class' => 'form-control', 'id' => 'date_wise_stock_date', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('businessmanagement::lang.all_categories'), 'single' => __('businessmanagement::lang.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('businessmanagement::lang.all_products'), 'single' => __('businessmanagement::lang.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStock']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($stock_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseStock'], ['date' => \Carbon\Carbon::parse($stock_date)->format('d/m/Y'), 'location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('stock_date', $stock_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $category_name => $items)
                            <table class="table table-bordered table-striped" style="font-size: 13px; margin-bottom: 20px;">
                                <thead>
                                    <tr>
                                        <th>ModelNo</th>
                                        <th>Product Description</th>
                                        <th style="text-align: right;">Qty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr style="background-color: #f0f0f0; font-weight: bold;">
                                        <td colspan="3" style="padding: 8px 12px;">{{ $category_name }}</td>
                                    </tr>
                                    @php
                                        $category_total_qty = 0;
                                    @endphp
                                    @foreach($items as $item)
                                        @php
                                            $category_total_qty += $item->qty;
                                        @endphp
                                        <tr>
                                            <td></td>
                                            <td>{{ $item->product_description }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->qty, false, null, true) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="2"><strong>Sub Total : {{ $category_name }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty, false, null, true) }}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <tbody>
                                <tr style="background-color: #d4edda; font-weight: bold; font-size: 16px;">
                                    <td colspan="2"><strong>Grand Total</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty, false, null, true) }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No stock data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('#date_wise_stock_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true
        });

        $('#date_wise_stock_date').on('changeDate', function(e) {
            var selected_date = e.format('yyyy-mm-dd');
            $('input[name="stock_date"]').val(selected_date);
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date field is populated before form submission
        $('#date_wise_stock_filter_form').on('submit', function() {
            var date_val = $('#date_wise_stock_date').val();
            if (date_val) {
                var date_parts = date_val.split('/');
                if (date_parts.length == 3) {
                    var stock_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('input[name="stock_date"]').val(stock_date);
                }
            }
        });
    });
</script>
@endsection

