<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Product Wise Sales</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tfoot {
            display: table-footer-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        /* Column alignments */
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .product-header-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .product-header-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .date-header-row {
            background-color: #f9f9f9 !important;
            font-weight: 500;
            font-size: 10pt;
        }
        
        .date-header-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
            border-top: 1px solid #000;
        }
        
        .subtotal-row td:first-child {
            text-align: left;
        }
        
        .subtotal-row td:nth-child(5),
        .subtotal-row td:nth-child(6),
        .subtotal-row td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .product-total-row {
            background-color: #e8e8e8 !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .product-total-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
            border-top: 1px solid #000;
        }
        
        .product-total-row td:first-child {
            text-align: left;
        }
        
        .product-total-row td:nth-child(5),
        .product-total-row td:nth-child(6),
        .product-total-row td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .grand-total-row {
            background-color: #e8e8e8 !important;
            font-weight: 700;
            font-size: 11pt;
            border-top: 2px solid #2c3e50;
        }
        
        .grand-total-row td {
            border: 1px solid #2c3e50;
            padding: 10px 6px;
        }
        
        .grand-total-row td:first-child {
            text-align: left;
        }
        
        .grand-total-row td:nth-child(5),
        .grand-total-row td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
            border-bottom: 2px solid #000;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .product-header-row {
                page-break-inside: avoid;
            }
            
            .subtotal-row {
                page-break-inside: avoid;
            }
            
            .product-total-row {
                page-break-inside: avoid;
            }
            
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Product Wise Sales</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Table -->
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Customer Name</th>
                        <th>Purchase Invoice</th>
                        <th>Ref. No.</th>
                        <th>Qty</th>
                        <th>Unit Price</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($sales_lines) > 0)
                        @foreach($grouped_data as $product_id => $product_lines)
                            @php
                                $product = $product_lines->first();
                                $product_total_qty = $product_lines->sum('quantity');
                                $product_total_price = $product_lines->sum('line_total');
                                $product_date_groups = $product_lines->groupBy('transaction_date');
                            @endphp
                            
                            @foreach($product_date_groups as $date => $date_lines)
                                @php
                                    $date_total_qty = $date_lines->sum('quantity');
                                    $date_total_price = $date_lines->sum('line_total');
                                @endphp
                                
                                <!-- Product Header Row (only show once per product) -->
                                @if($loop->first)
                                <tr class="product-header-row">
                                    <td colspan="2">{{ $product->product_description }}</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                @endif
                                
                                <!-- Date Header Row -->
                                <tr class="date-header-row">
                                    <td colspan="2">{{ $util->format_date($date, false) }}</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                
                                <!-- Sales Lines -->
                                @foreach($date_lines as $line)
                                <tr>
                                    <td>{{ $line->invoice_no }}</td>
                                    <td>
                                        @if(!empty($line->supplier_business_name))
                                            {{ $line->supplier_business_name }} - 
                                        @endif
                                        {{ $line->customer_name ?? 'Walking Customer' }}
                                    </td>
                                    <td>{{ $line->purchase_invoice ?? '' }}</td>
                                    <td>{{ $line->ref_no ?? '' }}</td>
                                    <td>{{ number_format($line->quantity, 2) }}</td>
                                    <td>{{ number_format($line->unit_price_inc_tax, 2) }}</td>
                                    <td>{{ number_format($line->line_total, 2) }}</td>
                                </tr>
                                @endforeach
                                
                                <!-- Date Subtotal -->
                                <tr class="subtotal-row">
                                    <td colspan="4" style="text-align: right;">Sub Total:</td>
                                    <td>{{ number_format($date_total_qty, 2) }}</td>
                                    <td></td>
                                    <td>{{ number_format($date_total_price, 2) }}</td>
                                </tr>
                            @endforeach
                            
                            <!-- Product Subtotal -->
                            <tr class="product-total-row">
                                <td colspan="4" style="text-align: right;">Product Total:</td>
                                <td>{{ number_format($product_total_qty, 2) }}</td>
                                <td></td>
                                <td>{{ number_format($product_total_price, 2) }}</td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="7" style="text-align: center; padding: 20px;">No sales found for the selected filters.</td>
                        </tr>
                    @endif
                </tbody>
                <tfoot>
                    <tr class="grand-total-row">
                        <td colspan="4" style="text-align: right;">Grand Total:</td>
                        <td>{{ number_format($grand_total_qty, 2) }}</td>
                        <td></td>
                        <td>{{ number_format($grand_total_price, 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</body>
</html>


