@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_gross_profit'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_gross_profit') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseGrossProfit']), 'method' => 'get', 'id' => 'date_wise_gross_profit_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_wise_gross_profit_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="date_wise_gross_profit_table">
                        <thead>
                            <tr>
                                <th>Invoice No</th>
                                <th>Trader Name</th>
                                <th>Total Amount</th>
                                <th>Discount</th>
                                <th>Extra Charges</th>
                                <th>AIT</th>
                                <th>VAT</th>
                                <th>Net Payable Amount</th>
                                <th>Total Cost</th>
                                <th>Gross Profit</th>
                                <th>Profit %</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#date_wise_gross_profit_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#date_wise_gross_profit_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
            }
        );

        $('#date_wise_gross_profit_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        var date_wise_gross_profit_table = $('#date_wise_gross_profit_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "dateWiseGrossProfit"]) }}',
                data: function(d) {
                    d.location_id = $('#location_id').val();
                    if ($('#date_wise_gross_profit_date_range').val()) {
                        var start = $('#date_wise_gross_profit_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#date_wise_gross_profit_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'trader_name', name: 'trader_name' },
                { data: 'total_amount', name: 'total_amount', orderable: false },
                { data: 'discount', name: 'discount', orderable: false },
                { data: 'extra_charges', name: 'extra_charges', orderable: false },
                { data: 'ait', name: 'ait', orderable: false },
                { data: 'vat', name: 'vat', orderable: false },
                { data: 'net_payable', name: 'net_payable', orderable: false },
                { data: 'total_cost', name: 'total_cost', orderable: false },
                { data: 'gross_profit', name: 'gross_profit', orderable: false },
                { data: 'profit_percent', name: 'profit_percent', orderable: false },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#date_wise_gross_profit_table'));
            },
        });

        // Apply filters button
        $('#apply_filters').on('click', function() {
            date_wise_gross_profit_table.ajax.reload();
            checkPrintButton();
        });

        // Reset filters button
        $('#reset_filters').on('click', function() {
            $('#location_id').val('').trigger('change');
            $('#date_wise_gross_profit_date_range').val('');
            date_wise_gross_profit_table.ajax.reload();
            checkPrintButton();
        });

        // Auto-reload on filter change
        $('#location_id').on('change', function() {
            date_wise_gross_profit_table.ajax.reload(null, false);
        });

        // Reload when date range changes
        $('#date_wise_gross_profit_date_range').on('apply.daterangepicker', function(ev, picker) {
            date_wise_gross_profit_table.ajax.reload(null, false);
            checkPrintButton();
        });

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#date_wise_gross_profit_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Print button click
        $('#print_report').on('click', function() {
            var location_id = $('#location_id').val() || '';
            var start_date = '';
            var end_date = '';
            
            if ($('#date_wise_gross_profit_date_range').val()) {
                start_date = $('#date_wise_gross_profit_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#date_wise_gross_profit_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
            
            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "printDateWiseGrossProfit"]) }}';
            url += '?location_id=' + location_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;
            
            window.open(url, '_blank');
        });

        // Initial check
        checkPrintButton();
    });
</script>
@endsection





