<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Product wise Purchase Return</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 15px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #2c3e50;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td:nth-child(1),
        table tbody td:nth-child(2) {
            text-align: left;
        }
        
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(6) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        /* Product Header Row */
        .product-header-row {
            background-color: #f5f7fa !important;
            font-weight: 600;
            border-top: 2px solid #2c3e50;
        }
        
        .product-header-row td {
            border: 1px solid #2c3e50;
            color: #1a1a1a;
            padding: 8px 5px;
        }
        
        /* Sub Total Row */
        .subtotal-row {
            background-color: #f8f9fa !important;
            font-weight: 600;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            color: #1a1a1a;
            padding: 7px 5px;
        }
        
        /* Grand Total Row */
        .grandtotal-row {
            background-color: #e9ecef !important;
            font-weight: 700;
            font-size: 10pt;
            border-top: 2px solid #2c3e50;
        }
        
        .grandtotal-row td {
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            color: #1a1a1a;
            padding: 8px 5px;
        }
        
        .grandtotal-row td:nth-child(3),
        .grandtotal-row td:nth-child(6) {
            border-bottom: 3px double #2c3e50;
        }
        
        /* Footer */
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            text-align: left;
            font-size: 9pt;
            color: #6a6a6a;
        }
        
        @media print {
            .product-section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if($logo)
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if($business->landmark)
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if($business->city || $business->state || $business->country)
                    <div class="company-address">
                        @if($business->city){{ $business->city }}, @endif
                        @if($business->state){{ $business->state }}, @endif
                        @if($business->country){{ $business->country }}@endif
                    </div>
                @endif
                @if($business->mobile)
                    <div class="company-contact">Phone: {{ $business->mobile }}</div>
                @endif
                @if($business->email)
                    <div class="company-contact">Email: {{ $business->email }}</div>
                @endif
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Product wise Purchase Return</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if($start_date && $end_date)
                {{ $util->format_date($start_date, true) }} To {{ $util->format_date($end_date, true) }}
            @else
                All Time
            @endif
        </div>
        
        @if(empty($grouped_data) || count($grouped_data) == 0)
            <div style="text-align: center; padding: 40px; color: #6a6a6a; font-size: 12pt;">
                <p><strong>No data found for the selected criteria.</strong></p>
                <p>Please adjust your filters and try again.</p>
            </div>
        @else
        <!-- Table -->
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th style="width: 15%;">Return ID</th>
                        <th style="width: 25%;">Supplier Name</th>
                        <th style="width: 10%;">Qty</th>
                        <th style="width: 15%;">Unit Price</th>
                        <th style="width: 15%;">Net Unit Price</th>
                        <th style="width: 20%;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($grouped_data as $product_key => $group)
                        <!-- Product Header Row -->
                        <tr class="product-header-row">
                            <td colspan="6">{{ $group['product_name'] }}</td>
                        </tr>
                        
                        <!-- Item Rows -->
                        @foreach($group['items'] as $item)
                            <tr>
                                <td>{{ $item['invoice_no'] }}</td>
                                <td>{{ $item['supplier_name'] }}</td>
                                <td>{{ number_format($item['quantity'], 2) }}</td>
                                <td>{{ number_format($item['unit_price'], 2) }}</td>
                                <td>{{ number_format($item['net_unit_price'], 2) }}</td>
                                <td>{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        
                        <!-- Sub Total Row -->
                        <tr class="subtotal-row">
                            <td colspan="2"><strong>Sub Total</strong></td>
                            <td><strong>{{ number_format($group['subtotal_qty'], 2) }}</strong></td>
                            <td></td>
                            <td></td>
                            <td><strong>{{ number_format($group['subtotal_amount'], 2) }}</strong></td>
                        </tr>
                    @endforeach
                    
                    <!-- Grand Total Row -->
                    <tr class="grandtotal-row">
                        <td colspan="2"><strong>Grand Total</strong></td>
                        <td><strong>{{ number_format($grand_total_qty, 2) }}</strong></td>
                        <td></td>
                        <td></td>
                        <td><strong>{{ number_format($grand_total_amount, 2) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>
        @endif
        
        <!-- Footer -->
        <div class="footer">
            <div>Generated on: {{ date('d/m/Y H:i:s') }}</div>
        </div>
    </div>
</body>
</html>

