@extends('layouts.app')
@section('title', __('businessmanagement::lang.supplier_due_list'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.supplier_due_list') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'supplierDueList']), 'method' => 'get', 'id' => 'supplier_due_list_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date', __('businessmanagement::lang.date') . ':') !!}
                        @php
                            $date_value = '';
                            if (!empty($date)) {
                                $date_value = \Carbon\Carbon::parse($date)->format('d/m/Y');
                            } else {
                                $date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('date_display', $date_value, ['class' => 'form-control date-picker', 'id' => 'supplier_due_list_date', 'readonly']); !!}
                        {!! Form::hidden('date', $date ?? date('Y-m-d'), ['id' => 'hidden_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('supplier_filter', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_filter', [
                            'all' => __('businessmanagement::lang.all_suppliers'),
                            'single' => __('businessmanagement::lang.single_supplier')
                        ], $supplier_filter ?? 'all', ['class' => 'form-control', 'id' => 'supplier_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="supplier_select_wrapper" style="display: {{ ($supplier_filter ?? 'all') == 'single' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('supplier_id', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, $supplier_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_supplier'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'supplierDueList']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printSupplierDueList'], ['date' => !empty($date) ? \Carbon\Carbon::parse($date)->format('Y-m-d') : date('Y-m-d'), 'supplier_filter' => $supplier_filter ?? 'all', 'supplier_id' => $supplier_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($due_data) > 0)
                        <table class="table table-bordered table-striped" style="font-size: 12px;">
                            <thead>
                                <tr>
                                    <th style="width: 50px;">SL</th>
                                    <th>Name</th>
                                    <th>Address</th>
                                    <th>Mobile</th>
                                    <th style="text-align: right;">Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $serial = 1;
                                @endphp
                                @foreach($due_data as $item)
                                    <tr>
                                        <td>{{ $serial++ }}</td>
                                        <td>{{ $item->contact_name }}</td>
                                        <td>{{ $item->address }}</td>
                                        <td>{{ $item->mobile }}</td>
                                        <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->due_amount }}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <tbody>
                                <tr style="background-color: #f8f9fa; font-weight: bold;">
                                    <td colspan="4" style="text-align: right;"><strong>Group Wise Sub Total:</strong></td>
                                    <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $grand_total }}</span></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No supplier due amounts found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('#supplier_due_list_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#supplier_due_list_date').on('changeDate', function(e) {
            var selected_date = e.format('yyyy-mm-dd');
            $('#hidden_date').val(selected_date);
        });

        // Supplier filter toggle
        $('#supplier_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#supplier_select_wrapper').show();
            } else {
                $('#supplier_select_wrapper').hide();
                $('#supplier_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date field is populated before form submission
        $('#supplier_due_list_filter_form').on('submit', function() {
            var date_val = $('#supplier_due_list_date').val();
            if (date_val) {
                var date_parts = date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

