<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Accounts Ledger</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: left;
            padding-left: 10px;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #000;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #000;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 5px 0;
            text-transform: uppercase;
            color: #000;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #000;
        }
        
        .account-name {
            font-size: 9pt;
            text-align: left;
            margin-bottom: 8px;
            color: #000;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table thead {
            background-color: transparent;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: 700;
            font-size: 8pt;
            background-color: transparent;
        }
        
        table th:nth-child(1),
        table th:nth-child(2),
        table th:nth-child(3),
        table th:nth-child(4),
        table th:nth-child(5),
        table th:nth-child(6) {
            text-align: left;
        }
        
        table th:nth-child(7),
        table th:nth-child(8),
        table th:nth-child(9) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 3px;
            font-size: 8pt;
        }
        
        table td:nth-child(1),
        table td:nth-child(2),
        table td:nth-child(3),
        table td:nth-child(4),
        table td:nth-child(5),
        table td:nth-child(6) {
            text-align: left;
        }
        
        table td:nth-child(7),
        table td:nth-child(8),
        table td:nth-child(9) {
            text-align: right;
        }
        
        /* Footer */
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            width: 100%;
            display: table;
            font-size: 7pt;
            color: #000;
            padding-top: 5px;
            border-top: 1px solid #000;
            margin-top: 10px;
        }
        
        .footer-left {
            display: table-cell;
            width: 40%;
            text-align: left;
        }
        
        .footer-center {
            display: table-cell;
            width: 35%;
            text-align: center;
        }
        
        .footer-right {
            display: table-cell;
            width: 25%;
            text-align: right;
        }
        
        @media print {
            .footer {
                position: fixed;
                bottom: 0;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @php
                    $logo = '';
                    if (!empty($business->logo)) {
                        $logo = asset('uploads/business_logos/' . $business->logo);
                    }
                @endphp
                @if(!empty($logo) && !empty($business->logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->address_line_1))
                    <div class="company-address">{{ $business->address_line_1 }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-right">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Accounts Ledger</div>
        
        <!-- Date Range -->
        <div class="report-date">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>
        
        <!-- Account Name -->
        @if(!empty($customer))
            <div class="account-name">Accounts Name: {{ $customer->supplier_business_name ?? $customer->name }}</div>
        @endif

        <!-- Table -->
        @if(count($ledger_data) > 0)
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Transaction Mode</th>
                        <th>A/C Name</th>
                        <th>Ref No.</th>
                        <th>Voucher No</th>
                        <th>Debit</th>
                        <th>Credit</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($ledger_data as $item)
                        <tr>
                            <td>{{ $util->format_date($item->date, false) }}</td>
                            <td>{{ $item->type }}</td>
                            <td>{{ $item->transaction_mode }}</td>
                            <td>{{ $item->ac_name }}</td>
                            <td>{{ $item->ref_no }}</td>
                            <td>{{ $item->voucher_no }}</td>
                            <td>{{ $util->num_f($item->debit, true, null) }}</td>
                            <td>{{ $util->num_f($item->credit, true, null) }}</td>
                            <td>{{ $util->num_f($item->balance, true, null) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="border-top: 2px solid #000;">
                        <td colspan="6" style="text-align: right; font-weight: 700; padding: 4px 3px;">Grand Total :</td>
                        <td style="text-align: right; font-weight: 700; padding: 4px 3px; border-bottom: 2px double #000;">{{ $util->num_f($grand_total_debit ?? 0, true, null) }}</td>
                        <td style="text-align: right; font-weight: 700; padding: 4px 3px; border-bottom: 2px double #000;">{{ $util->num_f($grand_total_credit ?? 0, true, null) }}</td>
                        <td style="text-align: right; padding: 4px 3px;"></td>
                    </tr>
                    <tr>
                        <td colspan="8" style="text-align: right; font-weight: 700; padding: 4px 3px;">Closing Balance:</td>
                        <td style="text-align: right; font-weight: 700; padding: 4px 3px; border-bottom: 2px double #000;">{{ $util->num_f($closing_balance ?? 0, true, null) }}</td>
                    </tr>
                </tfoot>
            </table>
        @else
            <div style="text-align: center; padding: 20px; font-size: 10pt;">
                No transactions found for the selected {{ ($contact_type ?? 'customer') == 'supplier' ? 'supplier' : 'customer' }} and date range.
            </div>
        @endif

        <!-- Footer -->
        <div class="footer">
            <div class="footer-left">
            </div>
            <div class="footer-center">
                Print Date & Time: {{ date('d/m/Y h:i:sA') }}
            </div>
            <div class="footer-right">
                Page 1 of 1
            </div>
        </div>
    </div>
</body>
</html>

