<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Balance Sheet</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: left;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
            text-align: left;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
            text-align: left;
        }
        
        .company-contact strong {
            font-weight: 700;
        }
        
        .report-title {
            font-size: 13pt;
            font-weight: 700;
            text-align: center;
            margin: 10px 0 5px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #1a1a1a;
            font-weight: 700;
        }
        
        .divider {
            border-top: 1px solid #000;
            margin: 8px 0;
        }
        
        /* Balance Sheet Table */
        .balance-sheet-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 8pt;
            margin-top: 10px;
        }
        
        .balance-sheet-table th {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: left;
            font-weight: 700;
            font-size: 8pt;
            background-color: #f5f5f5;
        }
        
        .balance-sheet-table th.amount-header {
            text-align: right;
        }
        
        .balance-sheet-table td {
            border: 1px solid #000;
            padding: 4px;
            font-size: 8pt;
            vertical-align: top;
        }
        
        .balance-sheet-table td.amount {
            text-align: right;
        }
        
        .section-header {
            font-weight: 700;
        }
        
        .sub-section-header {
            font-weight: 700;
            padding-left: 20px !important;
        }
        
        .item-name {
            padding-left: 40px !important;
        }
        
        .single-underline {
            border-top: 1px solid #000;
        }
        
        .grand-total {
            font-weight: 700;
            border-top: 2px double #000;
        }
        
        .grand-total.amount {
            border-top: 2px double #000;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}{{ !empty($business->address_line_1) && !empty($business->city) ? ', ' : '' }}{{ $business->city ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city)) && !empty($business->state) ? ', ' : '' }}{{ $business->state ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city) || !empty($business->state)) && !empty($business->country) ? ', ' : '' }}{{ $business->country ?? '' }}</div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        <strong>Phone</strong> {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <strong>Email</strong> {{ $business->email }}
                    @endif
                    @if(!empty($business->fax))
                        <strong>Fax</strong> {{ $business->fax }}
                    @endif
                    @if(!empty($business->website))
                        {{ $business->website }}
                    @endif
                </div>
            </div>
            <div class="header-right">
                <!-- Empty for alignment -->
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Balance Sheet</div>
        <div class="report-date">{{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}</div>
        <div class="divider"></div>
        
        <!-- Balance Sheet Table - Single Table with 4 Columns -->
        <table class="balance-sheet-table">
            <thead>
                <tr>
                    <th colspan="2" style="text-align: center; width: 50%;">Liabilities</th>
                    <th colspan="2" style="text-align: center; width: 50%;">Assets</th>
                </tr>
                <tr>
                    <th style="width: 35%;">Name</th>
                    <th class="amount-header" style="width: 15%;">Amount</th>
                    <th style="width: 35%;">Name</th>
                    <th class="amount-header" style="width: 15%;">Amount</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $max_rows = max(count($liabilities), count($assets));
                @endphp
                @for($i = 0; $i < $max_rows; $i++)
                    <tr>
                        <!-- Liabilities Column -->
                        @if(isset($liabilities[$i]))
                            @php $liability = $liabilities[$i]; @endphp
                            <td class="section-header">
                                {{ $liability['label'] }}
                                @if(!empty($liability['sub_label']))
                                    <div class="sub-section-header" style="margin-top: 3px;">{{ $liability['sub_label'] }}</div>
                                @endif
                                @foreach($liability['items'] ?? [] as $item)
                                    <div class="item-name" style="margin-top: 2px;">{{ $item['name'] }}</div>
                                @endforeach
                            </td>
                            <td class="amount">
                                {{ $util->num_f($liability['total'], true, null) }}
                                @if(!empty($liability['sub_label']))
                                    <div style="margin-top: 3px;">&nbsp;</div>
                                @endif
                                @foreach($liability['items'] ?? [] as $item)
                                    <div style="margin-top: 2px;">{{ $util->num_f($item['value'], true, null) }}</div>
                                @endforeach
                                @if($i < count($liabilities) - 1)
                                    <div class="single-underline" style="margin-top: 5px;"></div>
                                @endif
                            </td>
                        @else
                            <td>&nbsp;</td>
                            <td class="amount">&nbsp;</td>
                        @endif
                        
                        <!-- Assets Column -->
                        @if(isset($assets[$i]))
                            @php $asset = $assets[$i]; @endphp
                            <td class="section-header">
                                {{ $asset['label'] }}
                                @if(!empty($asset['sub_label']))
                                    <div class="sub-section-header" style="margin-top: 3px;">{{ $asset['sub_label'] }}</div>
                                @endif
                                @foreach($asset['items'] ?? [] as $item)
                                    <div class="item-name" style="margin-top: 2px;">{{ $item['name'] }}</div>
                                @endforeach
                            </td>
                            <td class="amount">
                                {{ $util->num_f($asset['total'], true, null) }}
                                @if(!empty($asset['sub_label']))
                                    <div style="margin-top: 3px;">&nbsp;</div>
                                @endif
                                @foreach($asset['items'] ?? [] as $item)
                                    <div style="margin-top: 2px;">{{ $util->num_f($item['value'], true, null) }}</div>
                                @endforeach
                                @if($i < count($assets) - 1)
                                    <div class="single-underline" style="margin-top: 5px;"></div>
                                @endif
                            </td>
                        @else
                            <td>&nbsp;</td>
                            <td class="amount">&nbsp;</td>
                        @endif
                    </tr>
                @endfor
            </tbody>
            <tfoot>
                <tr>
                    <td class="grand-total" style="text-align: right; font-weight: 700;">Grand Total</td>
                    <td class="grand-total amount">{{ $util->num_f($total_liabilities, true, null) }}</td>
                    <td class="grand-total" style="text-align: right; font-weight: 700;">Grand Total</td>
                    <td class="grand-total amount">{{ $util->num_f($total_assets, true, null) }}</td>
                </tr>
            </tfoot>
        </table>
    </div>
</body>
</html>
