@extends('layouts.app')
@section('title', 'Customer Account Statement')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Customer Account Statement</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerAccountStatement']), 'method' => 'get', 'id' => 'customer_account_statement_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->startOfMonth()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'customer_account_statement_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? \Carbon\Carbon::now()->startOfMonth()->format('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'customer_account_statement_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? \Carbon\Carbon::now()->format('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerAccountStatement']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($customer_id) && !empty($customer))
                                <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCustomerAccountStatement'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : \Carbon\Carbon::now()->startOfMonth()->format('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : \Carbon\Carbon::now()->format('Y-m-d'), 'customer_id' => $customer_id ?? '', 'location_id' => $location_id ?? '']) }}" 
                                   target="_blank" 
                                   class="btn btn-success">
                                    <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                @if(!empty($customer_id) && !empty($customer))
                    <div class="row" style="margin-bottom: 20px;">
                        <div class="col-md-12">
                            <div class="box box-info">
                                <div class="box-header with-border">
                                    <h3 class="box-title">Customer Information</h3>
                                </div>
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <strong>Customer ID:</strong> {{ $customer->contact_id ?? $customer->id }}<br>
                                            <strong>Customer Name:</strong> {{ $customer->supplier_business_name ?? $customer->name }}<br>
                                        </div>
                                        <div class="col-md-3">
                                            <strong>Contact No:</strong> {{ $customer->mobile ?? '-' }}<br>
                                            <strong>Address:</strong> {{ trim(($customer->address_line_1 ?? '') . ' ' . ($customer->address_line_2 ?? '') . ' ' . ($customer->city ?? '') . ' ' . ($customer->state ?? '') . ' ' . ($customer->country ?? '')) }}<br>
                                        </div>
                                        <div class="col-md-3">
                                            <strong>Company Code:</strong> {{ $business->code ?? '-' }}<br>
                                            <strong>Statement From:</strong> {{ $util->format_date($start_date, false) }}<br>
                                        </div>
                                        <div class="col-md-3">
                                            <strong>Statement To:</strong> {{ $util->format_date($end_date, false) }}<br>
                                            <strong>Date & Time:</strong> {{ \Carbon\Carbon::now()->format('d.m.Y H:i:s') }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row" style="margin-bottom: 20px;">
                        <div class="col-md-6">
                            <div class="box box-success">
                                <div class="box-header with-border">
                                    <h3 class="box-title">Balance Summary</h3>
                                </div>
                                <div class="box-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <td><strong>Previous Balance:</strong></td>
                                            <td style="text-align: right;">{{ $util->num_f($previous_balance, true, null) }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Debit / Sales Order:</strong></td>
                                            <td style="text-align: right;">{{ $util->num_f($total_debit, true, null) }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Credit / Payment:</strong></td>
                                            <td style="text-align: right;">({{ $util->num_f($total_credit, true, null) }})</td>
                                        </tr>
                                        <tr style="background-color: #f0f0f0;">
                                            <td><strong>Total Balance Due:</strong></td>
                                            <td style="text-align: right;"><strong>{{ $util->num_f($running_balance, true, null) }}</strong></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive" style="overflow-x: auto;">
                        @if(count($statement_data) > 0)
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th style="text-align: left;">Date</th>
                                        <th style="text-align: left;">Transaction Type</th>
                                        <th style="text-align: left;">Reference</th>
                                        <th style="text-align: left;">Description</th>
                                        <th style="text-align: right;">Quantity</th>
                                        <th style="text-align: right;">Rate</th>
                                        <th style="text-align: right;">Debit/Credit</th>
                                        <th style="text-align: right;">Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($statement_data as $item)
                                        <tr>
                                            <td>{{ $util->format_date($item->date, false) }}</td>
                                            <td>{{ $item->transaction_type }}</td>
                                            <td>{{ $item->reference }}</td>
                                            <td>{{ $item->description }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->quantity, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->rate, true, null) }}</td>
                                            <td style="text-align: right;">
                                                @if($item->debit > 0)
                                                    {{ $util->num_f($item->debit, true, null) }}
                                                @elseif($item->credit > 0)
                                                    {{ $util->num_f($item->credit, true, null) }}-
                                                @else
                                                    -
                                                @endif
                                            </td>
                                            <td style="text-align: right;">
                                                @if($item->balance < 0)
                                                    ({{ $util->num_f(abs($item->balance), true, null) }})
                                                @else
                                                    {{ $util->num_f($item->balance, true, null) }}
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="6" style="text-align: right;"><strong>Total Amount:</strong></td>
                                        <td style="text-align: right;">
                                            <strong>{{ $util->num_f($total_debit, true, null) }} / {{ $util->num_f($total_credit, true, null) }}-</strong>
                                        </td>
                                        <td style="text-align: right;"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        @else
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No transactions found for the selected customer and date range.
                            </div>
                        @endif
                    </div>
                @else
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i> Please select a customer to view the account statement.
                    </div>
                @endif
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#customer_account_statement_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#customer_account_statement_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#customer_account_statement_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#customer_account_statement_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#customer_account_statement_filter_form').on('submit', function() {
            var start_date_val = $('#customer_account_statement_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#customer_account_statement_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

