<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddBusinessManagementReportPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $permissions = [
            // Purchase Register Reports
            'businessmanagement.purchase_register.date_wise_purchase',
            'businessmanagement.purchase_register.supplier_wise_purchase',
            'businessmanagement.purchase_register.supplier_wise_purchase_wop',
            'businessmanagement.purchase_register.product_wise_purchase',
            'businessmanagement.purchase_register.product_wise_purchase_wop',
            'businessmanagement.purchase_register.location_wise_net_product_purchase',
            'businessmanagement.purchase_register.date_wise_net_product_purchase',
            'businessmanagement.purchase_register.supplier_wise_statement',
            'businessmanagement.purchase_register.supplier_and_product_wise_purchase',
            'businessmanagement.purchase_register.purchased_product_movement',
            'businessmanagement.purchase_register.supplier_wise_purchase_return',
            'businessmanagement.purchase_register.date_wise_purchase_return',
            'businessmanagement.purchase_register.product_wise_purchase_return',
            'businessmanagement.purchase_register.date_wise_purchase_order',
            'businessmanagement.purchase_register.supplier_wise_purchase_order',
            
            // Sales Register Reports
            'businessmanagement.sales_register.date_wise_sales',
            'businessmanagement.sales_register.product_wise_sales',
            'businessmanagement.sales_register.customer_wise_sales',
            'businessmanagement.sales_register.date_wise_net_product_sales',
            'businessmanagement.sales_register.customer_wise_net_product_sales',
            'businessmanagement.sales_register.date_wise_gross_profit',
            'businessmanagement.sales_register.product_wise_gross_profit',
            'businessmanagement.sales_register.date_wise_sales_return',
            'businessmanagement.sales_register.product_wise_sales_return',
            'businessmanagement.sales_register.customer_wise_sales_return',
            'businessmanagement.sales_register.explicit_product_wise_sales',
            'businessmanagement.sales_register.customer_wise_statement',
            'businessmanagement.sales_register.product_group_wise_net_sales',
            'businessmanagement.sales_register.product_wise_sales_summary',
            'businessmanagement.sales_register.date_wise_sales_summary',
            'businessmanagement.sales_register.product_group_wise_net_sales_mpo',
            'businessmanagement.sales_register.customer_wise_sales_summary',
            'businessmanagement.sales_register.customer_wise_invoice_status',
            'businessmanagement.sales_register.date_wise_sales_invoice',
            'businessmanagement.sales_register.customer_wise_gross_profit',
            'businessmanagement.sales_register.product_wise_net_profit',
            'businessmanagement.sales_register.customer_wise_sales_with_serial',
            'businessmanagement.sales_register.product_wise_sales_with_serial',
            'businessmanagement.sales_register.daily_sales_details',
            
            // Stock Register Reports
            'businessmanagement.stock_register.current_stock_combined',
            'businessmanagement.stock_register.current_stock_c',
            'businessmanagement.stock_register.current_stock_with_serial',
            'businessmanagement.stock_register.combined_current_stock_all_br_summary',
            'businessmanagement.stock_register.date_wise_product_status',
            'businessmanagement.stock_register.date_wise_stock',
            'businessmanagement.stock_register.product_price_list',
            'businessmanagement.stock_register.supplier_wise_current_stock',
            'businessmanagement.stock_register.date_wise_product_in_out_statement',
            'businessmanagement.stock_register.date_wise_stock_serial_m',
            
            // Accounts Register Reports
            'businessmanagement.accounts_register.due_list',
            'businessmanagement.accounts_register.all_customers_due_list',
            'businessmanagement.accounts_register.supplier_due_list',
            'businessmanagement.accounts_register.customer_accounts_ledger',
            'businessmanagement.accounts_register.cash_book',
            'businessmanagement.accounts_register.date_wise_credit_voucher',
            'businessmanagement.accounts_register.date_wise_debit_voucher',
            'businessmanagement.accounts_register.income_statement',
            'businessmanagement.accounts_register.day_book',
            'businessmanagement.accounts_register.due_list_without_treatment',
            'businessmanagement.accounts_register.date_wise_sales_received',
            'businessmanagement.accounts_register.balance_sheet',
            'businessmanagement.accounts_register.date_wise_general_expenses',
            'businessmanagement.accounts_register.accounts_receivable',
            'businessmanagement.accounts_register.accounts_payable',
            'businessmanagement.accounts_register.customer_due_with_ageing',
            'businessmanagement.accounts_register.cash_flows',
            'businessmanagement.accounts_register.date_wise_receipt_payment_statement',
            'businessmanagement.accounts_register.date_wise_receive',
            'businessmanagement.accounts_register.date_wise_sales_with_profit',
        ];

        foreach ($permissions as $permission) {
            $existing = DB::table('permissions')
                ->where('name', $permission)
                ->first();

            if (!$existing) {
                DB::table('permissions')->insert([
                    'name' => $permission,
                    'guard_name' => 'web',
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $permissions = [
            // Purchase Register Reports
            'businessmanagement.purchase_register.date_wise_purchase',
            'businessmanagement.purchase_register.supplier_wise_purchase',
            'businessmanagement.purchase_register.supplier_wise_purchase_wop',
            'businessmanagement.purchase_register.product_wise_purchase',
            'businessmanagement.purchase_register.product_wise_purchase_wop',
            'businessmanagement.purchase_register.location_wise_net_product_purchase',
            'businessmanagement.purchase_register.date_wise_net_product_purchase',
            'businessmanagement.purchase_register.supplier_wise_statement',
            'businessmanagement.purchase_register.supplier_and_product_wise_purchase',
            'businessmanagement.purchase_register.purchased_product_movement',
            'businessmanagement.purchase_register.supplier_wise_purchase_return',
            'businessmanagement.purchase_register.date_wise_purchase_return',
            'businessmanagement.purchase_register.product_wise_purchase_return',
            'businessmanagement.purchase_register.date_wise_purchase_order',
            'businessmanagement.purchase_register.supplier_wise_purchase_order',
            
            // Sales Register Reports
            'businessmanagement.sales_register.date_wise_sales',
            'businessmanagement.sales_register.product_wise_sales',
            'businessmanagement.sales_register.customer_wise_sales',
            'businessmanagement.sales_register.date_wise_net_product_sales',
            'businessmanagement.sales_register.customer_wise_net_product_sales',
            'businessmanagement.sales_register.date_wise_gross_profit',
            'businessmanagement.sales_register.product_wise_gross_profit',
            'businessmanagement.sales_register.date_wise_sales_return',
            'businessmanagement.sales_register.product_wise_sales_return',
            'businessmanagement.sales_register.customer_wise_sales_return',
            'businessmanagement.sales_register.explicit_product_wise_sales',
            'businessmanagement.sales_register.customer_wise_statement',
            'businessmanagement.sales_register.product_group_wise_net_sales',
            'businessmanagement.sales_register.product_wise_sales_summary',
            'businessmanagement.sales_register.date_wise_sales_summary',
            'businessmanagement.sales_register.product_group_wise_net_sales_mpo',
            'businessmanagement.sales_register.customer_wise_sales_summary',
            'businessmanagement.sales_register.customer_wise_invoice_status',
            'businessmanagement.sales_register.date_wise_sales_invoice',
            'businessmanagement.sales_register.customer_wise_gross_profit',
            'businessmanagement.sales_register.product_wise_net_profit',
            'businessmanagement.sales_register.customer_wise_sales_with_serial',
            'businessmanagement.sales_register.product_wise_sales_with_serial',
            'businessmanagement.sales_register.daily_sales_details',
            
            // Stock Register Reports
            'businessmanagement.stock_register.current_stock_combined',
            'businessmanagement.stock_register.current_stock_c',
            'businessmanagement.stock_register.current_stock_with_serial',
            'businessmanagement.stock_register.combined_current_stock_all_br_summary',
            'businessmanagement.stock_register.date_wise_product_status',
            'businessmanagement.stock_register.date_wise_stock',
            'businessmanagement.stock_register.product_price_list',
            'businessmanagement.stock_register.supplier_wise_current_stock',
            'businessmanagement.stock_register.date_wise_product_in_out_statement',
            'businessmanagement.stock_register.date_wise_stock_serial_m',
            
            // Accounts Register Reports
            'businessmanagement.accounts_register.due_list',
            'businessmanagement.accounts_register.all_customers_due_list',
            'businessmanagement.accounts_register.supplier_due_list',
            'businessmanagement.accounts_register.customer_accounts_ledger',
            'businessmanagement.accounts_register.cash_book',
            'businessmanagement.accounts_register.date_wise_credit_voucher',
            'businessmanagement.accounts_register.date_wise_debit_voucher',
            'businessmanagement.accounts_register.income_statement',
            'businessmanagement.accounts_register.day_book',
            'businessmanagement.accounts_register.due_list_without_treatment',
            'businessmanagement.accounts_register.date_wise_sales_received',
            'businessmanagement.accounts_register.balance_sheet',
            'businessmanagement.accounts_register.date_wise_general_expenses',
            'businessmanagement.accounts_register.accounts_receivable',
            'businessmanagement.accounts_register.accounts_payable',
            'businessmanagement.accounts_register.customer_due_with_ageing',
            'businessmanagement.accounts_register.cash_flows',
            'businessmanagement.accounts_register.date_wise_receipt_payment_statement',
            'businessmanagement.accounts_register.date_wise_receive',
            'businessmanagement.accounts_register.date_wise_sales_with_profit',
        ];

        foreach ($permissions as $permission) {
            $permissionRecord = DB::table('permissions')
                ->where('name', $permission)
                ->first();
            
            if ($permissionRecord) {
                // Remove from role_has_permissions
                DB::table('role_has_permissions')
                    ->where('permission_id', $permissionRecord->id)
                    ->delete();
                
                // Remove from model_has_permissions
                DB::table('model_has_permissions')
                    ->where('permission_id', $permissionRecord->id)
                    ->delete();
                
                // Remove permission itself
                DB::table('permissions')
                    ->where('id', $permissionRecord->id)
                    ->delete();
            }
        }
    }
}

