# BusinessManagement Module - Deployment Checklist

**Version:** 1.0.1  
**Deployment Date:** _______________  
**Deployed By:** _______________

---

## Pre-Deployment Checklist

### ✅ Code Review

- [ ] All security fixes applied
- [ ] All location validation implemented
- [ ] Code reviewed and approved
- [ ] No linter errors
- [ ] No syntax errors
- [ ] Code follows UltimatePOS conventions

### ✅ Testing

- [ ] Unit tests written
- [ ] Security tests pass
- [ ] Performance tests pass
- [ ] Functional tests pass
- [ ] Manual testing completed
- [ ] Multi-location testing completed
- [ ] Test results documented

### ✅ Documentation

- [ ] Security review documented
- [ ] Performance guide created
- [ ] Developer guide created
- [ ] Testing guide created
- [ ] Migration guide created

---

## Step 1: Backup Production Database

### 1.1 Create Full Database Backup

```bash
# MySQL
mysqldump -u username -p database_name > backup_$(date +%Y%m%d_%H%M%S).sql

# PostgreSQL
pg_dump -U username database_name > backup_$(date +%Y%m%d_%H%M%S).sql
```

### 1.2 Verify Backup

```bash
# Check backup file exists and has content
ls -lh backup_*.sql
```

### 1.3 Store Backup Securely

- [ ] Backup stored in secure location
- [ ] Backup accessible for restore if needed
- [ ] Backup retention policy followed

---

## Step 2: Deploy to Staging Environment

### 2.1 Pull Latest Code

```bash
cd /path/to/staging
git pull origin main
# or
git checkout feature/business-management-fixes
```

### 2.2 Install Dependencies

```bash
composer install --no-dev --optimize-autoloader
```

### 2.3 Run Migrations

```bash
# Run all migrations
php artisan migrate

# Run module migrations specifically
php artisan module:migrate BusinessManagement

# Verify migrations
php artisan migrate:status
```

### 2.4 Clear Caches

```bash
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
php artisan optimize
```

### 2.5 Verify Module Status

```bash
php artisan module:list
# Verify BusinessManagement is active
```

---

## Step 3: Staging Environment Testing

### 3.1 Verify Database Indexes

```sql
-- MySQL
SHOW INDEXES FROM transactions WHERE Key_name LIKE 'idx_%';

-- Verify all indexes are created
-- Should see:
-- idx_transactions_business_location_type
-- idx_transactions_business_date
-- idx_transactions_location_date
-- etc.
```

### 3.2 Test Location Access

1. Create test user with restricted location access
2. Test accessing unauthorized location
3. Verify 403 error is returned
4. Test accessing authorized location
5. Verify data is shown correctly

### 3.3 Test All Reports

- [ ] Purchase Register - All reports work
- [ ] Sales Register - All reports work
- [ ] Stock Register - All reports work
- [ ] Accounts Register - All reports work
- [ ] Print views render correctly
- [ ] DataTables AJAX works

### 3.4 Performance Testing

- [ ] Reports load in acceptable time (< 2-3 seconds)
- [ ] No timeout errors
- [ ] Memory usage is reasonable
- [ ] Database queries are optimized

### 3.5 User Acceptance Testing

- [ ] Test with actual users
- [ ] Gather feedback
- [ ] Document any issues
- [ ] Get approval for production deployment

---

## Step 4: Production Deployment

### 4.1 Maintenance Mode (Optional)

```bash
php artisan down --message="Deploying BusinessManagement module updates"
```

**Note:** Only if deployment might cause brief downtime

### 4.2 Deploy Code

```bash
cd /path/to/production
git pull origin main
# or specific branch
git checkout release/business-management-v1.0.1
```

### 4.3 Install Dependencies

```bash
composer install --no-dev --optimize-autoloader
```

### 4.4 Run Migrations

```bash
# IMPORTANT: Run migrations during low-traffic period
php artisan migrate

# Run module migrations
php artisan module:migrate BusinessManagement

# Verify
php artisan migrate:status
```

### 4.5 Clear Caches

```bash
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
php artisan optimize
```

### 4.6 Disable Maintenance Mode

```bash
php artisan up
```

---

## Step 5: Post-Deployment Verification

### 5.1 Verify Module is Active

```bash
php artisan module:list
# Check BusinessManagement is listed and active
```

### 5.2 Verify Permissions

```sql
-- Check permissions are created
SELECT * FROM permissions WHERE name LIKE 'businessmanagement.%';

-- Should see all permissions:
-- businessmanagement.view
-- businessmanagement.purchase_register
-- businessmanagement.sales_register
-- businessmanagement.stock_register
-- businessmanagement.accounts_register
-- Plus all report-specific permissions
```

### 5.3 Verify Indexes

```sql
-- Check indexes are created
SHOW INDEXES FROM transactions WHERE Key_name LIKE 'idx_%';

-- Verify critical indexes exist
```

### 5.4 Smoke Tests

1. **Login as Admin**
   - Navigate to Business Management menu
   - Verify menu items appear
   - Access each register
   - Verify reports load

2. **Test Location Access**
   - Create restricted user
   - Test unauthorized location access
   - Verify 403 error
   - Test authorized location access
   - Verify data shown

3. **Test Reports**
   - Run a few sample reports
   - Verify data accuracy
   - Test print functionality
   - Verify no errors

### 5.5 Monitor Logs

```bash
# Watch for errors
tail -f storage/logs/laravel.log

# Check for any 403 errors (should be expected for unauthorized access)
# Check for any 500 errors (should NOT occur)
```

---

## Step 6: Assign Permissions

### 6.1 Assign Module Permissions to Roles

```php
// Via tinker or admin panel
$role = Role::find(1); // Admin role
$role->givePermissionTo([
    'businessmanagement.view',
    'businessmanagement.purchase_register',
    'businessmanagement.sales_register',
    'businessmanagement.stock_register',
    'businessmanagement.accounts_register',
]);

// Assign specific report permissions as needed
$role->givePermissionTo([
    'businessmanagement.purchase_register.date_wise_purchase',
    'businessmanagement.sales_register.date_wise_sales',
    // ... other specific permissions
]);
```

### 6.2 Verify Permissions

- [ ] Admin role has all permissions
- [ ] Manager role has appropriate permissions
- [ ] Staff roles have limited permissions
- [ ] Permissions are correctly assigned

---

## Step 7: User Communication

### 7.1 Notify Users

- [ ] Send email notification about new features
- [ ] Update user documentation
- [ ] Provide training if needed
- [ ] Share changelog/release notes

### 7.2 Documentation Updates

- [ ] Update user manual
- [ ] Update admin guide
- [ ] Update API documentation (if applicable)
- [ ] Update changelog

---

## Step 8: Monitoring

### 8.1 Monitor for Issues

**First 24 Hours:**
- Monitor error logs
- Check for performance issues
- Monitor user feedback
- Check database performance

**First Week:**
- Review error logs daily
- Monitor report generation times
- Check user adoption
- Gather feedback

### 8.2 Key Metrics to Monitor

- Error rate (should be 0%)
- Report generation time
- Database query performance
- User access patterns
- Permission-related errors

---

## Rollback Plan

### If Issues Occur

1. **Immediate Rollback**

```bash
# Restore database backup
mysql -u username -p database_name < backup_YYYYMMDD_HHMMSS.sql

# Revert code
git checkout previous-stable-version
composer install
php artisan optimize
```

2. **Partial Rollback**

```bash
# Rollback only module migrations
php artisan module:migrate:rollback BusinessManagement

# Keep code but disable module
# Edit module.json: "active": 0
```

3. **Contact Points**

- Development team lead
- Database administrator
- System administrator

---

## Deployment Sign-Off

### Pre-Deployment

- [ ] Code reviewed: _______________
- [ ] Tests passed: _______________
- [ ] Backup created: _______________
- [ ] Staging tested: _______________

### Post-Deployment

- [ ] Deployment completed: _______________
- [ ] Verification passed: _______________
- [ ] Permissions assigned: _______________
- [ ] Monitoring active: _______________

### Approval

- **Deployed By:** _______________
- **Approved By:** _______________
- **Date:** _______________
- **Time:** _______________

---

## Post-Deployment Tasks

### Immediate (Day 1)

- [ ] Monitor error logs
- [ ] Verify all reports working
- [ ] Check user feedback
- [ ] Document any issues

### Short-term (Week 1)

- [ ] Review performance metrics
- [ ] Gather user feedback
- [ ] Address any issues
- [ ] Update documentation

### Long-term (Month 1)

- [ ] Performance review
- [ ] User adoption review
- [ ] Plan improvements
- [ ] Schedule next review

---

## Emergency Contacts

- **Development Team:** _______________
- **Database Admin:** _______________
- **System Admin:** _______________
- **Project Manager:** _______________

---

## Notes

_Add any deployment-specific notes here:_

---

**Deployment Status:** ✅ COMPLETE / ⏳ IN PROGRESS / ❌ FAILED

**Deployment Date:** _______________

**Deployed By:** _______________

