<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Current Stock (Combined)</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 15px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            font-size: 9pt;
        }
        
        table thead {
            background-color: #f5f5f5;
        }
        
        table th {
            border: 1px solid #ddd;
            padding: 6px 4px;
            text-align: left;
            font-weight: 600;
            font-size: 9pt;
        }
        
        table th:first-child {
            text-align: left;
        }
        
        table th:nth-child(2),
        table th:nth-child(4),
        table th:nth-child(5) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #ddd;
            padding: 5px 4px;
            font-size: 9pt;
        }
        
        table td:first-child {
            text-align: left;
        }
        
        table td:nth-child(2),
        table td:nth-child(4),
        table td:nth-child(5) {
            text-align: right;
        }
        
        .category-header {
            font-size: 11pt;
            font-weight: 700;
            margin-top: 15px;
            margin-bottom: 8px;
            color: #1a1a1a;
        }
        
        .brand-header {
            font-size: 10pt;
            font-weight: 600;
            margin-top: 10px;
            margin-bottom: 5px;
            padding-left: 10px;
            color: #2c3e50;
        }
        
        .subtotal-row {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        
        .group-subtotal-row {
            background-color: #e9ecef;
            font-weight: 700;
        }
        
        .grand-total-row {
            background-color: #d4edda;
            font-weight: 700;
            font-size: 11pt;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->landmark ?? '' }}, {{ $business->city ?? '' }}, {{ $business->state ?? '' }}, {{ $business->country ?? '' }}</div>
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div>Cell: {{ $business->mobile }}</div>
                @endif
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Current Stock (Combined)</div>
        
        <!-- Report Content -->
        @if(count($grouped_data) > 0)
            @foreach($grouped_data as $category_name => $brands)
                <div class="category-header">{{ $category_name }}</div>
                
                @foreach($brands as $brand_name => $items)
                    <div class="brand-header">{{ $brand_name }}</div>
                    <table>
                        <thead>
                            <tr>
                                <th>Product Model</th>
                                <th class="text-right">Qty</th>
                                <th>UoM</th>
                                <th class="text-right">Unit Cost</th>
                                <th class="text-right">Total Cost</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $brand_total_qty = 0;
                                $brand_total_cost = 0;
                            @endphp
                            @foreach($items as $item)
                                @php
                                    $brand_total_qty += $item->qty;
                                    $brand_total_cost += $item->total_cost;
                                @endphp
                                <tr>
                                    <td>{{ $item->product_description }}</td>
                                    <td class="text-right">{{ $util->num_f($item->qty, false, null, true) }}</td>
                                    <td>{{ $item->unit_name ?? 'PCS' }}</td>
                                    <td class="text-right">{{ $util->num_f($item->unit_cost, true) }}</td>
                                    <td class="text-right">{{ $util->num_f($item->total_cost, true) }}</td>
                                </tr>
                            @endforeach
                            <tr class="subtotal-row">
                                <td><strong>Brand Sub Total ({{ $brand_name }})</strong></td>
                                <td class="text-right"><strong>{{ $util->num_f($brand_total_qty, false, null, true) }}</strong></td>
                                <td></td>
                                <td></td>
                                <td class="text-right"><strong>{{ $util->num_f($brand_total_cost, true) }}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                @endforeach
                
                @php
                    $category_total_qty = 0;
                    $category_total_cost = 0;
                    foreach($brands as $brand_items) {
                        foreach($brand_items as $item) {
                            $category_total_qty += $item->qty;
                            $category_total_cost += $item->total_cost;
                        }
                    }
                @endphp
                <table>
                    <tbody>
                        <tr class="group-subtotal-row">
                            <td><strong>Group Sub Total</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_qty, false, null, true) }}</strong></td>
                            <td></td>
                            <td></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_cost, true) }}</strong></td>
                        </tr>
                    </tbody>
                </table>
            @endforeach
            
            <table style="margin-top: 15px;">
                <tbody>
                    <tr class="grand-total-row">
                        <td><strong>Grand Total</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_qty, false, null, true) }}</strong></td>
                        <td></td>
                        <td></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_cost, true) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        @else
            <div class="no-data">No stock data found for the selected filters.</div>
        @endif
    </div>
</body>
</html>

