@extends('layouts.app')
@section('title', __('businessmanagement::lang.current_stock_combined'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.current_stock_combined') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockCombined']), 'method' => 'get', 'id' => 'current_stock_combined_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @php
                            $date_range_value = '';
                            if (!empty($start_date) && !empty($end_date)) {
                                $date_range_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y') . ' ~ ' . \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } elseif (!empty(request()->date_range)) {
                                $date_range_value = request()->date_range;
                            }
                        @endphp
                        {!! Form::text('date_range', $date_range_value , ['placeholder' => __('businessmanagement::lang.select_a_date_range'), 'class' => 'form-control', 'id' => 'current_stock_combined_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('businessmanagement::lang.all_categories'), 'single' => __('businessmanagement::lang.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('businessmanagement::lang.all_products'), 'single' => __('businessmanagement::lang.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockCombined']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printCurrentStockCombined'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $category_name => $brands)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; font-weight: bold; color: #2c3e50;">{{ $category_name }}</h4>
                            @foreach($brands as $brand_name => $items)
                                <h5 style="margin-top: 15px; margin-bottom: 10px; font-weight: 600; color: #34495e; padding-left: 10px;">{{ $brand_name }}</h5>
                                <table class="table table-bordered table-striped" style="font-size: 12px;">
                                    <thead>
                                        <tr>
                                            <th>Product Model</th>
                                            <th style="text-align: right;">Qty</th>
                                            <th>UoM</th>
                                            <th style="text-align: right;">Unit Cost</th>
                                            <th style="text-align: right;">Total Cost</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $brand_total_qty = 0;
                                            $brand_total_cost = 0;
                                        @endphp
                                        @foreach($items as $item)
                                            @php
                                                $brand_total_qty += $item->qty;
                                                $brand_total_cost += $item->total_cost;
                                            @endphp
                                            <tr>
                                                <td>{{ $item->product_description }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($item->qty, false, null, true) }}</td>
                                                <td>{{ $item->unit_name ?? 'PCS' }}</td>
                                                <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->unit_cost }}</span></td>
                                                <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->total_cost }}</span></td>
                                            </tr>
                                        @endforeach
                                        <tr style="background-color: #f8f9fa; font-weight: bold;">
                                            <td><strong>Brand Sub Total ({{ $brand_name }})</strong></td>
                                            <td style="text-align: right;"><strong>{{ $util->num_f($brand_total_qty, false, null, true) }}</strong></td>
                                            <td></td>
                                            <td></td>
                                            <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $brand_total_cost }}</span></strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            @endforeach
                            @php
                                $category_total_qty = 0;
                                $category_total_cost = 0;
                                foreach($brands as $brand_items) {
                                    foreach($brand_items as $item) {
                                        $category_total_qty += $item->qty;
                                        $category_total_cost += $item->total_cost;
                                    }
                                }
                            @endphp
                            <table class="table table-bordered" style="font-size: 12px; margin-bottom: 30px;">
                                <tbody>
                                    <tr style="background-color: #e9ecef; font-weight: bold;">
                                        <td><strong>Group Sub Total</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty, false, null, true) }}</strong></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $category_total_cost }}</span></strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <tbody>
                                <tr style="background-color: #d4edda; font-weight: bold; font-size: 16px;">
                                    <td><strong>Grand Total</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty, false, null, true) }}</strong></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $grand_total_cost }}</span></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No stock data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#current_stock_combined_date_range').daterangepicker({
            autoUpdateInput: false,
            locale: {
                format: 'DD/MM/YYYY',
                separator: ' ~ ',
            }
        });

        $('#current_stock_combined_date_range').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD/MM/YYYY') + ' ~ ' + picker.endDate.format('DD/MM/YYYY'));
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });

        $('#current_stock_combined_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#current_stock_combined_filter_form').on('submit', function() {
            var date_range = $('#current_stock_combined_date_range').val();
            if (date_range) {
                var dates = date_range.split(' ~ ');
                if (dates.length == 2) {
                    var start_date = moment(dates[0], 'DD/MM/YYYY').format('YYYY-MM-DD');
                    var end_date = moment(dates[1], 'DD/MM/YYYY').format('YYYY-MM-DD');
                    $('input[name="start_date"]').val(start_date);
                    $('input[name="end_date"]').val(end_date);
                }
            }
        });
    });
</script>
@endsection

