<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Product Wise Sales with Serial</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Product Section */
        .product-section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        
        .product-header {
            font-size: 13pt;
            font-weight: bold;
            margin-bottom: 10px;
            text-align: center;
            color: #1a1a1a;
            padding: 5px 0;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0 0 15px 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tfoot {
            display: table-footer-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
            border-bottom: 1px dotted #999;
        }
        
        .text-right {
            text-align: right !important;
        }
        
        /* Subtotal Row */
        .subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: bold;
            border-bottom: 1px solid #2c3e50 !important;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 7px 6px;
            border-bottom: 1px solid #2c3e50 !important;
        }
        
        /* Footer */
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 8pt;
            color: #6a6a6a;
            text-align: center;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .product-section {
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            thead {
                display: table-header-group;
            }
            
            tfoot {
                display: table-footer-group;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->phone))
                    <div class="company-contact">{{ $business->phone }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Product Wise Sales with Serial</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Report Content -->
        @if(count($products_data) > 0)
            @foreach($products_data as $product_id_key => $product_data)
                <div class="product-section">
                    <div class="product-header">{{ $product_data['product_name'] }}</div>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>Invoice No</th>
                                <th>Product Description</th>
                                <th>Customer Name</th>
                                <th>Ref. No.</th>
                                <th style="text-align: right;">Qty</th>
                                <th style="text-align: right;">Unit Price</th>
                                <th style="text-align: right;">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($product_data['lines'] as $line)
                                <tr>
                                    <td>{{ $util->format_date($line['transaction_date'], false) }} {{ $line['invoice_no'] }}</td>
                                    <td>{{ $line['product_description'] }}</td>
                                    <td>{{ $line['customer_name'] }}</td>
                                    <td>{{ $line['ref_no'] }}</td>
                                    <td class="text-right">{{ number_format($line['qty'], 2) }}</td>
                                    <td class="text-right">{{ $util->num_f($line['unit_price'], true) }}</td>
                                    <td class="text-right">{{ $util->num_f($line['amount'], true) }}</td>
                                </tr>
                            @endforeach
                            <tr class="subtotal-row">
                                <td colspan="4"><strong>Sub Total:</strong></td>
                                <td class="text-right">{{ number_format($product_data['product_total_qty'], 2) }}</td>
                                <td class="text-right">-</td>
                                <td class="text-right">{{ $util->num_f($product_data['product_total_amount'], true) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endforeach
        @endif

        <!-- Footer -->
        <div class="footer">
            <div>{{ date('m/d/Y h:i:sA') }}</div>
        </div>
    </div>
</body>
</html>

