@extends('layouts.app')
@section('title', 'Daily Sales Details')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Daily Sales Details</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dailySalesDetails']), 'method' => 'get', 'id' => 'daily_sales_details_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @php
                            $date_range_value = '';
                            if (!empty($start_date) && !empty($end_date)) {
                                $date_range_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y') . ' ~ ' . \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } elseif (!empty(request()->date_range)) {
                                $date_range_value = request()->date_range;
                            }
                        @endphp
                        {!! Form::text('date_range', $date_range_value , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'daily_sales_details_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dailySalesDetails']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDailySalesDetails'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($customers_data) > 0)
                        <table class="table table-bordered table-striped" style="font-size: 12px;">
                            <thead>
                                <tr>
                                    <th>Customer Name</th>
                                    <th>Product Description</th>
                                    <th>Invoice No</th>
                                    <th style="text-align: right;">Qty</th>
                                    <th style="text-align: right;">Rate</th>
                                    <th style="text-align: right;">Total Amount</th>
                                    <th style="text-align: right;">Service Charges</th>
                                    <th style="text-align: right;">Received with Cheque</th>
                                    <th style="text-align: right;">Prev. Balance</th>
                                    <th style="text-align: right;">Balance</th>
                                    <th>Narration</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customers_data as $contact_id => $customer_data)
                                    @foreach($customer_data['lines'] as $line)
                                        <tr>
                                            <td>{{ $customer_data['customer_name'] }}</td>
                                            <td>{{ $line['product_description'] }}</td>
                                            <td>{{ $line['invoice_no'] }}</td>
                                            <td style="text-align: right;">{{ number_format($line['qty'], 2) }} {{ strtoupper($line['unit_name'] ?? 'PCS') }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($line['rate'], true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($line['line_total'], true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f(0, true) }}</td>
                                            <td style="text-align: right;">-</td>
                                            <td style="text-align: right;">-</td>
                                            <td style="text-align: right;">-</td>
                                            <td>-</td>
                                        </tr>
                                    @endforeach
                                    <tr style="background-color: #f5f5f5; font-weight: bold;">
                                        <td colspan="3"><strong>Sub Total:</strong></td>
                                        <td style="text-align: right;">{{ number_format($customer_data['customer_total_qty'], 2) }}</td>
                                        <td style="text-align: right;">-</td>
                                        <td style="text-align: right;">{{ $util->num_f($customer_data['customer_total_amount'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($customer_data['customer_service_charges'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($customer_data['received_with_cheque'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($customer_data['prev_balance'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($customer_data['current_balance'], true) }}</td>
                                        <td>-</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        var date_range_val = '{{ $date_range_value ?? "" }}';

        if (date_range_val) {
            $('#daily_sales_details_date_range').val(date_range_val);
        } else if (start_date && end_date) {
            $('#daily_sales_details_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#daily_sales_details_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#daily_sales_details_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#daily_sales_details_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Reload when date range changes
        $('#daily_sales_details_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });

        // Ensure hidden fields are set before form submission
        $('#daily_sales_details_filter_form').on('submit', function(e) {
            var date_range_val = $('#daily_sales_details_date_range').val();
            if (date_range_val) {
                var dates = date_range_val.split(' ~ ');
                if (dates.length == 2) {
                    var start = moment(dates[0].trim(), moment_date_format);
                    var end = moment(dates[1].trim(), moment_date_format);
                    if (start.isValid() && end.isValid()) {
                        $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                        $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
                    }
                }
            } else {
                $('input[name="start_date"]').val('');
                $('input[name="end_date"]').val('');
            }
        });
    });
</script>
@endsection

