@extends('layouts.app')
@section('title', 'Product wise Purchase Return')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Product wise Purchase Return</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'product_wise_purchase_return_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_wise_purchase_return_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', 'Product Filter:') !!}
                        {!! Form::select('product_filter', ['all' => 'All Product', 'category' => 'Category', 'single' => 'Single Product'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('category_id',  __('product.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_categories'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('product_id',  __('sale.product') . ':') !!}
                        {!! Form::select('product_id', $products_array, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="product_wise_purchase_return_table">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Return ID</th>
                                <th>Supplier Name</th>
                                <th>Qty</th>
                                <th>Unit Price</th>
                                <th>Net Unit Price</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#product_wise_purchase_return_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#product_wise_purchase_return_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }
        );

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#product_wise_purchase_return_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Show/hide category/product select based on filter
        $('#product_filter').on('change', function() {
            var filter_value = $(this).val();
            if (filter_value == 'category') {
                $('#category_select_container').show();
                $('#product_select_container').hide();
                $('#product_id').val(null).trigger('change');
            } else if (filter_value == 'single') {
                $('#product_select_container').show();
                $('#category_select_container').hide();
                $('#category_id').val(null).trigger('change');
            } else {
                $('#category_select_container').hide();
                $('#product_select_container').hide();
                $('#category_id').val(null).trigger('change');
                $('#product_id').val(null).trigger('change');
            }
            product_wise_purchase_return_table.ajax.reload();
        });

        // Initialize DataTable
        var product_wise_purchase_return_table = $('#product_wise_purchase_return_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "productWisePurchaseReturn"]) }}',
                data: function(d) {
                    d.product_filter = $('#product_filter').val();
                    d.category_id = '';
                    d.product_id = '';
                    if ($('#product_filter').val() == 'category') {
                        d.category_id = $('#category_id').val() || '';
                    } else if ($('#product_filter').val() == 'single') {
                        d.product_id = $('#product_id').val() || '';
                    }
                    d.location_id = $('#location_id').val();
                    if ($('#product_wise_purchase_return_date_range').val()) {
                        var start = $('#product_wise_purchase_return_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#product_wise_purchase_return_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'product_name', name: 'product_name' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'quantity', name: 'quantity' },
                { data: 'unit_price', name: 'unit_price' },
                { data: 'net_unit_price', name: 'net_unit_price' },
                { data: 'amount', name: 'amount' },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#product_wise_purchase_return_table'));
            },
        });

        // Apply filters
        $('#apply_filters').on('click', function() {
            product_wise_purchase_return_table.ajax.reload();
            setTimeout(checkPrintButton, 500);
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#product_filter').val('all').trigger('change');
            $('#category_id').val('').trigger('change');
            $('#product_id').val('').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#product_wise_purchase_return_date_range').val('');
            $('#print_report').hide();
            product_wise_purchase_return_table.ajax.reload();
        });

        // Print report
        $('#print_report').on('click', function() {
            var date_range = $('#product_wise_purchase_return_date_range').val();
            var product_filter = $('#product_filter').val();
            var category_id = $('#category_id').val();
            var product_id = $('#product_id').val();
            var location_id = $('#location_id').val();

            var url = "{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printProductWisePurchaseReturn']) }}";
            url += '?date_range=' + encodeURIComponent(date_range);
            url += '&product_filter=' + product_filter;
            if (category_id) {
                url += '&category_id=' + category_id;
            }
            if (product_id) {
                url += '&product_id=' + product_id;
            }
            if (location_id) {
                url += '&location_id=' + location_id;
            }

            window.open(url, '_blank');
        });

        // Update date range picker callback
        $('#product_wise_purchase_return_date_range').on('apply.daterangepicker', function(ev, picker) {
            checkPrintButton();
        });

        $('#product_wise_purchase_return_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            checkPrintButton();
        });

        // Filter change handlers
        $('#category_id, #product_id, #location_id').on('change', function() {
            product_wise_purchase_return_table.ajax.reload();
        });

        // Initial check
        checkPrintButton();
    });
</script>
@endsection

