<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Supplier wise Purchase Order</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 15px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #2c3e50;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td:nth-child(1),
        table tbody td:nth-child(2),
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(7) {
            text-align: left;
        }
        
        table tbody td:nth-child(6) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        /* Supplier Header Row */
        .supplier-header-row {
            background-color: #e9ecef !important;
            font-weight: 600;
        }
        
        .supplier-header-row td {
            border: 1px solid #2c3e50;
            color: #1a1a1a;
            padding: 8px 5px;
        }
        
        /* Summary Row */
        .summary-row {
            background-color: #f8f9fa !important;
            font-weight: 600;
        }
        
        .summary-row td {
            border: 1px solid #2c3e50;
            color: #1a1a1a;
            padding: 7px 5px;
        }
        
        .summary-row td:nth-child(6) {
            text-align: right;
        }
        
        /* Grand Total Row */
        .grandtotal-row {
            border-top: 3px double #2c3e50;
        }
        
        .grandtotal-row td {
            border: 1px solid #2c3e50;
            border-bottom: 3px double #2c3e50;
            color: #1a1a1a;
            padding: 8px 5px;
            font-weight: 700;
        }
        
        .grandtotal-row td:nth-child(6) {
            text-align: right;
        }
        
        /* Footer */
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            text-align: left;
            font-size: 9pt;
            color: #6a6a6a;
        }
        
        @media print {
            .supplier-section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if($logo)
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if($business->landmark)
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if($business->city || $business->state || $business->country)
                    <div class="company-address">
                        @if($business->city){{ $business->city }}, @endif
                        @if($business->state){{ $business->state }}, @endif
                        @if($business->country){{ $business->country }}@endif
                    </div>
                @endif
                @if($business->mobile)
                    <div class="company-contact">Phone: {{ $business->mobile }}</div>
                @endif
                @if($business->email)
                    <div class="company-contact">Email: {{ $business->email }}</div>
                @endif
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Supplier wise Purchase Order</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if($start_date && $end_date)
                {{ $util->format_date($start_date, true) }} To {{ $util->format_date($end_date, true) }}
            @else
                All Time
            @endif
        </div>
        
        @if(empty($grouped_data) || count($grouped_data) == 0)
            <div style="text-align: center; padding: 40px; color: #6a6a6a; font-size: 12pt;">
                <p><strong>No data found for the selected criteria.</strong></p>
                <p>Please adjust your filters and try again.</p>
            </div>
        @else
        <!-- Table -->
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th style="width: 12%;">Order No</th>
                        <th style="width: 18%;">Supplier Name</th>
                        <th style="width: 15%;">Requisition No</th>
                        <th style="width: 15%;">Product Group</th>
                        <th style="width: 25%;">Product Description</th>
                        <th style="width: 10%;">Quantity</th>
                        <th style="width: 5%;">Unit</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $current_supplier = null;
                    @endphp
                    @foreach($grouped_data as $supplier_key => $supplier_group)
                        @if($current_supplier !== $supplier_key)
                            @if($current_supplier !== null)
                                <!-- Subtotal Row for Previous Supplier -->
                                <tr class="summary-row">
                                    <td colspan="5">Subtotal :</td>
                                    <td>{{ number_format($grouped_data[$current_supplier]['supplier_total_qty'], 2) }}</td>
                                    <td></td>
                                </tr>
                            @endif
                            
                            <!-- Supplier Header Row -->
                            <tr class="supplier-header-row">
                                <td colspan="7">{{ $supplier_group['supplier_name'] }}</td>
                            </tr>
                            @php
                                $current_supplier = $supplier_key;
                            @endphp
                        @endif
                        
                        <!-- Item Rows -->
                        @foreach($supplier_group['items'] as $item)
                            <tr>
                                <td>{{ $item['order_no'] }}</td>
                                <td></td>
                                <td>{{ $item['requisition_no'] }}</td>
                                <td>{{ $item['product_group'] }}</td>
                                <td>{{ $item['product_description'] }}</td>
                                <td>{{ number_format($item['quantity'], 2) }}</td>
                                <td>{{ $item['unit'] }}</td>
                            </tr>
                        @endforeach
                    @endforeach
                    
                    @if($current_supplier !== null)
                        <!-- Subtotal Row for Last Supplier -->
                        <tr class="summary-row">
                            <td colspan="5">Subtotal :</td>
                            <td>{{ number_format($grouped_data[$current_supplier]['supplier_total_qty'], 2) }}</td>
                            <td></td>
                        </tr>
                    @endif
                    
                    <!-- Grand Total Row -->
                    <tr class="grandtotal-row">
                        <td colspan="5">Grand Total :</td>
                        <td>{{ number_format($grand_total_qty, 2) }}</td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
        @endif
        
        <!-- Footer -->
        <div class="footer">
            <div>Generated on: {{ date('d/m/Y H:i:s') }}</div>
        </div>
    </div>
</body>
</html>

