<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Location Wise Net Product Purchase</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Location Section */
        .location-section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .location-header {
            font-size: 14pt;
            font-weight: 600;
            margin-bottom: 10px;
            color: #1a1a1a;
            padding: 8px;
            background-color: #f5f7fa;
            border-left: 4px solid #2c3e50;
        }
        
        /* Category Section */
        .category-section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        
        .category-header {
            font-size: 13pt;
            font-weight: 600;
            margin-bottom: 8px;
            color: #1a1a1a;
            padding: 6px;
            background-color: #e9ecef;
            border-left: 3px solid #17a2b8;
        }
        
        /* Brand Section */
        .brand-section {
            margin-bottom: 15px;
        }
        
        .brand-header {
            font-size: 12pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #2c3e50;
            padding: 5px;
            background-color: #f8f9fa;
            border-left: 2px solid #6c757d;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 15px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td:nth-child(1) {
            text-align: left;
        }
        
        table tbody td:nth-child(2),
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7),
        table tbody td:nth-child(8),
        table tbody td:nth-child(9),
        table tbody td:nth-child(10),
        table tbody td:nth-child(11) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        /* Brand Sub Total Row */
        .brand-total-row {
            background-color: #f8f9fa !important;
            font-weight: 600;
            border-top: 1px solid #2c3e50;
        }
        
        .brand-total-row td {
            border: 1px solid #ddd;
            color: #1a1a1a;
        }
        
        /* Group Sub Total Row */
        .group-total-row {
            background-color: #e9ecef !important;
            font-weight: 700;
            font-size: 11pt;
            border-top: 2px solid #2c3e50;
        }
        
        .group-total-row td {
            border: 1px solid #ddd;
            color: #1a1a1a;
        }
        
        /* Grand Total Row */
        .grand-total-row {
            background-color: #d0d0d0 !important;
            font-weight: 700;
            font-size: 11pt;
            border-top: 2px solid #2c3e50;
            border-bottom: 3px double #2c3e50;
        }
        
        .grand-total-row td {
            border: 1px solid #ddd;
            border-bottom: 3px double #2c3e50;
            color: #1a1a1a;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        /* Print Controls */
        .no-print {
            text-align: center;
            margin-top: 20px;
            padding: 15px;
        }
        
        .btn {
            padding: 10px 20px;
            margin: 0 5px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
        }
        
        .btn-primary {
            background-color: #007bff;
            color: #fff;
        }
        
        .btn-primary:hover {
            background-color: #0056b3;
        }
        
        .btn-default {
            background-color: #6c757d;
            color: #fff;
        }
        
        .btn-default:hover {
            background-color: #545b62;
        }
        
        /* Print Media Queries */
        @media print {
            @page {
                size: A4;
                margin: 1cm 1.5cm;
            }
            
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            
            body {
                margin: 0;
                padding: 0;
                font-size: 10pt;
            }
            
            .no-print {
                display: none !important;
            }
            
            .header {
                page-break-after: avoid;
                margin-bottom: 12px;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .report-info {
                page-break-after: avoid;
            }
            
            .location-section,
            .category-section,
            .brand-section {
                page-break-inside: avoid;
            }
            
            table thead {
                display: table-header-group;
            }
            
            table tbody tr {
                page-break-inside: avoid;
            }
            
            .brand-total-row,
            .group-total-row,
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
        
        @media screen {
            body {
                padding: 20px;
                background-color: #f5f5f5;
            }
            
            .container {
                background-color: #fff;
                padding: 30px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                max-width: 210mm;
                margin: 0 auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ __('lang_v1.mobile') }}: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ __('lang_v1.alternate_number') }}: {{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ __('business.email') }}: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Location Wise Net Product Purchase</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, true) }} To {{ $util->format_date($end_date, true) }}
            @endif
            @if(!empty($is_single_location) && !empty($location_name))
                @if(!empty($start_date) && !empty($end_date))
                    <br>
                @endif
                {{ __('sale.location') }}: {{ $location_name }}
            @endif
        </div>

        <!-- Location Sections -->
        @forelse($locations_data as $location_id => $location_data)
            <div class="location-section">
                @if(empty($is_single_location))
                    <!-- Location Header (only show when multiple locations) -->
                    <div class="location-header">
                        {{ $location_data['location_name'] }}
                    </div>
                @endif

                <!-- Category Sections -->
                @foreach($location_data['categories'] as $category_id => $category_data)
                    <div class="category-section">
                        <!-- Category Header -->
                        <div class="category-header">
                            {{ $category_data['category_name'] }}
                        </div>

                        <!-- Brand Sections -->
                        @foreach($category_data['brands'] as $brand_id => $brand_data)
                            <div class="brand-section">
                                @if(!empty($brand_data['brand_name']))
                                    <!-- Brand Header -->
                                    <div class="brand-header">
                                        {{ $brand_data['brand_name'] }}
                                    </div>
                                @endif

                                <!-- Product Table -->
                                <div class="table-container">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th style="width: 25%;">Product Model</th>
                                                <th style="width: 8%;">Purchase Qty</th>
                                                <th style="width: 9%;">Unit Price</th>
                                                <th style="width: 10%;">Purchase Amount</th>
                                                <th style="width: 8%;">Return Qty</th>
                                                <th style="width: 9%;">Return Price</th>
                                                <th style="width: 10%;">Return Amount</th>
                                                <th style="width: 8%;">Net Qty</th>
                                                <th style="width: 13%;">Net Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($brand_data['products'] as $product_key => $product_data)
                                                <tr>
                                                    <td>{{ $product_data['product_description'] }}</td>
                                                    <td class="text-right">{{ $util->num_f($product_data['purchase_qty']) }}</td>
                                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($product_data['unit_price']) }}</td>
                                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($product_data['purchase_amount']) }}</td>
                                                    <td class="text-right">{{ $util->num_f($product_data['return_qty']) }}</td>
                                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($product_data['return_price']) }}</td>
                                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($product_data['return_amount']) }}</td>
                                                    <td class="text-right">{{ $util->num_f($product_data['net_qty']) }}</td>
                                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($product_data['net_amount']) }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr class="brand-total-row">
                                                <td class="text-left"><strong>Brand wise Sub Total:</strong></td>
                                                <td class="text-right"><strong>{{ $util->num_f($brand_data['total_purchase_qty']) }}</strong></td>
                                                <td></td>
                                                <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($brand_data['total_purchase_amount']) }}</strong></td>
                                                <td class="text-right"><strong>{{ $util->num_f($brand_data['total_return_qty']) }}</strong></td>
                                                <td></td>
                                                <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($brand_data['total_return_amount']) }}</strong></td>
                                                <td class="text-right"><strong>{{ $util->num_f($brand_data['total_net_qty']) }}</strong></td>
                                                <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($brand_data['total_net_amount']) }}</strong></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        @endforeach

                        <!-- Group Sub Total -->
                        <div class="table-container" style="margin-top: 10px;">
                            <table>
                                <tfoot>
                                    <tr class="group-total-row">
                                        <td class="text-left"><strong>Group wise Sub Total:</strong></td>
                                        <td class="text-right"><strong>{{ $util->num_f($category_data['total_purchase_qty']) }}</strong></td>
                                        <td></td>
                                        <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($category_data['total_purchase_amount']) }}</strong></td>
                                        <td class="text-right"><strong>{{ $util->num_f($category_data['total_return_qty']) }}</strong></td>
                                        <td></td>
                                        <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($category_data['total_return_amount']) }}</strong></td>
                                        <td class="text-right"><strong>{{ $util->num_f($category_data['total_net_qty']) }}</strong></td>
                                        <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($category_data['total_net_amount']) }}</strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                @endforeach
            </div>
        @empty
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>{{ __('lang_v1.no_data_available') }}</p>
            </div>
        @endforelse
        
        @if(count($locations_data) > 0)
            <!-- Grand Total -->
            <div class="table-container" style="margin-top: 20px;">
                <table>
                    <tfoot>
                        <tr class="grand-total-row">
                            <td class="text-left"><strong>Grand Total:</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($grand_total_purchase_qty) }}</strong></td>
                            <td></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($grand_total_purchase_amount) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($grand_total_return_qty) }}</strong></td>
                            <td></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($grand_total_return_amount) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($grand_total_net_qty) }}</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($grand_total_net_amount) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endif
    </div>

    <!-- Print Controls -->
    <div class="no-print">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="fa fa-print"></i> {{ __('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-default">
            {{ __('messages.close') }}
        </button>
    </div>

    <script>
        window.onload = function() {
            // Optional: Auto focus for print
        };
    </script>
</body>
</html>

