@extends('layouts.app')
@section('title', 'Location Wise Net Product Purchase')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Location Wise Net Product Purchase</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'location_wise_net_product_purchase_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_filter', 'Location Filter:') !!}
                        {!! Form::select('location_filter', ['all' => 'All Location', 'single' => 'Single Location'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'location_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="location_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'location_wise_net_product_purchase_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_id',  __('product.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_categories'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', 'Product Filter:') !!}
                        {!! Form::select('product_filter', ['all' => 'All Product', 'single' => 'Single Product'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('product_id',  __('sale.product') . ':') !!}
                        {!! Form::select('product_id', $products, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_products'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="location_wise_net_product_purchase_table">
                        <thead>
                            <tr>
                                <th>@lang('sale.location')</th>
                                <th>@lang('product.category')</th>
                                <th>@lang('sale.product')</th>
                                <th>@lang('purchase.purchase_qty')</th>
                                <th>@lang('purchase.unit_price')</th>
                                <th>@lang('purchase.purchase_amount')</th>
                                <th>@lang('purchase.return_qty')</th>
                                <th>@lang('purchase.return_price')</th>
                                <th>@lang('purchase.return_amount')</th>
                                <th>@lang('purchase.net_qty')</th>
                                <th>@lang('purchase.net_amount')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#location_wise_net_product_purchase_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#location_wise_net_product_purchase_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                checkPrintButton();
            }
        );

        $('#location_wise_net_product_purchase_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            checkPrintButton();
        });

        // Show/hide location select based on filter
        $('#location_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#location_select_container').show();
            } else {
                $('#location_select_container').hide();
                $('#location_id').val('').trigger('change');
            }
        });

        // Show/hide product select based on filter
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_container').show();
            } else {
                $('#product_select_container').hide();
                $('#product_id').val('').trigger('change');
            }
        });

        // Initial state
        if ($('#location_filter').val() == 'all') {
            $('#location_select_container').hide();
        }
        if ($('#product_filter').val() == 'all') {
            $('#product_select_container').hide();
        }

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#location_wise_net_product_purchase_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Print button click
        $('#print_report').on('click', function() {
            var location_id = '';
            if ($('#location_filter').val() == 'single') {
                location_id = $('#location_id').val() || '';
            }
            var category_id = $('#category_id').val() || '';
            var product_id = '';
            if ($('#product_filter').val() == 'single') {
                product_id = $('#product_id').val() || '';
            }
            var start_date = '';
            var end_date = '';

            if ($('#location_wise_net_product_purchase_date_range').val()) {
                start_date = $('#location_wise_net_product_purchase_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#location_wise_net_product_purchase_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }

            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "printLocationWiseNetProductPurchase"]) }}';
            url += '?location_id=' + location_id;
            url += '&category_id=' + category_id;
            url += '&product_id=' + product_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;

            window.open(url, '_blank');
        });

        // Initial check
        checkPrintButton();

        // Initialize DataTable
        var location_wise_net_product_purchase_table = $('#location_wise_net_product_purchase_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "locationWiseNetProductPurchase"]) }}',
                data: function(d) {
                    d.location_id = '';
                    if ($('#location_filter').val() == 'single') {
                        d.location_id = $('#location_id').val() || '';
                    }
                    d.category_id = $('#category_id').val() || '';
                    d.product_id = '';
                    if ($('#product_filter').val() == 'single') {
                        d.product_id = $('#product_id').val() || '';
                    }
                    if ($('#location_wise_net_product_purchase_date_range').val()) {
                        var start = $('#location_wise_net_product_purchase_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#location_wise_net_product_purchase_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'location_name', name: 'location_name' },
                { data: 'category_name', name: 'category_name' },
                { data: 'product_description', name: 'product_description' },
                { data: 'purchase_qty', name: 'purchase_qty' },
                { data: 'unit_price', name: 'unit_price' },
                { data: 'purchase_amount', name: 'purchase_amount' },
                { data: 'return_qty', name: 'return_qty' },
                { data: 'return_price', name: 'return_price' },
                { data: 'return_amount', name: 'return_amount' },
                { data: 'net_qty', name: 'net_qty' },
                { data: 'net_amount', name: 'net_amount' },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#location_wise_net_product_purchase_table'));
            },
        });

        // Check on filter changes
        $('#apply_filters').on('click', function() {
            location_wise_net_product_purchase_table.ajax.reload();
            setTimeout(checkPrintButton, 500);
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#location_filter').val('all').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#category_id').val('').trigger('change');
            $('#product_filter').val('all').trigger('change');
            $('#product_id').val('').trigger('change');
            $('#location_wise_net_product_purchase_date_range').val('');
            $('#print_report').hide();
            location_wise_net_product_purchase_table.ajax.reload();
        });
    });
</script>
@endsection

