<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Customer Due with Aging</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 8pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: left;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
            text-align: left;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
            text-align: left;
        }
        
        .company-contact strong {
            font-weight: 700;
        }
        
        .report-title {
            font-size: 13pt;
            font-weight: 700;
            text-align: center;
            margin: 10px 0 5px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #1a1a1a;
            font-weight: 700;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 7pt;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: 700;
            font-size: 7pt;
            background-color: #f5f5f5;
        }
        
        table th:first-child {
            width: 40px;
        }
        
        table th:nth-child(2) {
            text-align: left;
        }
        
        table th:nth-child(3),
        table th:nth-child(5),
        table th:nth-child(6),
        table th:nth-child(8) {
            text-align: center;
        }
        
        table th:nth-child(4),
        table th:nth-child(7),
        table th:nth-child(9) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 3px 2px;
            font-size: 7pt;
        }
        
        table td:first-child {
            text-align: center;
        }
        
        table td:nth-child(2) {
            text-align: left;
        }
        
        table td:nth-child(3),
        table td:nth-child(5),
        table td:nth-child(6),
        table td:nth-child(8) {
            text-align: center;
        }
        
        table td:nth-child(4),
        table td:nth-child(7),
        table td:nth-child(9) {
            text-align: right;
        }
        
        .group-header {
            font-weight: 700;
            background-color: #f5f5f5;
        }
        
        .subtotal-row {
            font-weight: 700;
            background-color: #f8f9fa;
        }
        
        .total-row {
            font-weight: 700;
            border-top: 2px double #000;
            background-color: #f8f9fa;
        }
        
        .total-row td:last-child {
            border-top: 2px double #000;
        }
        
        .footer {
            margin-top: 10px;
            font-size: 7pt;
            text-align: center;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}{{ !empty($business->address_line_1) && !empty($business->city) ? ', ' : '' }}{{ $business->city ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city)) && !empty($business->state) ? ', ' : '' }}{{ $business->state ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city) || !empty($business->state)) && !empty($business->country) ? ', ' : '' }}{{ $business->country ?? '' }}</div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        <strong>Phone</strong> {{ $business->mobile }}
                    @endif
                    @if(!empty($business->fax))
                        <strong>Fax</strong> {{ $business->fax }}
                    @endif
                    @if(!empty($business->email))
                        <strong>Email</strong> {{ $business->email }}
                    @endif
                    @if(!empty($business->website))
                        {{ $business->website }}
                    @endif
                </div>
            </div>
            <div class="header-right">
                <!-- Empty for alignment -->
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Customer Due with Aging</div>
        <div class="report-date">{{ $util->format_date($end_date, false) }}</div>
        
        <!-- Customer Due Table -->
        <table>
            <thead>
                <tr>
                    <th>SL</th>
                    <th>Customer Name</th>
                    <th>Last Sales Date</th>
                    <th>Last Sales Amount</th>
                    <th>Days (since last sales)</th>
                    <th>Last Receipt Date</th>
                    <th>Last Receipt Amount</th>
                    <th>Days (since last receipt)</th>
                    <th>Current Due</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $serial = 1;
                @endphp
                @foreach($grouped_data as $group_name => $group_customers)
                    @if(!empty($group_name) && $group_name != 'Other')
                        <tr class="group-header">
                            <td></td>
                            <td colspan="8">{{ $group_name }}</td>
                        </tr>
                    @endif
                    @foreach($group_customers as $customer)
                        <tr>
                            <td>{{ $serial++ }}</td>
                            <td>{{ $customer->customer_name }}</td>
                            <td>{{ $customer->last_sales_date ? \Carbon\Carbon::parse($customer->last_sales_date)->format('d/m/Y') : '' }}</td>
                            <td>{{ $customer->last_sales_amount > 0 ? $util->num_f($customer->last_sales_amount, true, null) : '' }}</td>
                            <td>{{ $customer->days_since_last_sales !== null ? $customer->days_since_last_sales : '' }}</td>
                            <td>{{ $customer->last_receipt_date ? \Carbon\Carbon::parse($customer->last_receipt_date)->format('d/m/Y') : '' }}</td>
                            <td>{{ $customer->last_receipt_amount > 0 ? $util->num_f($customer->last_receipt_amount, true, null) : '' }}</td>
                            <td>{{ $customer->days_since_last_receipt !== null ? $customer->days_since_last_receipt : '' }}</td>
                            <td>{{ $util->num_f($customer->current_due, true, null) }}</td>
                        </tr>
                    @endforeach
                    @if(!empty($group_name) && $group_name != 'Other')
                        @php
                            $group_total = collect($group_customers)->sum('current_due');
                        @endphp
                        <tr class="subtotal-row">
                            <td></td>
                            <td colspan="7" style="text-align: right;">Subtotal for {{ $group_name }}</td>
                            <td>{{ $util->num_f($group_total, true, null) }}</td>
                        </tr>
                    @endif
                @endforeach
            </tbody>
            <tfoot>
                <tr class="total-row">
                    <td colspan="8" style="text-align: right;">Grand Total</td>
                    <td>{{ $util->num_f($grand_total, true, null) }}</td>
                </tr>
            </tfoot>
        </table>
        
        <!-- Footer -->
        <div class="footer">
            <div>Print Date & Time: {{ date('d/m/Y h:i:s A') }}</div>
        </div>
    </div>
</body>
</html>

