@extends('layouts.app')
@section('title', __('businessmanagement::lang.due_list'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.due_list') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueList']), 'method' => 'get', 'id' => 'due_list_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date', __('businessmanagement::lang.date') . ':') !!}
                        {!! Form::text('date', $date ?? date('Y-m-d'), ['class' => 'form-control date-picker', 'id' => 'date', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('contact_type_filter', __('businessmanagement::lang.contact_type') . ':') !!}
                        {!! Form::select('contact_type_filter', [
                            'all_customer' => __('businessmanagement::lang.all_customers'),
                            'all_supplier' => __('businessmanagement::lang.all_suppliers'),
                            'single_customer' => __('businessmanagement::lang.single_customer'),
                            'single_supplier' => __('businessmanagement::lang.single_supplier')
                        ], $contact_type_filter ?? 'all_customer', ['class' => 'form-control', 'id' => 'contact_type_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="contact_select_wrapper" style="display: {{ in_array($contact_type_filter ?? 'all_customer', ['single_customer', 'single_supplier']) ? 'block' : 'none' }};">
                    <div class="form-group">
                        @if(($contact_type_filter ?? 'all_customer') == 'single_customer')
                            {!! Form::label('contact_id', __('contact.customer') . ':') !!}
                            {!! Form::select('contact_id', $customers, $contact_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_customer'), 'id' => 'contact_id']); !!}
                        @else
                            {!! Form::label('contact_id', __('contact.supplier') . ':') !!}
                            {!! Form::select('contact_id', $suppliers, $contact_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_supplier'), 'id' => 'contact_id']); !!}
                        @endif
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueList']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDueList'], ['date' => $date ?? date('Y-m-d'), 'contact_type_filter' => $contact_type_filter ?? 'all_customer', 'contact_id' => $contact_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $category_name => $items)
                            <h3 style="margin-top: 30px; margin-bottom: 15px; font-weight: bold; color: #2c3e50; font-size: 18px;">{{ $category_name }}</h3>
                            <table class="table table-bordered table-striped" style="font-size: 12px; margin-bottom: 15px;">
                                <thead>
                                    <tr>
                                        <th>Group</th>
                                        <th>Name</th>
                                        <th style="text-align: right;">{{ $business->name ?? 'Business Name' }}</th>
                                        <th style="text-align: right;">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $category_total = 0;
                                    @endphp
                                    @foreach($items as $item)
                                        @php
                                            $category_total += $item->due_amount;
                                        @endphp
                                        <tr>
                                            <td>{{ $category_name }}</td>
                                            <td>{{ $item->contact_name }}</td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->due_amount }}</span></td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->due_amount }}</span></td>
                                        </tr>
                                    @endforeach
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="2"><strong>Total</strong></td>
                                        <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $category_total }}</span></strong></td>
                                        <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $category_total }}</span></strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No due amounts found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Contact type filter toggle
        $('#contact_type_filter').on('change', function() {
            if ($(this).val() == 'single_customer' || $(this).val() == 'single_supplier') {
                $('#contact_select_wrapper').show();
                // Update the select options based on type
                if ($(this).val() == 'single_customer') {
                    $('#contact_select_wrapper label').text('{{ __('contact.customer') }}:');
                } else {
                    $('#contact_select_wrapper label').text('{{ __('contact.supplier') }}:');
                }
            } else {
                $('#contact_select_wrapper').hide();
                $('#contact_id').val(null).trigger('change');
            }
        });
    });
</script>
@endsection

