@extends('layouts.app')
@section('title', __('businessmanagement::lang.customer_due_with_ageing'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.customer_due_with_ageing') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerDueWithAgeing']), 'method' => 'get', 'id' => 'customer_due_with_ageing_filter_form' ]) !!}
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'customer_due_with_ageing_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', [
                            'all' => __('businessmanagement::lang.all_customers'),
                            'single' => __('businessmanagement::lang.single_customer')
                        ], $customer_filter ?? 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="customer_select_wrapper" style="display: {{ ($customer_filter ?? 'all') == 'single' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerDueWithAgeing']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCustomerDueWithAgeing'], ['end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'customer_filter' => $customer_filter ?? 'all', 'customer_id' => $customer_id ?? '', 'location_id' => $location_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($customer_due_data) > 0)
                        <table class="table table-bordered table-striped" style="font-size: 12px;">
                            <thead>
                                <tr>
                                    <th style="width: 50px; text-align: center;">SL</th>
                                    <th style="text-align: left;">Customer Name</th>
                                    <th style="text-align: center;">Last Sales Date</th>
                                    <th style="text-align: right;">Last Sales Amount</th>
                                    <th style="text-align: center;">Days (since last sales)</th>
                                    <th style="text-align: center;">Last Receipt Date</th>
                                    <th style="text-align: right;">Last Receipt Amount</th>
                                    <th style="text-align: center;">Days (since last receipt)</th>
                                    <th style="text-align: right;">Current Due</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $serial = 1;
                                    $current_group = '';
                                @endphp
                                @foreach($grouped_data as $group_name => $group_customers)
                                    @if(!empty($group_name) && $group_name != 'Other')
                                        <tr style="background-color: #f5f5f5; font-weight: bold;">
                                            <td></td>
                                            <td colspan="8">{{ $group_name }}</td>
                                        </tr>
                                    @endif
                                    @foreach($group_customers as $customer)
                                        <tr>
                                            <td style="text-align: center;">{{ $serial++ }}</td>
                                            <td>{{ $customer->customer_name }}</td>
                                            <td style="text-align: center;">{{ $customer->last_sales_date ? \Carbon\Carbon::parse($customer->last_sales_date)->format('d/m/Y') : '' }}</td>
                                            <td style="text-align: right;">{{ $customer->last_sales_amount > 0 ? $util->num_f($customer->last_sales_amount, true, null) : '' }}</td>
                                            <td style="text-align: center;">{{ $customer->days_since_last_sales !== null ? $customer->days_since_last_sales : '' }}</td>
                                            <td style="text-align: center;">{{ $customer->last_receipt_date ? \Carbon\Carbon::parse($customer->last_receipt_date)->format('d/m/Y') : '' }}</td>
                                            <td style="text-align: right;">{{ $customer->last_receipt_amount > 0 ? $util->num_f($customer->last_receipt_amount, true, null) : '' }}</td>
                                            <td style="text-align: center;">{{ $customer->days_since_last_receipt !== null ? $customer->days_since_last_receipt : '' }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($customer->current_due, true, null) }}</td>
                                        </tr>
                                    @endforeach
                                    @if(!empty($group_name) && $group_name != 'Other')
                                        @php
                                            $group_total = collect($group_customers)->sum('current_due');
                                        @endphp
                                        <tr style="background-color: #f8f9fa; font-weight: bold;">
                                            <td></td>
                                            <td colspan="7" style="text-align: right;">Subtotal for {{ $group_name }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($group_total, true, null) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr style="border-top: 2px double #000; font-weight: bold; background-color: #f8f9fa;">
                                    <td colspan="8" style="text-align: right; border-top: 2px double #000;">Grand Total</td>
                                    <td style="text-align: right; border-top: 2px double #000;">{{ $util->num_f($grand_total, true, null) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No customer due found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('#customer_due_with_ageing_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#customer_due_with_ageing_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date field is populated before form submission
        $('#customer_due_with_ageing_filter_form').on('submit', function() {
            var end_date_val = $('#customer_due_with_ageing_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

