# AdvancedReports Security Test Suite

This test suite ensures multi-tenant data isolation in the AdvancedReports module.

## Test Files

### Feature Tests
**File**: `Feature/MultiTenantSecurityTest.php`

End-to-end tests that verify complete data isolation between businesses.

**Run tests**:
```bash
php artisan test Modules/AdvancedReports/Tests/Feature/MultiTenantSecurityTest.php
```

### Unit Tests
**File**: `Unit/CategoryFilterSecurityTest.php`

Database query builder tests that validate business_id filtering at the query level.

**Run tests**:
```bash
php artisan test Modules/AdvancedReports/Tests/Unit/CategoryFilterSecurityTest.php
```

## Running All Tests

```bash
# Run all AdvancedReports tests
php artisan test Modules/AdvancedReports/Tests/

# Run with coverage
php artisan test Modules/AdvancedReports/Tests/ --coverage

# Run specific test method
php artisan test --filter test_product_category_analytics_blocks_cross_business_category_access
```

## Test Coverage

### Controllers Covered:
- ✅ ProductCategoryController
- ✅ StockReportController
- ✅ ItemwiseSalesReportController

### Security Scenarios Tested:
1. Cross-business category access (blocked)
2. Cross-business brand access (blocked)
3. SQL injection attempts (protected)
4. Direct ID manipulation (blocked)
5. Mixed business ID arrays (filtered)
6. Empty filter arrays (handled correctly)
7. Invalid IDs (handled gracefully)

## Adding New Tests

When fixing additional controllers, add tests following this pattern:

```php
/**
 * @test
 */
public function test_[controller_name]_blocks_cross_business_access()
{
    $this->actingAs($this->userA);

    $response = $this->getJson("/route?" . http_build_query([
        'category_id' => [$this->categoryB->id] // Business B category
    ]));

    // Should not return Business B data
    $this->assertEmpty($response->json('data'));
}
```

## Continuous Integration

Add to your CI/CD pipeline:

```yaml
# .github/workflows/tests.yml
- name: Run Security Tests
  run: php artisan test Modules/AdvancedReports/Tests/ --stop-on-failure
```

## Test Requirements

Before running tests, ensure:
1. Database is migrated: `php artisan migrate --env=testing`
2. Factories exist for: Business, User, Category, Brands, Product
3. Test database is configured in `phpunit.xml`

## Troubleshooting

### Tests fail with "Factory not found"
Ensure factories exist in `database/factories/` for all models.

### Tests fail with "Database not found"
Check `.env.testing` and ensure test database exists.

### Tests timeout
Increase test timeout in `phpunit.xml`:
```xml
<phpunit processTimeout="300">
```

## Documentation

- Full audit report: `../SECURITY_AUDIT_REPORT.md`
- Fix guide: `../SECURITY_FIX_GUIDE.md`
- Work summary: `../SECURITY_WORK_SUMMARY.md`
