@php
$currency_symbol = session('currency')['symbol'] ?? '$';
@endphp
<!DOCTYPE html>
<html>
<head>
    <title>Profit & Loss Report</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 30px; }
        .summary-table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        .summary-table th, .summary-table td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .summary-table th { background-color: #f2f2f2; }
        .products-table { width: 100%; border-collapse: collapse; }
        .products-table th, .products-table td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .products-table th { background-color: #f2f2f2; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .positive { color: green; }
        .negative { color: red; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Profit & Loss Report</h1>
        <p><strong>Period:</strong> {{ $export_data['period'] }}</p>
        <p><strong>Generated:</strong> {{ date('Y-m-d H:i:s') }}</p>
    </div>

    <h2>Summary</h2>
    <table class="summary-table">
        <tr>
            <th>Metric</th>
            <th class="text-right">Value</th>
        </tr>
        <tr>
            <td>Total Revenue</td>
            <td class="text-right">{{ $currency_symbol }}{{ $export_data['summary']['total_revenue'] }}</td>
        </tr>
        <tr>
            <td>Total Cost</td>
            <td class="text-right">{{ $currency_symbol }}{{ $export_data['summary']['total_cost'] }}</td>
        </tr>
        <tr>
            <td>Gross Profit</td>
            <td class="text-right @if((float)str_replace(',', '', $export_data['summary']['gross_profit'])) >= 0) positive @else negative @endif">
                {{ $currency_symbol }}{{ $export_data['summary']['gross_profit'] }}
            </td>
        </tr>
        <tr>
            <td>Net Profit</td>
            <td class="text-right @if((float)str_replace(',', '', $export_data['summary']['net_profit'])) >= 0) positive @else negative @endif">
                {{ $currency_symbol }}{{ $export_data['summary']['net_profit'] }}
            </td>
        </tr>
        <tr>
            <td>Gross Profit Margin</td>
            <td class="text-right">{{ $export_data['summary']['gross_profit_margin'] }}%</td>
        </tr>
        <tr>
            <td>Net Profit Margin</td>
            <td class="text-right">{{ $export_data['summary']['net_profit_margin'] }}%</td>
        </tr>
        <tr>
            <td>Total Transactions</td>
            <td class="text-right">{{ $export_data['summary']['transaction_count'] }}</td>
        </tr>
    </table>

    @if(!empty($export_data['products']))
    <h2>Product Breakdown</h2>
    <table class="products-table">
        <thead>
            <tr>
                <th>Product</th>
                <th>Category</th>
                <th class="text-right">Quantity</th>
                <th class="text-right">Revenue</th>
                <th class="text-right">Cost</th>
                <th class="text-right">Profit</th>
                <th class="text-right">Margin %</th>
            </tr>
        </thead>
        <tbody>
            @foreach($export_data['products'] as $product)
            <tr>
                <td>{{ $product['product'] }}</td>
                <td>{{ $product['category'] }}</td>
                <td class="text-right">{{ number_format($product['quantity'], 0) }}</td>
                <td class="text-right">{{ $currency_symbol }}{{ number_format($product['revenue'], 2) }}</td>
                <td class="text-right">{{ $currency_symbol }}{{ number_format($product['cost'], 2) }}</td>
                <td class="text-right @if($product['profit'] >= 0) positive @else negative @endif">
                    {{ $currency_symbol }}{{ number_format($product['profit'], 2) }}
                </td>
                <td class="text-right">{{ number_format($product['margin'], 2) }}%</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    <div style="margin-top: 50px; text-align: center; color: #666; font-size: 12px;">
        <p>Generated by Advanced Reports Module - {{ date('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>