<?php

return [
    // Module
    'advanced_reports_module' => 'Module de Rapports Avancés',
    'advanced_reports' => 'Rapports Avancés',
    'manage_advanced_reports' => 'Gérer les Rapports Avancés',
    'service_staff_not_enabled' => 'Le module Personnel de Service n\'est pas activé. Veuillez activer le module Personnel de Service dans les Paramètres Business pour utiliser les rapports de Reconnaissance du Personnel.',

    // Permissions
    'view_reports' => 'Voir les Rapports',
    'export_reports' => 'Exporter les Rapports',

    // Stock Report
    'stock_report' => 'Rapport de Stock',
    'manage_stock_report' => 'Gérer le Rapport de Stock',
    'current_stock' => 'Stock Actuel',
    'stock_value_purchase' => 'Valeur du Stock (Achat)',
    'stock_value_sale' => 'Valeur du Stock (Vente)',
    'potential_profit' => 'Profit Potentiel',
    'total_sold' => 'Total Vendu',
    'selling_price' => 'Prix de Vente',
    'total_products' => 'Total Produits',
    'total_stock_quantity' => 'Quantité Totale en Stock',
    'show_zero_stock' => 'Afficher Stock Zéro',
    'out_of_stock' => 'Rupture de Stock',
    'low_stock' => 'Stock Faible',
    'total_stock_value' => 'Valeur Totale du Stock',
    'product_info' => 'Info Produit',
    'active' => 'Actif',
    'inactive' => 'Inactif',
    'lot_number' => 'Numéro de Lot',

    // Sales Report
    'sales_report' => 'Rapport de Ventes',
    'manage_sales_report' => 'Gérer le Rapport de Ventes',
    'invoice_no' => 'N° Facture',
    'transaction_date' => 'Date de Transaction',
    'customer_name' => 'Nom du Client',
    'payment_status' => 'Statut de Paiement',
    'total_before_tax' => 'Total Avant Taxes',
    'tax_amount' => 'Montant de Taxe',
    'final_total' => 'Total Final',
    'total_paid' => 'Total Payé',
    'balance_due' => 'Solde Dû',
    'total_sales' => 'Total des Ventes',
    'average_sale' => 'Vente Moyenne',
    'total_due' => 'Total Dû',

    // Product Report
    'product_report' => 'Rapport de Ventes de Produits',

    // Pricing Optimization
    'pricing_optimization' => 'Optimisation des Prix',
    'pricing_analytics_dashboard' => 'Tableau de Bord d\'Analyse des Prix',
    'price_elasticity_analysis' => 'Analyse d\'Élasticité des Prix',
    'competitor_price_analysis' => 'Analyse des Prix Concurrents',
    'discount_impact_analysis' => 'Analyse d\'Impact des Remises',
    'dynamic_pricing_suggestions' => 'Suggestions de Tarification Dynamique',
    'revenue_optimization' => 'Optimisation des Revenus',
    'average_margin' => 'Marge Moyenne',
    'average_selling_price' => 'Prix de Vente Moyen',
    'current_price' => 'Prix Actuel',
    'cost_price' => 'Prix de Revient',
    'suggested_price' => 'Prix Suggéré',
    'quantity_sold' => 'Quantité Vendue',
    'velocity' => 'Vélocité',
    'elasticity_type' => 'Type d\'Élasticité',
    'recommendation' => 'Recommandation',
    'our_price' => 'Notre Prix',
    'market_average' => 'Moyenne du Marché',
    'market_position' => 'Position sur le Marché',
    'price_difference' => 'Différence de Prix',
    'competitiveness' => 'Compétitivité',
    'discount_frequency' => 'Fréquence de Remise',
    'avg_discount_percent' => 'Remise Moyenne %',
    'discounted_sales' => 'Ventes Remisées',
    'regular_sales' => 'Ventes Régulières',
    'effectiveness_score' => 'Score d\'Efficacité',
    'price_change' => 'Changement de Prix',
    'confidence' => 'Confiance',
    'reasoning' => 'Raisonnement',
    'revenue_impact' => 'Impact sur les Revenus',
    'products' => 'Produits',
    'optimization_score' => 'Score d\'Optimisation',

    // ABC Analysis
    'abc_analysis' => 'Analyse ABC',
    'abc_analysis_description' => 'Classez les produits par valeur et optimisez l\'allocation des ressources',
    'abc_analysis_dashboard' => 'Tableau de Bord d\'Analyse ABC',
    'analysis_type' => 'Type d\'Analyse',
    'inventory_value' => 'Valeur du Stocks',
    'sales_revenue' => 'Revenus des Ventes',
    'hybrid_analysis' => 'Analyse Hybride',
    'analyze' => 'Analyser',
    'a_grade_items' => 'Articles Grade A',
    'b_grade_items' => 'Articles Grade B',
    'c_grade_items' => 'Articles Grade C',
    'total_analysis_value' => 'Valeur Totale de l\'Analyse',
    'abc_distribution_chart' => 'Graphique de Distribution ABC',
    'pareto_analysis' => 'Analyse de Pareto',
    'revenue_contribution_analysis' => 'Analyse de Contribution aux Revenus',
    'abc_grade' => 'Grade ABC',
    'item_count' => 'Nombre d\'Articles',
    'turnover_ratio' => 'Ratio de Rotation',
    'focus_strategy' => 'Stratégie de Focus',
    'management_approach' => 'Approche de Gestion',
    'resource_allocation_recommendations' => 'Recommandations d\'Allocation des Ressources',
    'detailed_product_classification' => 'Classification Détaillée des Produits',
    'rank' => 'Rang',
    'variant_title' => 'Titre de Variante',
    'variant_sku' => 'SKU de Variante',
    'ending_quantity' => 'Quantité Finale',
    'total_cost_value' => 'Valeur Totale de Coût',
    'total_selling_value' => 'Valeur Totale de Vente',
    'cumulative_percent' => '% Cumulatif',
    'manage_product_report' => 'Gérer le Rapport de Ventes de Produits',
    'total_quantity_sold' => 'Quantité Totale Vendue',
    'total_amount_sold' => 'Montant Total Vendu',
    'profit_margin' => 'Marge Bénéficiaire',
    'top_selling_products' => 'Produits les Plus Vendus',
    'slow_moving_products' => 'Produits à Rotation Lente',

    // Price List
    'price_list' => 'Liste de Prix',
    'manage_price_list' => 'Gérer la Liste de Prix',
    'purchase_price' => 'Prix d\'Achat',
    'margin_percentage' => 'Marge %',
    'update_price' => 'Mettre à Jour le Prix',
    'bulk_update_prices' => 'Mise à Jour Groupée des Prix',

    // Common
    'filters' => 'Filtres',
    'date_range' => 'Plage de Dates',
    'location' => 'Emplacement',
    'category' => 'Catégorie',
    'customer' => 'Client',
    'from_date' => 'Date de Début',
    'to_date' => 'Date de Fin',
    'apply_filter' => 'Appliquer le Filtre',
    'clear_filter' => 'Effacer le Filtre',
    'export' => 'Exporter',
    'export_to_excel' => 'Exporter vers Excel',
    'export_to_pdf' => 'Exporter vers PDF',
    'export_to_csv' => 'Exporter vers CSV',
    'print' => 'Imprimer',
    'refresh' => 'Actualiser',
    'search' => 'Rechercher',
    'no_data_found' => 'Aucune donnée trouvée',
    'loading' => 'Chargement...',

    // Summary
    'summary' => 'Résumé',
    'grand_total' => 'Total Général',
    'totals' => 'Totaux',
    'count' => 'Compte',

    // Messages
    'report_generated_successfully' => 'Rapport généré avec succès',
    'export_completed_successfully' => 'Exportation terminée avec succès',
    'no_records_found' => 'Aucun enregistrement trouvé pour les critères sélectionnés',
    'please_select_date_range' => 'Veuillez sélectionner une plage de dates',
    'invalid_date_range' => 'Plage de dates invalide sélectionnée',
    'export_in_progress' => 'L\'exportation est en cours, veuillez patienter...',
    'max_export_limit_exceeded' => 'Limite maximale d\'exportation dépassée. Veuillez affiner vos filtres.',

    // Errors
    'error_generating_report' => 'Erreur lors de la génération du rapport',
    'error_exporting_data' => 'Erreur lors de l\'exportation des données',
    'permission_denied' => 'Permission refusée',
    'invalid_request' => 'Requête invalide',

    // Installation
    'install_success' => 'Module de Rapports Avancés installé avec succès',
    'update_success' => 'Module de Rapports Avancés mis à jour avec succès',
    'uninstall_success' => 'Module de Rapports Avancés désinstallé avec succès',

    // Charts
    'sales_trend' => 'Tendance des Ventes',
    'top_products' => 'Meilleurs Produits',
    'sales_by_location' => 'Ventes par Emplacement',
    'sales_by_category' => 'Ventes par Catégorie',
    'profit_analysis' => 'Analyse des Profits',

    // Advanced Features
    'schedule_report' => 'Planifier le Rapport',
    'email_report' => 'Envoyer le Rapport par Email',
    'save_filter' => 'Enregistrer le Filtre',
    'load_saved_filter' => 'Charger le Filtre Enregistré',
    'custom_columns' => 'Colonnes Personnalisées',
    'group_by' => 'Grouper par',
    'sort_by' => 'Trier par',
    'chart_view' => 'Vue Graphique',
    'table_view' => 'Vue Tableau',

    // Time Periods
    'today' => 'Aujourd\'hui',
    'yesterday' => 'Hier',
    'this_week' => 'Cette Semaine',
    'last_week' => 'Semaine Dernière',
    'this_month' => 'Ce Mois',
    'last_month' => 'Mois Dernier',
    'this_quarter' => 'Ce Trimestre',
    'last_quarter' => 'Trimestre Dernier',
    'this_year' => 'Cette Année',
    'last_year' => 'Année Dernière',
    'last_30_days' => '30 Derniers Jours',
    'custom_range' => 'Plage Personnalisée',

    'applying' => 'Application',
    'apply_filters' => 'Appliquer les Filtres',

    // Dashboard
    'dashboard' => 'Tableau de Bord',
    'key_metrics' => 'Indicateurs Clés',
    'recent_reports' => 'Rapports Récents',
    'quick_actions' => 'Actions Rapides',
    'generate_report' => 'Générer un Rapport',
    'view_all_reports' => 'Voir Tous les Rapports',
    'report_center' => 'Centre de Rapports',

    'all_categories' => 'Toutes les Catégories',
    'filter' => 'Filtrer',

    // Sales Report entries
    'sales_details' => 'Détails des Ventes',
    'total_transactions' => 'Total des Transactions',
    'total_customers' => 'Total des Clients',
    'customers' => 'Clients',
    'product' => 'Produit',
    'total_customers_count' => 'Nombre Total de Clients',
    'total_products_count' => 'Nombre Total de Produits',
    'total_sales_amount' => 'Montant Total des Ventes',
    'total_tax_amount' => 'Montant Total de Taxe',
    'total_discount' => 'Remise Totale',
    'paid_transactions' => 'Montant Payé',
    'paid_transactions_count' => 'Nombre de Transactions Payées',
    'total_paid_amount' => 'Montant Total Payé',
    'due_transactions' => 'Montant Dû',
    'due_transactions_count' => 'Nombre de Transactions Dues',
    'total_due_amount' => 'Montant Total Dû',
    'invoice' => 'Facture',
    'invoices' => 'Factures',
    'partial_transactions' => 'Transactions Partielles',
    'paid_amount' => 'Montant Payé',
    'due_amount' => 'Montant Dû',
    'transaction_info' => 'Information de Transaction',
    'created_by' => 'Créé par',
    'view_full_invoice' => 'Voir la Facture Complète',

    // Additional entries
    'sales_summary' => 'Résumé des Ventes',
    'payment_summary' => 'Résumé des Paiements',
    'customer_info' => 'Informations Client',
    'sales_performance' => 'Performance des Ventes',
    'daily_sales' => 'Ventes Quotidiennes',
    'monthly_sales' => 'Ventes Mensuelles',
    'yearly_sales' => 'Ventes Annuelles',
    'top_customers' => 'Meilleurs Clients',
    'sales_by_payment_method' => 'Ventes par Méthode de Paiement',
    'average_transaction_value' => 'Valeur Moyenne de Transaction',
    'total_transactions_today' => 'Total des Transactions Aujourd\'hui',
    'sales_growth' => 'Croissance des Ventes',
    'revenue_analysis' => 'Analyse des Revenus',

    // Filter related
    'filter_by_date' => 'Filtrer par Date',
    'filter_by_customer' => 'Filtrer par Client',
    'filter_by_location' => 'Filtrer par Emplacement',
    'filter_by_payment_status' => 'Filtrer par Statut de Paiement',
    'filter_by_payment_method' => 'Filtrer par Méthode de Paiement',
    'select_date_range' => 'Sélectionner une Plage de Dates',
    'all_customers' => 'Tous les Clients',
    'all_locations' => 'Tous les Emplacements',
    'all_payment_methods' => 'Toutes les Méthodes de Paiement',
    'all_statuses' => 'Tous les Statuts',

    // Export related
    'export_sales_report' => 'Exporter le Rapport de Ventes',
    'sales_report_exported' => 'Le rapport de ventes a été exporté avec succès',
    'export_failed' => 'L\'exportation a échoué. Veuillez réessayer.',

    // Status messages
    'no_sales_found' => 'Aucune vente trouvée pour les critères sélectionnés',
    'loading_sales_data' => 'Chargement des données de ventes...',
    'sales_data_loaded' => 'Données de ventes chargées avec succès',
    'error_loading_sales' => 'Erreur lors du chargement des données de ventes',

    // Validation messages
    'date_range_too_large' => 'La plage de dates est trop grande. Veuillez sélectionner une plage plus petite.',
    'no_data_available' => 'Aucune donnée disponible pour les filtres sélectionnés',

    // Performance metrics
    'growth_rate' => 'Taux de Croissance',
    'conversion_rate' => 'Taux de Conversion',
    'repeat_customers' => 'Clients Récurrents',
    'new_customers' => 'Nouveaux Clients',
    'average_order_value' => 'Valeur Moyenne de Commande',
    'total_orders' => 'Total des Commandes',
    'orders_per_customer' => 'Commandes par Client',

    // Additional useful phrases
    'view_details' => 'Voir les Détails',
    'hide_details' => 'Masquer les Détails',
    'expand_all' => 'Tout Développer',
    'collapse_all' => 'Tout Réduire',
    'refresh_data' => 'Actualiser les Données',
    'last_updated' => 'Dernière Mise à Jour',
    'auto_refresh' => 'Actualisation Automatique',
    'manual_refresh' => 'Actualisation Manuelle',
    'data_as_of' => 'Données au',
    'real_time_data' => 'Données en Temps Réel',

    // Chart/Graph related
    'bar_chart' => 'Graphique à Barres',
    'line_chart' => 'Graphique Linéaire',
    'pie_chart' => 'Graphique Circulaire',
    'show_chart' => 'Afficher le Graphique',
    'hide_chart' => 'Masquer le Graphique',

    // Comparison related
    'compare_periods' => 'Comparer les Périodes',
    'previous_period' => 'Période Précédente',
    'same_period_last_year' => 'Même Période l\'Année Dernière',
    'percentage_change' => 'Changement en Pourcentage',
    'absolute_change' => 'Changement Absolu',
    'trend_analysis' => 'Analyse de Tendance',

    // Due Collections Analysis
    'due_collections_analysis' => 'Analyse des Recouvrements',
    'collected_today' => 'Collecté Aujourd\'hui',
    'pending_due_today' => 'En Attente Aujourd\'hui',
    'overdue_amounts' => 'Montants en Retard',
    'due_payments_received' => 'Paiements dus reçus aujourd\'hui',
    'todays_unpaid_sales' => 'Ventes impayées d\'aujourd\'hui',
    'previous_days_unpaid' => 'Jours précédents impayés',
    'cash_collected_today' => 'Espèces Collectées Aujourd\'hui',
    'due_collection_cash' => 'Espèces de Recouvrement',
    'total_due_collected' => 'Total Dû Collecté',
    'total_pending_due' => 'Total Dû en Attente',
    'total_overdue' => 'Total en Retard',
    'due_collection_summary' => 'Résumé de Recouvrement',
    'payment_collection_status' => 'Statut de Collecte de Paiement',
    'outstanding_receivables' => 'Créances en Cours',
    'receivables_aging' => 'Vieillissement des Créances',
    'collection_efficiency' => 'Efficacité de Collecte',
    'overdue_analysis' => 'Analyse des Retards',
    'aging_report' => 'Rapport de Vieillissement',
    'collection_report' => 'Rapport de Collecte',
    'cash_flow_analysis' => 'Analyse des Flux de Trésorerie',
    'payment_trends' => 'Tendances de Paiement',
    'due_follow_up' => 'Suivi des Dus',
    'collection_alerts' => 'Alertes de Collecte',
    'payment_reminders' => 'Rappels de Paiement',
    'credit_management' => 'Gestion du Crédit',
    'customer_payment_history' => 'Historique de Paiement Client',
    'payment_performance' => 'Performance de Paiement',

    // sales_detail_report
    'sales_detail_report' => 'Rapport Détaillé des Ventes',
    'sales_detail_subtitle' => 'Analyse détaillée des ventes',
    'sales_detail_filters' => 'Filtres du Rapport Détaillé',
    'sales_detail_data' => 'Données Détaillées des Ventes',
    'sales_detail_summary' => 'Résumé Détaillé des Ventes',
    'gst_sales_report' => 'Rapport de Ventes TPS',
    'gst_purchase_report' => 'Rapport d\'Achats TPS',
    'operations_summary_report' => 'Rapport Résumé des Opérations',
    'daily_summary_report' => 'Rapport Résumé Quotidien',
    'daily_report' => 'Rapport Quotidien',
    'manage_gst_sales_report' => 'Gérer le Rapport de Ventes TPS',
    'total_tax' => 'Taxe Totale',
    'taxable_amount' => 'Montant Imposable',
    'avg_tax_rate' => 'Taux de Taxe Moyen',
    'taxable_value' => 'Valeur Imposable',
    'today_sales' => 'Ventes Aujourd\'hui',
    'today_purchases' => 'Achats Aujourd\'hui',
    'today_expenses' => 'Dépenses Aujourd\'hui',
    'net_profit' => 'Bénéfice Net',
    'cash_in_hand' => 'Espèces en Main',
    'purchase_summary' => 'Résumé des Achats',
    'expense_summary' => 'Résumé des Dépenses',
    'payment_methods_summary' => 'Résumé des Méthodes de Paiement',
    'payment_method' => 'Méthode de Paiement',
    'transaction_count' => 'Nombre de Transactions',
    'total_amount' => 'Montant Total',
    'manage_daily_summary' => 'Gérer le Résumé Quotidien',
    'total_purchases' => 'Total des Achats',
    'total_expenses' => 'Total des Dépenses',
    'avg_daily_sales' => 'Ventes Quotidiennes Moyennes',
    'profitable_days' => 'Jours Rentables',
    'day' => 'Jour',
    'sales_count' => 'Nombre de Ventes',
    'purchase_count' => 'Nombre d\'Achats',
    'expense_count' => 'Nombre de Dépenses',
    'cash_received' => 'Espèces Reçues',
    'card_received' => 'Carte Reçue',

    'comprehensive_daily_overview' => 'Aperçu Quotidien Complet',
    'today_profit' => 'Profit Aujourd\'hui',
    'bank_balance' => 'Solde Bancaire',
    'customer_due' => 'Dû Client',
    'supplier_due' => 'Dû Fournisseur',
    'today_collections' => 'Collectes Aujourd\'hui',
    'net_worth' => 'Valeur Nette',
    'todays_activity' => 'Activité d\'Aujourd\'hui',
    'financial_snapshot' => 'Instantané Financier',
    'avg_transaction_value' => 'Valeur Moyenne de Transaction',
    'gross_profit_margin' => 'Marge Bénéficiaire Brute',
    'opening_balance' => 'Solde d\'Ouverture',
    'closing_balance' => 'Solde de Clôture',
    'cash_flow' => 'Flux de Trésorerie',
    'liquidity_ratio' => 'Ratio de Liquidité',
    'detailed_breakdown' => 'Ventilation Détaillée',
    'manage_operations_summary' => 'Gérer le Résumé des Opérations',
    'report_date' => 'Date du Rapport',

    'gst_sales_by_products' => 'Ventes TPS par Produits',
    'gst_sales_by_invoice' => 'Ventes TPS par Facture',

    // Stock report specific translations
    'total_stock_purchase_value' => 'Valeur Totale d\'Achat du Stock',
    'total_stock_sales_value' => 'Valeur Totale de Vente du Stock',

    // General UI translations
    'stock_need_only' => 'Besoin de Stock Uniquement',
    'stock_need' => 'Besoin de Stock',
    'expected_stock' => 'Stock Attendu',
    'expired_stock' => 'Stock Expiré',
    'critical_items' => 'Articles Critiques',
    'total_current_stock' => 'Stock Total Actuel',
    'total_stock_needed' => 'Stock Total Nécessaire',
    'coverage_ratio' => 'Ratio de Couverture',
    'processing' => 'Traitement',
    'table_not_found' => 'Tableau non trouvé',
    'no_data_available_print' => 'Aucune donnée disponible à imprimer',
    'popup_blocked' => 'Popup bloquée par le navigateur. Veuillez autoriser les popups pour ce site.',
    'generated_on' => 'Généré le',
    'at' => 'à',
    'printed_on' => 'Imprimé le',
    'generated_by' => 'Généré par',
    'system_generated_report' => 'Ceci est un rapport généré par le système',
    'select_date' => 'Sélectionner la Date',
    'select_location' => 'Sélectionner l\'Emplacement',

    // Expiry report translations
    'expiry_report' => 'Rapport d\'Expiration',
    'expiry_filters' => 'Filtres d\'Expiration',
    'expiry_status' => 'Statut d\'Expiration',
    'all' => 'Tous',
    'expired' => 'Expiré',
    'expiring_in_7_days' => 'Expirant dans 7 Jours',
    'expiring_in_30_days' => 'Expirant dans 30 Jours',
    'expiring_in_90_days' => 'Expirant dans 90 Jours',
    'expired_products' => 'Produits Expirés',
    'total_expiry_value' => 'Valeur Totale d\'Expiration',
    'stock_expiry_report' => 'Rapport d\'Expiration de Stock',
    'days_to_expire' => 'Jours avant Expiration',
    'stock_value' => 'Valeur du Stock',
    'days_expired' => 'jours expirés',
    'days_left' => 'jours restants',
    'critical' => 'Critique',
    'warning' => 'Avertissement',
    'good' => 'Bon',
    'remove_from_stock' => 'Retirer du Stock',

    // Enhanced expiry alert translations
    'expiring_soon' => 'Expirant Bientôt',
    'total_items' => 'Total d\'Articles',
    'alert_value' => 'Valeur d\'Alerte',
    'days_ahead' => 'Jours à Venir',
    'next_7_days' => 'Prochains 7 Jours',
    'next_15_days' => 'Prochains 15 Jours',
    'next_30_days' => 'Prochains 30 Jours',
    'next_60_days' => 'Prochains 60 Jours',
    'next_90_days' => 'Prochains 90 Jours',
    'days_overdue' => 'jours de retard',
    'expires_today' => 'Expire Aujourd\'hui',
    'status' => 'Statut',
    'expiry_date' => 'Date d\'Expiration',

    'invoice_subtotal' => 'Sous-total de Facture',
    'line_discount' => 'Remise de Ligne',
    'invoice_discount' => 'Remise de Facture',

    // Customer Monthly Sales Report
    'customer_monthly_sales_report' => 'Rapport de Ventes Mensuelles Client',
    'manage_customer_monthly_sales' => 'Gérer les Ventes Mensuelles Client',
    'customer_monthly_analysis' => 'Analyse Mensuelle Client',
    'monthly_breakdown' => 'Ventilation Mensuelle',
    'gross_profit_amount' => 'Bénéfice Brut (€)',
    'gross_profit_percentage' => 'Bénéfice Brut (%)',
    'avg_per_customer' => 'Moyenne par Client',
    'customer_details' => 'Détails du Client',
    'customer_information' => 'Informations Client',
    'recent_transactions' => 'Transactions Récentes',
    'monthly_sales_analysis' => 'Analyse des Ventes Mensuelles',
    'year_summary' => 'Résumé Annuel',
    'search_by_name' => 'Rechercher par nom...',
    'staff' => 'Personnel',

    'gross_profit' => 'Bénéfice Brut',

    // Months
    'january' => 'Janvier',
    'february' => 'Février',
    'march' => 'Mars',
    'april' => 'Avril',
    'may' => 'Mai',
    'june' => 'Juin',
    'july' => 'Juillet',
    'august' => 'Août',
    'september' => 'Septembre',
    'october' => 'Octobre',
    'november' => 'Novembre',
    'december' => 'Décembre',

    // Short months
    'jan' => 'Jan',
    'feb' => 'Fév',
    'mar' => 'Mar',
    'apr' => 'Avr',
    'jun' => 'Juin',
    'jul' => 'Juil',
    'aug' => 'Août',
    'sep' => 'Sep',
    'oct' => 'Oct',
    'nov' => 'Nov',
    'dec' => 'Déc',

    'product_performance_report' => 'Rapport de Performance Produit',
    'manage_product_performance' => 'Gérer la Performance Produit',
    'product_performance_analysis' => 'Analyse de Performance Produit',
    'product_details' => 'Détails du Produit',

    // Date & Time
    'start_date' => 'Date de Début',
    'end_date' => 'Date de Fin',
    'week' => 'Semaine',
    'week_number' => 'Numéro de Semaine',
    'day_number' => 'Numéro de Jour',
    'sales_date' => 'Date de Vente',

    // Week Options
    'all_weeks' => 'Toutes les Semaines',
    'week_1' => 'Semaine 1',
    'week_2' => 'Semaine 2',
    'week_3' => 'Semaine 3',
    'week_4' => 'Semaine 4',
    'week_5' => 'Semaine 5',
    'weekly_totals' => 'TOTAUX HEBDOMADAIRES',

    // Filter Options
    'all_groups' => 'Tous les Groupes',
    'all_brands' => 'Toutes les Marques',
    'all_units' => 'Toutes les Unités',
    'all_users' => 'Tous les Utilisateurs',
    'all_staff' => 'Tout le Personnel',
    'all_methods' => 'Toutes les Méthodes',

    // Report Sections
    'top_performing_products' => 'Produits les Plus Performants',
    'weekly_sales_summary_report' => 'Rapport Résumé Hebdomadaire des Ventes',
    'staff_performance_analysis' => 'Analyse de Performance du Personnel',
    'stock_valuation' => 'Évaluation du Stock',

    // Sales Detail Columns
    'sales_unit' => 'Unité de Vente',
    'qty_sold' => 'Qté Vendue',
    'total_sales_amt' => 'Montant Total des Ventes',
    'total_purchase_amt' => 'Montant Total d\'Achat',
    'profit_earned' => 'Profit Réalisé',
    'margin_percent' => '% Marge',
    'total_purchase' => 'Achat Total',
    'total_profit' => 'Profit Total',

    // Messages & Status
    'no_sales_data_found' => 'Aucune donnée de vente trouvée pour les critères sélectionnés.',
    'error_loading_sales_data' => 'Erreur lors du chargement des données de ventes. Veuillez réessayer.',
    'report_refreshed_successfully' => 'Rapport actualisé avec succès',
    'sales_detail_report_loaded' => 'Rapport détaillé des ventes chargé avec succès',
    'auto_refresh_5_min' => 'Actualisation automatique (5 min)',
    'clearing' => 'Effacement...',
    'clear' => 'Effacer',
    'search_by_brand_name' => 'Rechercher par nom de marque...',
    'brand_monthly_sales_report' => 'Rapport de Ventes Mensuelles par Marque',
    'view_brand_sales_by_months_with_profit_analysis' => 'Voir les ventes de marque par mois avec analyse de profit',

    'total_qty' => 'Qté Totale',
    'advanced_filters' => 'Filtres Avancés',
    'min_amount' => 'Montant Min',
    'max_amount' => 'Montant Max',

    'itemwise_sales_report' => 'Rapport de Ventes par Article',
    'itemwise_sales_subtitle' => 'Analyse détaillée des ventes par article de produit',
    'itemwise_sales_filters' => 'Filtres du Rapport de Ventes par Article',
    'product_name_sku' => 'Nom/SKU du Produit',
    'customer_name_mobile' => 'Nom/Mobile du Client',
    'clear_all_filters' => 'Effacer Tous les Filtres',
    'quick_date_filters' => 'Filtres de Date Rapides:',
    'clear_date' => 'Effacer la Date',
    'unique_customers' => 'Clients Uniques',
    'products_sold' => 'Produits Vendus',
    'total_qty_sold' => 'Qté Totale Vendue',
    'detailed_view' => 'Vue Détaillée',
    'applied_filters' => 'Filtres Appliqués',
    'date_range_label' => 'Plage de Dates:',
    'location_label' => 'Emplacement:',
    'customer_label' => 'Client:',
    'category_label' => 'Catégorie:',
    'brand_label' => 'Marque:',
    'report_summary' => 'Résumé du Rapport',
    'date' => 'Date',
    'brand' => 'Marque',
    'qty' => 'Qté',
    'unit_price' => 'Prix Unitaire',
    'tax_percent' => 'Taxe %',
    'subtotal' => 'Sous-total',
    'total' => 'Total',
    'report_details' => 'Détails du Rapport:',
    'total_records' => 'Total d\'Enregistrements:',
    'report_period' => 'Période du Rapport:',
    'business_information' => 'Informations Business:',
    'tax_number' => 'Numéro de Taxe:',
    'printed_by' => 'Imprimé par:',
    'print_report' => 'Imprimer le Rapport',
    'close' => 'Fermer',
    'all_dates' => 'Toutes les Dates',
    'purchase_cost' => 'Coût d\'Achat',

    // Customer Recognition
    'weekly_monthly_yearly_customer_awards' => 'Récompenses et Reconnaissance Client Hebdomadaires / Mensuelles / Annuelles',
    'customer_recognition_system' => 'Système de Reconnaissance Client',
    'recognition_filters_controls' => 'Filtres et Contrôles de Reconnaissance',
    'period_type' => 'Type de Période',
    'winner_count' => 'Nombre de Gagnants',
    'finalize_period' => 'Finaliser la Période',
    'record_engagement' => 'Enregistrer l\'Engagement',
    'current_period_winners' => 'Gagnants de la Période Actuelle',
    'weekly_winner' => 'Gagnant Hebdomadaire',
    'monthly_winner' => 'Gagnant Mensuel',
    'yearly_winner' => 'Gagnant Annuel',
    'total_participants' => 'Total Participants',
    'engagement_points' => 'Points d\'Engagement',
    'average_score' => 'Score Moyen',
    'top_score' => 'Meilleur Score',
    'avg_transaction' => 'Transaction Moyenne',
    'customer_rankings' => 'Classements et Reconnaissance Client',
    'sales_total' => 'Total des Ventes',
    'transactions' => 'Transactions',
    'final_score' => 'Score Final',
    'customer_recognition_details' => 'Détails de Reconnaissance Client',
    'loading_customer_details' => 'Chargement des détails du client...',
    'award_customer' => 'Récompenser le Client',
    'award_type' => 'Type de Récompense',
    'select_award_type' => 'Sélectionner le Type de Récompense',
    'manual_entry' => 'Saisie Manuelle',
    'from_catalog' => 'Du Catalogue',
    'gift_description' => 'Description du Cadeau',
    'select_gift_from_catalog' => 'Sélectionner un Cadeau du Catalogue',
    'loading_catalog' => 'Chargement du catalogue...',
    'additional_notes_about_award' => 'Notes supplémentaires sur cette récompense...',
    'record_customer_engagement' => 'Enregistrer l\'Engagement Client',
    'engagement_type' => 'Type d\'Engagement',
    'select_type' => 'Sélectionner le Type',
    'youtube_follow' => 'Abonnement YouTube',
    'facebook_follow' => 'Suivi Facebook',
    'instagram_follow' => 'Suivi Instagram',
    'twitter_follow' => 'Suivi Twitter',
    'content_share' => 'Partage de Contenu',
    'review_testimonial' => 'Avis/Témoignage',
    'google_review' => 'Avis Google',
    'customer_referral' => 'Parrainage Client',
    'points' => 'Points',
    'platform' => 'Plateforme',
    'reference_url' => 'URL de Référence',
    'verification_notes' => 'Notes de Vérification',
    'describe_verification_notes' => 'Décrire comment cet engagement a été vérifié...',
    'finalize_period_rankings' => 'Finaliser les Classements de Période',
    'message_warning_finalized1' => 'Une fois finalisé, les classements de cette période ne peuvent pas être modifiés.',
    'message_warning_finalized2' => 'Cela verrouillera les gagnants actuels et vous permettra de les récompenser.',
    'period' => 'Période',
    'winners_count' => 'Nombre de Gagnants',
    'quantity' => 'Quantité',
    'customer_engagements' => 'Engagements Client',
    'recorded_by' => 'Enregistré par',
    'recorded_date' => 'Date d\'Enregistrement',
    'no_customer_engagements_found' => 'Aucun engagement client trouvé',

    // Service Staff Recognition
    'service_staff_recognition_system' => 'Système de Reconnaissance du Personnel',
    'weekly_monthly_yearly_staff_awards' => 'Récompenses et Reconnaissance du Personnel Hebdomadaires / Mensuelles / Annuelles',
    'staff_rankings' => 'Classements et Reconnaissance du Personnel',
    'staff_name' => 'Nom du Personnel',
    'performance_points' => 'Points de Performance',
    'performance_activities' => 'Activités de Perf.',
    'activity_type' => 'Type d\'Activité',
    'description' => 'Description',
    'total_staff' => 'Total du Personnel',
    'top_performer' => 'Meilleur Performeur',
    'average_performance' => 'Performance Moyenne',
    'total_activities' => 'Total des Activités',
    'award_staff' => 'Récompenser le Personnel',
    'record_performance_activity' => 'Enregistrer l\'Activité de Performance',
    'record_activity' => 'Enregistrer l\'Activité',
    'staff_member' => 'Membre du Personnel',
    'punctuality' => 'Ponctualité',
    'customer_service_excellence' => 'Excellence du Service Client',
    'upselling_success' => 'Succès de Vente Incitative',
    'teamwork' => 'Travail d\'Équipe',
    'training_completion' => 'Achèvement de Formation',
    'cleanliness_organization' => 'Propreté et Organisation',
    'other' => 'Autre',
    'no_performance_activities_found' => 'Aucune activité de performance trouvée',

    'weekly' => 'Hebdomadaire',
    'monthly' => 'Mensuel',
    'yearly' => 'Annuel',

    'weekly_top_performer' => 'Meilleur Performeur Hebdomadaire',
    'monthly_top_performer' => 'Meilleur Performeur Mensuel',
    'yearly_top_performer' => 'Meilleur Performeur Annuel',

    'current_period_top_performers' => 'Meilleurs Performeurs de la Période Actuelle',
    'current_period_top_performer' => 'Meilleur Performeur de la Période Actuelle',
    'top_performer_score' => 'Score du Meilleur Performeur',

    // Demand Forecasting
    'demand_forecasting' => 'Prévision de la Demande',
    'demand_forecasting_report' => 'Prévision de la Demande',
    'historical_period' => 'Période Historique',
    'forecast_period' => 'Période de Prévision',
    '3_months' => '3 Mois',
    '6_months' => '6 Mois',
    '12_months' => '12 Mois',
    'sales_prediction_subtitle' => 'Prédiction des Ventes, Modèles Saisonniers et Prévention de Rupture de Stock',
    'forecasted_demand' => 'Demande Prévue',
    'historical_demand' => 'Demande Historique',
    'forecasted_period' => 'Période Prévue',
    'generate_forecast' => 'Générer la Prévision',
    'products_analyzed' => 'Produits Analysés',
    'stockout_alerts' => 'Alertes de Rupture',
    'reorder_required' => 'Réapprovisionnement Requis',
    'all_alerts' => 'Toutes les Alertes',
    'high' => 'Élevé',
    'medium' => 'Moyen',
    'low' => 'Faible',
    'daily_demand' => 'Demande Quotidienne',
    'days_of_supply' => 'Jours de Fourniture',
    'alert_level' => 'Niveau d\'Alerte',
    'estimated_stockout' => 'Rupture Estimée',
    'recommended_action' => 'Action Recommandée',
    'select_product' => 'Sélectionner le Produit',
    'historical' => 'Historique',
    'forecast' => 'Prévision',
    'combined' => 'Combiné',
    'all_products' => 'Tous les Produits',
    'reorder_now' => 'Réapprovisionner Maintenant',
    'monitor_closely' => 'Surveiller de Près',
    'overstocked' => 'Surstock',
    'optimal' => 'Optimal',
    'reorder_point' => 'Point de Réapprovisionnement',
    'eoq' => 'QEC',
    'priority' => 'Priorité',
    'trend' => 'Tendance',
    'volatility' => 'Volatilité',

    // Waste & Loss Analysis
    'waste_loss_analysis_report' => 'Analyse des Déchets et Pertes',
    'waste_loss_subtitle' => 'Produits Expirés, Marchandises Endommagées, Vol et Prévention des Pertes',
    'analysis_period' => 'Période d\'Analyse',
    'analyze_waste_loss' => 'Analyser les Déchets et Pertes',
    'damaged_goods' => 'Marchandises Endommagées',
    'theft_shrinkage' => 'Vol et Démarque',
    'total_loss' => 'Perte Totale',
    'loss_trends' => 'Tendances de Perte',
    'loss_breakdown' => 'Ventilation des Pertes',

    // Location Performance
    'location_performance_report' => 'Performance Magasin/Emplacement',
    'manage_location_performance' => 'Gérer la Performance Magasin/Emplacement',
    'location_performance_analytics' => 'Analyse de Performance d\'Emplacement',
    'locations' => 'Emplacements',
    'compare_with' => 'Comparer avec',
    'compare' => 'Comparer',

    // Staff Productivity
    'staff_productivity_report' => 'Productivité du Personnel',
    'sales_performance_and_efficiency' => 'Analyse de Performance des Ventes et d\'Efficacité',
    'staff_members' => 'Membres du Personnel',
    'active_staff' => 'personnel actif',
    'total_commissions' => 'Commissions Totales',
    'avg_per_staff' => 'moyenne par personnel',
    'avg_commission' => 'commission moyenne',
    'avg_efficiency' => 'Efficacité Moyenne',

    // Product Category Performance
    'product_category_performance' => 'Performance de Catégorie de Produit',
    'category_contribution_and_growth' => 'Analyse de Contribution de Catégorie et Tendances de Croissance',
    'category_contribution' => 'Contribution de Catégorie',
    'cross_selling_opportunities' => 'Opportunités de Vente Croisée',
    'margin_analysis' => 'Analyse de Marge',
    'growth_trends' => 'Tendances de Croissance',
    'inventory_turnover' => 'Rotation des Stocks',
    'detailed_category_performance' => 'Performance Détaillée de Catégorie',
    'profit' => 'Profit',
    'contribution' => 'Contribution',
    'avg_price' => 'Prix Moyen',
    'units_sold' => 'Unités Vendues',
    'total_categories' => 'Total des Catégories',
    'sales_contribution' => 'Contribution aux Ventes',
    'profit_contribution' => 'Contribution au Profit',

    // Seasonal Trends
    'seasonal_trends_report' => 'Tendances Saisonnières',
    'seasonal_trends_description' => 'Analyser les modèles saisonniers, performance des vacances et efficacité promotionnelle',

    // Audit Trail
    'audit_trail_report' => 'Piste d\'Audit',
    'audit_trail_description' => 'Suivi complet de conformité et gestion des risques',

    // Tax Compliance
    'tax_compliance_report' => 'Conformité Fiscale',
    'tax_compliance_description' => 'Support multi-juridictions fiscales et informations d\'optimisation',

    // Multi-Channel Sales
    'multi_channel_sales_report' => 'Ventes Multi-Canaux',
    'multi_channel_description' => 'Analyse de performance en ligne vs hors ligne et optimisation',

    // Supplier Performance
    'supplier_performance_report' => 'Performance Fournisseur',
    'supplier_performance_description' => 'Performance de livraison, évaluation de qualité, conformité de paiement et analyse de risque',

    // Warranty & Service
    'warranty_service_report' => 'Garantie et Service',
    'warranty_service_description' => 'Suivi de garantie produit, analyse de demande de service et métriques de support client',

    // Customer Group
    'customer_group_report' => 'Rapport de Groupe Client',
    'customer_group_analytics' => 'Analyse de Groupe Client',
    'customer_group_description' => 'Analyser la performance par groupes clients avec détail par vendeur',

    // Menu Navigation
    'sales_revenue_analysis' => 'Analyse des Ventes et Revenus',
    'sales_analytics' => 'Analyse des Ventes',
    'customer_performance' => 'Performance Client',
    'product_sales_analysis' => 'Analyse des Ventes Produit',
    'daily_operations' => 'Opérations Quotidiennes',
    'daily_dashboard' => 'Tableau de Bord Quotidien',
    'inventory_product_management' => 'Gestion Stock et Produit',
    'inventory_turnover_report' => 'Rotation des Stocks',
    'stock_management' => 'Gestion du Stock',
    'brand_analytics' => 'Analyse de Marque',
    'brand_comparison' => 'Comparaison de Marque',
    'supplier_performance' => 'Performance Fournisseur',
    'supplier_analysis' => 'Analyse Fournisseur',
    'supplier_profitability' => 'Rentabilité Fournisseur',
    'financial_compliance' => 'Conformité Financière',
    'profit_loss_analysis' => 'Analyse Profit et Perte',
    'purchase_analysis' => 'Analyse d\'Achat',
    'customer_lifetime_value' => 'Valeur Vie Client',
    'customer_behavior_analytics' => 'Analyse Comportement Client',
    'customer_segmentation_report' => 'Segmentation Client',
    'gst_sales_compliance' => 'Conformité Ventes TPS',
    'gst_purchase_compliance' => 'Conformité Achats TPS',
    'monthly_expenses' => 'Dépenses Mensuelles',
    'business_operations_summary' => 'Résumé Opérations Business',
    'customer_staff_engagement' => 'Engagement Client et Personnel',
    'customer_loyalty_program' => 'Programme de Fidélité Client',
    'staff_performance_management' => 'Performance du Personnel',
    'awarded' => 'Récompensé',
    'not_awarded' => 'Non Récompensé',

    // Product search
    'type_to_search_product' => 'Tapez pour rechercher un produit',
    'searching' => 'Recherche...',
    'no_products_found' => 'Aucun produit trouvé',

    // Module notifications
    'module_not_enabled' => 'Module Non Activé',
    'alert' => 'Alerte',
    'module_required' => 'Module Requis',
    'enable_module_instruction' => 'Veuillez activer le module requis dans les Paramètres Business pour utiliser cette fonctionnalité.',
    'go_to_settings' => 'Aller aux Paramètres',
    'go_to_home' => 'Aller à l\'Accueil',

    // Reward Points
    'reward_points_report' => 'Suivi Points de Fidélité et Responsabilité',
    'reward_points_description' => 'Suivre les points de fidélité client, historique de rachat et analyse de responsabilité financière',

    // Award Catalog
    'award_catalog_management' => 'Gestion du Catalogue de Récompenses',
    'manage_gifts_awards_customer_recognition' => 'Gérer les cadeaux et récompenses pour la reconnaissance client',
    'award_catalog_controls' => 'Contrôles du Catalogue de Récompenses',
    'add_new_award' => 'Ajouter Nouvelle Récompense',
    'award_catalog_items' => 'Articles du Catalogue de Récompenses',
    'delete_award' => 'Supprimer la Récompense',
    'edit_award' => 'Modifier la Récompense',

    // Business Analytics
    'business_analytics_dashboard' => 'Tableau de Bord Analytics Business',
    'view_data_usage_across_businesses' => 'Voir l\'utilisation des données à travers tous les business',
    'total_businesses' => 'Total Business',

    // Recognition Settings
    'customer_recognition_settings' => 'Paramètres de Reconnaissance Client',
    'configure_recognition_periods_scoring_preferences' => 'Configurer les périodes de reconnaissance, notation et préférences système',
    'general_settings' => 'Paramètres Généraux',
    'module_start_date' => 'Date de Début du Module',
    'weekly_recognition' => 'Reconnaissance Hebdomadaire',
    'monthly_recognition' => 'Reconnaissance Mensuelle',

    // Common additional
    'value' => 'Valeur',
    'categories' => 'Catégories',
    'total_revenue' => 'Revenu Total',
    'revenue' => 'Revenu',
    'action' => 'Action',
    'stock' => 'Stock',
    'purchases' => 'Achats',
    'users' => 'Utilisateurs',
    'sales' => 'Ventes',
    'amount' => 'Montant',
    'actions' => 'Actions',

    // Daily Report Widget Labels
    'todays_sales' => 'Ventes d\'Aujourd\'hui',
    'todays_purchases' => 'Achats d\'Aujourd\'hui',
    'todays_expenses' => 'Dépenses d\'Aujourd\'hui',
    'todays_profit' => 'Profit d\'Aujourd\'hui',
    'todays_collections' => 'Collectes d\'Aujourd\'hui',

    // Common
    'date_format' => 'Format: JJ/MM/AAAA',
    'stock_health' => 'Santé du Stock',
    'expense_monthly_report' => 'Rapport Mensuel des Dépenses',
    'product_performance' => 'Performance Produit',

    // Additional
    'advanced_reports_dashboard' => 'Rapports Avancés - Tableau de Bord Intelligence Business',
    'comprehensive_analytics_description' => 'Analyse complète et rapports pour décisions basées sur les données',
    'professional_reports_count' => '40+ Rapports Professionnels',
    'transform_data_insights' => 'Transformez vos données commerciales en insights actionnables',
    'view_report' => 'Voir le Rapport',
    'coming_soon' => 'Prochainement',
    'quick_access_popular_reports' => 'Accès Rapide - Rapports les Plus Populaires',
    'comprehensive_profit_loss_description' => 'Rapports complets de profit et perte avec analyses avancées',
    'filters_controls' => 'Filtres et Contrôles',
    'custom_date_range' => 'Plage de Dates Personnalisée',
    'select_custom_date_range' => 'Sélectionner plage de dates personnalisée',
    'export_pdf' => 'Exporter PDF',
    'expense_breakdown_description' => 'Voir la ventilation des dépenses par catégories et mois',
    'year' => 'Année',
    'average_expense' => 'Dépense Moyenne',
    'exporting' => 'Exportation...',
    'walk_in_customer' => 'Client Divers',


    // Reward Points
    'top_point_earners' => 'Meilleurs gagnants de points',
    'top_point_redeemers' => 'Meilleurs échangeurs de points',
    'no_recommendations_available' => 'Aucune recommandation disponible'
];
