<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Check if the table exists before attempting to modify it
        if (Schema::hasTable('customer_awards') && Schema::hasColumn('customer_awards', 'catalog_item_id')) {
            try {
                Schema::table('customer_awards', function (Blueprint $table) {
                    // Try to drop the foreign key constraint
                    $table->dropForeign(['catalog_item_id']);
                });
            } catch (\Exception $e) {
                // If the foreign key doesn't exist, that's fine - it means this is a fresh installation
                // or the foreign key was already removed. No action needed.
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_awards', function (Blueprint $table) {
            // Re-add the foreign key constraint (only if award_catalogs table exists)
            if (Schema::hasTable('award_catalogs')) {
                $table->foreign('catalog_item_id')->references('id')->on('award_catalogs')->onDelete('set null');
            }
        });
    }
};
