<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware('web', 'SetSessionData', 'auth', 'language', 'timezone', 'AdminSidebarMenu')->prefix('business-management')->name('businessmanagement.')->group(function () {
    
    // Purchase Register Routes
    Route::get('purchase-register', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'index'])->name('purchase_register.index');
    Route::get('purchase-register/date-wise-purchase', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchase'])->name('purchase_register.date_wise');
    Route::get('purchase-register/date-wise-purchase/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printDateWisePurchase'])->name('purchase_register.date_wise.print');
    Route::get('purchase-register/supplier-wise-purchase', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchase'])->name('purchase_register.supplier_wise');
    Route::get('purchase-register/supplier-wise-purchase/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierWisePurchase'])->name('purchase_register.supplier_wise.print');
    Route::get('purchase-register/supplier-wise-purchase-wop', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchaseWOP'])->name('purchase_register.supplier_wise_wop');
    Route::get('purchase-register/supplier-wise-purchase-wop/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierWisePurchaseWOP'])->name('purchase_register.supplier_wise_wop.print');
    Route::get('purchase-register/product-wise-purchase', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'productWisePurchase'])->name('purchase_register.product_wise');
    Route::get('purchase-register/product-wise-purchase/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printProductWisePurchase'])->name('purchase_register.product_wise.print');
    Route::get('purchase-register/product-wise-purchase-wop', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'productWisePurchaseWOP'])->name('purchase_register.product_wise_wop');
    Route::get('purchase-register/product-wise-purchase-wop/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printProductWisePurchaseWOP'])->name('purchase_register.product_wise_wop.print');
    Route::get('purchase-register/location-wise-net-product-purchase', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'locationWiseNetProductPurchase'])->name('purchase_register.location_wise_net_product');
    Route::get('purchase-register/location-wise-net-product-purchase/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printLocationWiseNetProductPurchase'])->name('purchase_register.location_wise_net_product.print');
    Route::get('purchase-register/date-wise-net-product-purchase', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWiseNetProductPurchase'])->name('purchase_register.date_wise_net_product');
    Route::get('purchase-register/date-wise-net-product-purchase/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printDateWiseNetProductPurchase'])->name('purchase_register.date_wise_net_product.print');
    Route::get('purchase-register/supplier-wise-statement', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWiseStatement'])->name('purchase_register.supplier_wise_statement');
    Route::get('purchase-register/supplier-wise-statement/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierWiseStatement'])->name('purchase_register.supplier_wise_statement.print');
    Route::get('purchase-register/supplier-and-product-wise-purchase', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierAndProductWisePurchase'])->name('purchase_register.supplier_and_product_wise');
    Route::get('purchase-register/supplier-and-product-wise-purchase/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierAndProductWisePurchase'])->name('purchase_register.supplier_and_product_wise.print');
    Route::get('purchase-register/purchased-product-movement', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'purchasedProductMovement'])->name('purchase_register.purchased_product_movement');
    Route::get('purchase-register/purchased-product-movement/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printPurchasedProductMovement'])->name('purchase_register.purchased_product_movement.print');
    Route::get('purchase-register/supplier-wise-purchase-return', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchaseReturn'])->name('purchase_register.supplier_wise_purchase_return');
    Route::get('purchase-register/supplier-wise-purchase-return/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierWisePurchaseReturn'])->name('purchase_register.supplier_wise_purchase_return.print');
    Route::get('purchase-register/date-wise-purchase-return', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchaseReturn'])->name('purchase_register.date_wise_purchase_return');
    Route::get('purchase-register/date-wise-purchase-return/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printDateWisePurchaseReturn'])->name('purchase_register.date_wise_purchase_return.print');
    Route::get('purchase-register/product-wise-purchase-return', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'productWisePurchaseReturn'])->name('purchase_register.product_wise_purchase_return');
    Route::get('purchase-register/product-wise-purchase-return/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printProductWisePurchaseReturn'])->name('purchase_register.product_wise_purchase_return.print');
    Route::get('purchase-register/date-wise-purchase-order', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchaseOrder'])->name('purchase_register.date_wise_purchase_order');
    Route::get('purchase-register/date-wise-purchase-order/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printDateWisePurchaseOrder'])->name('purchase_register.date_wise_purchase_order.print');
    Route::get('purchase-register/supplier-wise-purchase-order', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchaseOrder'])->name('purchase_register.supplier_wise_purchase_order');
    Route::get('purchase-register/supplier-wise-purchase-order/print', [\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierWisePurchaseOrder'])->name('purchase_register.supplier_wise_purchase_order.print');
    
    // Sales Register Routes
    Route::get('sales-register', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'index'])->name('sales_register.index');
    Route::get('sales-register/date-wise-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSales'])->name('sales_register.date_wise');
    Route::get('sales-register/date-wise-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseSales'])->name('sales_register.date_wise.print');
    Route::get('sales-register/product-wise-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSales'])->name('sales_register.product_wise');
    Route::get('sales-register/product-wise-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseSales'])->name('sales_register.product_wise.print');
    Route::get('sales-register/customer-wise-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSales'])->name('sales_register.customer_wise');
    Route::get('sales-register/customer-wise-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseSales'])->name('sales_register.customer_wise.print');
    Route::get('sales-register/date-wise-net-product-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseNetProductSales'])->name('sales_register.date_wise_net_product');
    Route::get('sales-register/date-wise-net-product-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseNetProductSales'])->name('sales_register.date_wise_net_product.print');
    Route::get('sales-register/customer-wise-net-product-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseNetProductSales'])->name('sales_register.customer_wise_net_product');
    Route::get('sales-register/customer-wise-net-product-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseNetProductSales'])->name('sales_register.customer_wise_net_product.print');
    Route::get('sales-register/date-wise-gross-profit', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseGrossProfit'])->name('sales_register.date_wise_gross_profit');
    Route::get('sales-register/date-wise-gross-profit/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseGrossProfit'])->name('sales_register.date_wise_gross_profit.print');
    Route::get('sales-register/product-wise-gross-profit', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseGrossProfit'])->name('sales_register.product_wise_gross_profit');
    Route::get('sales-register/product-wise-gross-profit/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseGrossProfit'])->name('sales_register.product_wise_gross_profit.print');
    Route::get('sales-register/date-wise-sales-return', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesReturn'])->name('sales_register.date_wise_sales_return');
    Route::get('sales-register/date-wise-sales-return/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseSalesReturn'])->name('sales_register.date_wise_sales_return.print');
    Route::get('sales-register/product-wise-sales-return', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesReturn'])->name('sales_register.product_wise_sales_return');
    Route::get('sales-register/product-wise-sales-return/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseSalesReturn'])->name('sales_register.product_wise_sales_return.print');
    Route::get('sales-register/customer-wise-sales-return', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesReturn'])->name('sales_register.customer_wise_sales_return');
    Route::get('sales-register/customer-wise-sales-return/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseSalesReturn'])->name('sales_register.customer_wise_sales_return.print');
    Route::get('sales-register/explicit-product-wise-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'explicitProductWiseSales'])->name('sales_register.explicit_product_wise_sales');
    Route::get('sales-register/explicit-product-wise-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printExplicitProductWiseSales'])->name('sales_register.explicit_product_wise_sales.print');
    Route::get('sales-register/customer-wise-statement', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseStatement'])->name('sales_register.customer_wise_statement');
    Route::get('sales-register/customer-wise-statement/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseStatement'])->name('sales_register.customer_wise_statement.print');
    Route::get('sales-register/product-group-wise-net-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productGroupWiseNetSales'])->name('sales_register.product_group_wise_net_sales');
    Route::get('sales-register/product-group-wise-net-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductGroupWiseNetSales'])->name('sales_register.product_group_wise_net_sales.print');
    Route::get('sales-register/product-wise-sales-summary', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesSummary'])->name('sales_register.product_wise_sales_summary');
    Route::get('sales-register/product-wise-sales-summary/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseSalesSummary'])->name('sales_register.product_wise_sales_summary.print');
    Route::get('sales-register/date-wise-sales-summary', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesSummary'])->name('sales_register.date_wise_sales_summary');
    Route::get('sales-register/date-wise-sales-summary/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseSalesSummary'])->name('sales_register.date_wise_sales_summary.print');
    Route::get('sales-register/product-group-wise-net-sales-mpo', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productGroupWiseNetSalesMPO'])->name('sales_register.product_group_wise_net_sales_mpo');
    Route::get('sales-register/product-group-wise-net-sales-mpo/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductGroupWiseNetSalesMPO'])->name('sales_register.product_group_wise_net_sales_mpo.print');
    Route::get('sales-register/customer-wise-sales-summary', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesSummary'])->name('sales_register.customer_wise_sales_summary');
    Route::get('sales-register/customer-wise-sales-summary/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseSalesSummary'])->name('sales_register.customer_wise_sales_summary.print');
    Route::get('sales-register/customer-wise-invoice-status', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseInvoiceStatus'])->name('sales_register.customer_wise_invoice_status');
    Route::get('sales-register/customer-wise-invoice-status/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseInvoiceStatus'])->name('sales_register.customer_wise_invoice_status.print');
    Route::get('sales-register/product-wise-sales', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSales'])->name('sales_register.product_wise_sales');
    Route::get('sales-register/product-wise-sales/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseSales'])->name('sales_register.product_wise_sales.print');
    Route::get('sales-register/date-wise-sales-invoice', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesInvoice'])->name('sales_register.date_wise_sales_invoice');
    Route::get('sales-register/date-wise-sales-invoice/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseSalesInvoice'])->name('sales_register.date_wise_sales_invoice.print');
    Route::get('sales-register/customer-wise-gross-profit', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseGrossProfit'])->name('sales_register.customer_wise_gross_profit');
    Route::get('sales-register/customer-wise-gross-profit/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseGrossProfit'])->name('sales_register.customer_wise_gross_profit.print');
    Route::get('sales-register/product-wise-net-profit', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseNetProfit'])->name('sales_register.product_wise_net_profit');
    Route::get('sales-register/product-wise-net-profit/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseNetProfit'])->name('sales_register.product_wise_net_profit.print');
    Route::get('sales-register/customer-wise-sales-with-serial', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesWithSerial'])->name('sales_register.customer_wise_sales_with_serial');
    Route::get('sales-register/customer-wise-sales-with-serial/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseSalesWithSerial'])->name('sales_register.customer_wise_sales_with_serial.print');
    Route::get('sales-register/product-wise-sales-with-serial', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesWithSerial'])->name('sales_register.product_wise_sales_with_serial');
    Route::get('sales-register/product-wise-sales-with-serial/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseSalesWithSerial'])->name('sales_register.product_wise_sales_with_serial.print');
    Route::get('sales-register/daily-sales-details', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dailySalesDetails'])->name('sales_register.daily_sales_details');
    Route::get('sales-register/daily-sales-details/print', [\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDailySalesDetails'])->name('sales_register.daily_sales_details.print');
    
    // Stock Register Routes
    Route::get('stock-register', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'index'])->name('stock_register.index');
    
    // Current Stock (Combined) Routes
    Route::get('stock-register/current-stock-combined', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockCombined'])->name('stock_register.current_stock_combined');
    Route::get('stock-register/current-stock-combined/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printCurrentStockCombined'])->name('stock_register.current_stock_combined.print');
    
    // Current Stock (c) Routes
    Route::get('stock-register/current-stock-c', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockC'])->name('stock_register.current_stock_c');
    Route::get('stock-register/current-stock-c/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printCurrentStockC'])->name('stock_register.current_stock_c.print');
    
    // Current Stock With Serial Routes
    Route::get('stock-register/current-stock-with-serial', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockWithSerial'])->name('stock_register.current_stock_with_serial');
    Route::get('stock-register/current-stock-with-serial/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printCurrentStockWithSerial'])->name('stock_register.current_stock_with_serial.print');
    
    // Combined Current Stock (All BR Summary) Routes
    Route::get('stock-register/combined-current-stock-all-br-summary', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'combinedCurrentStockAllBrSummary'])->name('stock_register.combined_current_stock_all_br_summary');
    Route::get('stock-register/combined-current-stock-all-br-summary/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printCombinedCurrentStockAllBrSummary'])->name('stock_register.combined_current_stock_all_br_summary.print');
    
    // Date Wise Product Status Routes
    Route::get('stock-register/date-wise-product-status', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductStatus'])->name('stock_register.date_wise_product_status');
    Route::get('stock-register/date-wise-product-status/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseProductStatus'])->name('stock_register.date_wise_product_status.print');
    
    // Date Wise Stock Routes
    Route::get('stock-register/date-wise-stock', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStock'])->name('stock_register.date_wise_stock');
    Route::get('stock-register/date-wise-stock/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseStock'])->name('stock_register.date_wise_stock.print');
    
    // Product Price List Routes
    Route::get('stock-register/product-price-list', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'productPriceList'])->name('stock_register.product_price_list');
    Route::get('stock-register/product-price-list/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printProductPriceList'])->name('stock_register.product_price_list.print');
    
    // Supplier Wise Current Stock Routes
    Route::get('stock-register/supplier-wise-current-stock', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'supplierWiseCurrentStock'])->name('stock_register.supplier_wise_current_stock');
    Route::get('stock-register/supplier-wise-current-stock/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printSupplierWiseCurrentStock'])->name('stock_register.supplier_wise_current_stock.print');
    
    // Date Wise Product In Out Statement Routes
    Route::get('stock-register/date-wise-product-in-out-statement', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductInOutStatement'])->name('stock_register.date_wise_product_in_out_statement');
    Route::get('stock-register/date-wise-product-in-out-statement/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseProductInOutStatement'])->name('stock_register.date_wise_product_in_out_statement.print');
    
    // Date Wise Stock Serial (M) Routes
    Route::get('stock-register/date-wise-stock-serial-m', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStockSerialM'])->name('stock_register.date_wise_stock_serial_m');
    Route::get('stock-register/date-wise-stock-serial-m/print', [\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseStockSerialM'])->name('stock_register.date_wise_stock_serial_m.print');
    
    // Accounts Register Routes
    Route::get('accounts-register', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'index'])->name('accounts_register.index');
    
    // Due List Routes
    Route::get('accounts-register/due-list', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueList'])->name('accounts_register.due_list');
    Route::get('accounts-register/due-list/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDueList'])->name('accounts_register.due_list.print');
    
    // All Customers Due List Routes
    Route::get('accounts-register/all-customers-due-list', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'allCustomersDueList'])->name('accounts_register.all_customers_due_list');
    Route::get('accounts-register/all-customers-due-list/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printAllCustomersDueList'])->name('accounts_register.all_customers_due_list.print');
    
    // Supplier Due List Routes
    Route::get('accounts-register/supplier-due-list', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'supplierDueList'])->name('accounts_register.supplier_due_list');
    Route::get('accounts-register/supplier-due-list/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printSupplierDueList'])->name('accounts_register.supplier_due_list.print');
    
    // Accounts Ledger Routes
    Route::get('accounts-register/customer-accounts-ledger', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerAccountsLedger'])->name('accounts_register.customer_accounts_ledger');
    Route::get('accounts-register/customer-accounts-ledger/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCustomerAccountsLedger'])->name('accounts_register.customer_accounts_ledger.print');
    
    // Cash Book Routes
    Route::get('accounts-register/cash-book', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashBook'])->name('accounts_register.cash_book');
    Route::get('accounts-register/cash-book/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCashBook'])->name('accounts_register.cash_book.print');
    
    // Date Wise Credit Voucher Routes
    Route::get('accounts-register/date-wise-credit-voucher', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseCreditVoucher'])->name('accounts_register.date_wise_credit_voucher');
    Route::get('accounts-register/date-wise-credit-voucher/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseCreditVoucher'])->name('accounts_register.date_wise_credit_voucher.print');
    
    // Date Wise Debit Voucher Routes
    Route::get('accounts-register/date-wise-debit-voucher', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseDebitVoucher'])->name('accounts_register.date_wise_debit_voucher');
    Route::get('accounts-register/date-wise-debit-voucher/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseDebitVoucher'])->name('accounts_register.date_wise_debit_voucher.print');
    
    // Income Statement Routes
    Route::get('accounts-register/income-statement', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'incomeStatement'])->name('accounts_register.income_statement');
    Route::get('accounts-register/income-statement/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printIncomeStatement'])->name('accounts_register.print_income_statement');
    
    // Day Book Routes
    Route::get('accounts-register/day-book', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dayBook'])->name('accounts_register.day_book');
    Route::get('accounts-register/day-book/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDayBook'])->name('accounts_register.print_day_book');
    
    // Due List Without Treatment Routes
    Route::get('accounts-register/due-list-without-treatment', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueListWithoutTreatment'])->name('accounts_register.due_list_without_treatment');
    Route::get('accounts-register/due-list-without-treatment/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDueListWithoutTreatment'])->name('accounts_register.print_due_list_without_treatment');
    
    // Date Wise Sales Received Routes
    Route::get('accounts-register/date-wise-sales-received', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseSalesReceived'])->name('accounts_register.date_wise_sales_received');
    Route::get('accounts-register/date-wise-sales-received/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseSalesReceived'])->name('accounts_register.print_date_wise_sales_received');
    
    // Balance Sheet Routes
    Route::get('accounts-register/balance-sheet', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'balanceSheet'])->name('accounts_register.balance_sheet');
    Route::get('accounts-register/balance-sheet/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printBalanceSheet'])->name('accounts_register.print_balance_sheet');
    
    // Date Wise General Expenses Routes
    Route::get('accounts-register/date-wise-general-expenses', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseGeneralExpenses'])->name('accounts_register.date_wise_general_expenses');
    Route::get('accounts-register/date-wise-general-expenses/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseGeneralExpenses'])->name('accounts_register.print_date_wise_general_expenses');
    
    // Accounts Receivable Routes
    Route::get('accounts-register/accounts-receivable', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'accountsReceivable'])->name('accounts_register.accounts_receivable');
    Route::get('accounts-register/accounts-receivable/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printAccountsReceivable'])->name('accounts_register.print_accounts_receivable');
    
    // Accounts Payable Routes
    Route::get('accounts-register/accounts-payable', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'accountsPayable'])->name('accounts_register.accounts_payable');
    Route::get('accounts-register/accounts-payable/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printAccountsPayable'])->name('accounts_register.print_accounts_payable');
    
    // Customer Due With Ageing Routes
    Route::get('accounts-register/customer-due-with-ageing', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerDueWithAgeing'])->name('accounts_register.customer_due_with_ageing');
    Route::get('accounts-register/customer-due-with-ageing/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCustomerDueWithAgeing'])->name('accounts_register.print_customer_due_with_ageing');
    
    // Cash Flows Routes
    Route::get('accounts-register/cash-flows', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashFlows'])->name('accounts_register.cash_flows');
    Route::get('accounts-register/cash-flows/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCashFlows'])->name('accounts_register.print_cash_flows');
    
    // Date Wise Receipt Payment Statement Routes
    Route::get('accounts-register/date-wise-receipt-payment-statement', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceiptPaymentStatement'])->name('accounts_register.date_wise_receipt_payment_statement');
    Route::get('accounts-register/date-wise-receipt-payment-statement/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseReceiptPaymentStatement'])->name('accounts_register.print_date_wise_receipt_payment_statement');
    Route::get('accounts-register/date-wise-receive', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceive'])->name('accounts_register.date_wise_receive');
    Route::get('accounts-register/date-wise-receive/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseReceive'])->name('accounts_register.print_date_wise_receive');
    Route::get('accounts-register/date-wise-sales-with-profit', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseSalesWithProfit'])->name('accounts_register.date_wise_sales_with_profit');
    Route::get('accounts-register/date-wise-sales-with-profit/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseSalesWithProfit'])->name('accounts_register.print_date_wise_sales_with_profit');
    Route::get('accounts-register/date-wise-net-profit', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseNetProfit'])->name('accounts_register.date_wise_net_profit');
    Route::get('accounts-register/date-wise-net-profit/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseNetProfit'])->name('accounts_register.print_date_wise_net_profit');
    Route::get('accounts-register/profit-loss-tally-style', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'profitLossTallyStyle'])->name('accounts_register.profit_loss_tally_style');
    Route::get('accounts-register/profit-loss-tally-style/get-data', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'getProfitLossData'])->name('accounts_register.profit_loss_tally_style.get_data');
    Route::get('accounts-register/customer-account-statement', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerAccountStatement'])->name('accounts_register.customer_account_statement');
    Route::get('accounts-register/customer-account-statement/print', [\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCustomerAccountStatement'])->name('accounts_register.customer_account_statement.print');
    
    // Install Routes
    Route::get('install', [\Modules\BusinessManagement\Http\Controllers\InstallController::class, 'index'])->name('install.index');
    Route::post('install', [\Modules\BusinessManagement\Http\Controllers\InstallController::class, 'install'])->name('install.install');
    Route::get('install/uninstall', [\Modules\BusinessManagement\Http\Controllers\InstallController::class, 'uninstall'])->name('install.uninstall');
    Route::get('install/update', [\Modules\BusinessManagement\Http\Controllers\InstallController::class, 'update'])->name('install.update');
});

