@extends('layouts.app')
@section('title', __('businessmanagement::lang.product_price_list'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.product_price_list') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'productPriceList']), 'method' => 'get', 'id' => 'product_price_list_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date', __('report.date') . ':') !!}
                        @php
                            $date_value = '';
                            if (!empty($date)) {
                                $date_value = \Carbon\Carbon::parse($date)->format('d/m/Y');
                            } elseif (!empty(request()->date)) {
                                $date_value = request()->date;
                            }
                        @endphp
                        {!! Form::text('date', $date_value , ['placeholder' => __('businessmanagement::lang.select_date'), 'class' => 'form-control', 'id' => 'product_price_list_date', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('businessmanagement::lang.all_categories'), 'single' => __('businessmanagement::lang.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('businessmanagement::lang.all_products'), 'single' => __('businessmanagement::lang.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'productPriceList']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printProductPriceList'], ['date' => \Carbon\Carbon::parse($date)->format('d/m/Y'), 'location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $product_group => $items)
                            <table class="table table-bordered table-striped" style="font-size: 12px; margin-bottom: 20px;">
                                <thead>
                                    <tr>
                                        <th>Product Group</th>
                                        <th>Product Model</th>
                                        <th>Product Description</th>
                                        <th>Unit</th>
                                        <th style="text-align: right;">Purchase Price</th>
                                        <th style="text-align: right;">MRP</th>
                                        <th style="text-align: right;">Lower Price</th>
                                        <th style="text-align: right;">Dealer-A</th>
                                        <th style="text-align: right;">Dealer-B</th>
                                        <th style="text-align: right;">Dealer-C</th>
                                        <th style="text-align: right;">Retailer-A</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $item)
                                        <tr>
                                            <td>{{ $item->product_group }}</td>
                                            <td>{{ $item->product_model }}</td>
                                            <td>{{ $item->product_description }}</td>
                                            <td>{{ $item->unit }}</td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->purchase_price }}</span></td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->mrp }}</span></td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->lower_price }}</span></td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->dealer_a }}</span></td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->dealer_b }}</span></td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->dealer_c }}</span></td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->retailer_a }}</span></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No product price data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('#product_price_list_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });
    });
</script>
@endsection

