@extends('layouts.app')
@section('title', 'Product Group wise Net Sales')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Product Group wise Net Sales</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productGroupWiseNetSales']), 'method' => 'get', 'id' => 'product_group_wise_net_sales_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_group_wise_net_sales_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('lang_v1.all_categories'), 'single' => __('lang_v1.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('lang_v1.all_products'), 'single' => __('lang_v1.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productGroupWiseNetSales']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductGroupWiseNetSales'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id, 'category_id' => $category_id, 'product_id' => $product_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($brands_data) > 0)
                        @foreach($brands_data as $brand_id => $brand_data)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; font-weight: bold; color: #2c3e50;">Product Brand/ Group: {{ $brand_data['brand_name'] }}</h4>
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th style="text-align: right;">Sale Qty</th>
                                        <th style="text-align: right;">Unit Price</th>
                                        <th style="text-align: right;">Sales Amount</th>
                                        <th style="text-align: right;">Return Qty</th>
                                        <th style="text-align: right;">Return Amount</th>
                                        <th style="text-align: right;">Net Qty</th>
                                        <th style="text-align: right;">Net Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($brand_data['products'] as $product)
                                        <tr>
                                            <td>{{ $product['product_name'] }}</td>
                                            <td style="text-align: right;">{{ number_format($product['sale_qty'], 2) }}</td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $product['unit_price'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $product['sales_amount'] }}</span>
                                            </td>
                                            <td style="text-align: right;">{{ number_format($product['return_qty'], 2) }}</td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $product['return_amount'] }}</span>
                                            </td>
                                            <td style="text-align: right;">{{ number_format($product['net_qty'], 2) }}</td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $product['net_amount'] }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                    <!-- Sub Total Row -->
                                    <tr style="background-color: #f5f5f5; font-weight: bold;">
                                        <td style="text-align: right;">Sub Total:</td>
                                        <td style="text-align: right;">{{ number_format($brand_data['total_sale_qty'], 2) }}</td>
                                        <td style="text-align: right;"></td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $brand_data['total_sales_amount'] }}</span>
                                        </td>
                                        <td style="text-align: right;">{{ number_format($brand_data['total_return_qty'], 2) }}</td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $brand_data['total_return_amount'] }}</span>
                                        </td>
                                        <td style="text-align: right;">{{ number_format($brand_data['total_net_qty'], 2) }}</td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $brand_data['total_net_amount'] }}</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                        
                        <!-- Grand Total -->
                        <table class="table table-bordered" style="font-size: 12px; margin-top: 20px;">
                            <tfoot>
                                <tr style="background-color: #e8e8e8; font-weight: bold; border-top: 2px solid #000;">
                                    <td style="text-align: right;">Grand Total:</td>
                                    <td style="text-align: right; border-bottom: 2px solid #000;">{{ number_format($grand_total_sale_qty, 2) }}</td>
                                    <td style="text-align: right;"></td>
                                    <td style="text-align: right; border-bottom: 2px solid #000;">
                                        <span class="display_currency" data-currency_symbol="true">{{ $grand_total_sales_amount }}</span>
                                    </td>
                                    <td style="text-align: right;">{{ number_format($grand_total_return_qty, 2) }}</td>
                                    <td style="text-align: right;">
                                        <span class="display_currency" data-currency_symbol="true">{{ $grand_total_return_amount }}</span>
                                    </td>
                                    <td style="text-align: right;">{{ number_format($grand_total_net_qty, 2) }}</td>
                                    <td style="text-align: right; border-bottom: 2px solid #000;">
                                        <span class="display_currency" data-currency_symbol="true">{{ $grand_total_net_amount }}</span>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No sales data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#product_group_wise_net_sales_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#product_group_wise_net_sales_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#product_group_wise_net_sales_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#product_group_wise_net_sales_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val('').trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val('').trigger('change');
            }
        });

        // Reload when date range changes
        $('#product_group_wise_net_sales_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection


