<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date Wise Sales Invoice</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
        }
        
        .invoice-container {
            width: 100%;
            margin-bottom: 30px;
            page-break-inside: avoid;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 700;
            margin-bottom: 5px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Invoice Title */
        .invoice-title {
            font-size: 16pt;
            font-weight: 700;
            margin: 20px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        /* Invoice Details Section */
        .invoice-details {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        
        .invoice-details-left {
            display: table-cell;
            vertical-align: top;
            width: 50%;
        }
        
        .invoice-details-right {
            display: table-cell;
            vertical-align: top;
            width: 50%;
            text-align: right;
        }
        
        .detail-row {
            margin-bottom: 5px;
            font-size: 9pt;
        }
        
        .detail-label {
            font-weight: 600;
            display: inline-block;
            width: 120px;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            font-size: 9pt;
        }
        
        table thead th {
            background-color: #f5f5f5;
            border: 1px solid #2c3e50;
            padding: 8px 5px;
            text-align: center;
            font-weight: 600;
            font-size: 9pt;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 6px 5px;
            font-size: 9pt;
            text-align: left;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        table tbody td.text-center {
            text-align: center;
        }
        
        table tfoot td {
            border: 1px solid #2c3e50;
            padding: 6px 5px;
            font-size: 9pt;
        }
        
        table tfoot td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .summary-row {
            font-weight: 600;
        }
        
        .net-payable-row {
            background-color: #f5f5f5;
            font-weight: 700;
            font-size: 10pt;
        }
        
        @media print {
            .invoice-container {
                page-break-after: always;
            }
            
            .invoice-container:last-child {
                page-break-after: auto;
            }
        }
    </style>
</head>
<body>
    @foreach($grouped_data as $date => $date_transactions)
        @foreach($date_transactions as $transaction)
            <div class="invoice-container">
                <!-- Company Header -->
                <div class="header">
                    <div class="header-left">
                        @if(!empty($logo))
                            <img src="{{ $logo }}" alt="Logo" class="company-logo">
                        @endif
                    </div>
                    <div class="header-center">
                        <div class="company-name">{{ $business->name }}</div>
                        @if(!empty($business->landmark))
                            <div class="company-address">{{ $business->landmark }}</div>
                        @endif
                        @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                            <div class="company-address">
                                @if(!empty($business->city)){{ $business->city }}, @endif
                                @if(!empty($business->state)){{ $business->state }}, @endif
                                @if(!empty($business->country)){{ $business->country }}@endif
                            </div>
                        @endif
                    </div>
                    <div class="header-right">
                        @if(!empty($business->mobile))
                            <div class="company-contact">Mobile: {{ $business->mobile }}</div>
                        @endif
                        @if(!empty($business->alternate_number))
                            <div class="company-contact">{{ $business->alternate_number }}</div>
                        @endif
                        @if(!empty($business->phone))
                            <div class="company-contact">Phone: {{ $business->phone }}</div>
                        @endif
                        @if(!empty($business->email))
                            <div class="company-contact">Email: {{ $business->email }}</div>
                        @endif
                        @if(!empty($business->website))
                            <div class="company-contact">{{ $business->website }}</div>
                        @endif
                    </div>
                </div>

                <!-- Invoice Title -->
                <div class="invoice-title">Sales Invoice</div>

                <!-- Invoice Details -->
                <div class="invoice-details">
                    <div class="invoice-details-left">
                        <div class="detail-row">
                            <span class="detail-label">Customer:</span>
                            @if(!empty($transaction->contact))
                                {{ !empty($transaction->contact->supplier_business_name) ? $transaction->contact->supplier_business_name : ($transaction->contact->name ?? 'WALKING CUSTOMER') }}
                            @else
                                WALKING CUSTOMER
                            @endif
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Address:</span>
                            {{ $transaction->contact->address ?? '' }}
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Mobile:</span>
                            {{ $transaction->contact->mobile ?? '' }}
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">SR Name:</span>
                            {{ $transaction->contact->custom_field1 ?? '' }}
                        </div>
                    </div>
                    <div class="invoice-details-right">
                        <div class="detail-row">
                            <span class="detail-label">Invoice No.:</span>
                            {{ $transaction->invoice_no }}
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Date & Time:</span>
                            {{ $util->format_date($transaction->transaction_date, true) }}
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Order No.:</span>
                            {{ $transaction->ref_no ?? '' }}
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Prepared By:</span>
                            {{ $transaction->sales_person->user_full_name ?? '' }}
                        </div>
                    </div>
                </div>

                <!-- Product Details Table -->
                <table>
                    <thead>
                        <tr>
                            <th>SL</th>
                            <th>Product Code</th>
                            <th>Product Description</th>
                            <th>Qty</th>
                            <th>Unit Price</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($transaction->sell_lines as $index => $line)
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                <td>
                                    @if($line->product)
                                        {{ $line->product->sku ?? ($line->variations->sub_sku ?? '') }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td>
                                    @if($line->product)
                                        @if($line->product->type == 'variable' && $line->variations)
                                            {{ $line->product->name }} - {{ $line->variations->name }}
                                        @else
                                            {{ $line->product->name }}
                                        @endif
                                    @else
                                        N/A
                                    @endif
                                </td>
                                <td class="text-right">{{ number_format($line->quantity - $line->quantity_returned, 2) }}</td>
                                <td class="text-right">{{ number_format($line->unit_price_inc_tax, 2) }}</td>
                                <td class="text-right">{{ number_format(($line->quantity - $line->quantity_returned) * $line->unit_price_inc_tax, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="summary-row">
                            <td colspan="3" class="text-right">Total Qty:</td>
                            <td class="text-right">{{ number_format($transaction->sell_lines->sum(function($l) { return $l->quantity - $l->quantity_returned; }), 2) }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="summary-row">
                            <td colspan="3" class="text-right">Taka in word:</td>
                            <td colspan="3">
                                {{ ucwords($util->numToWord($transaction->final_total, 'en', 'international')) }} Only
                            </td>
                        </tr>
                        <tr class="summary-row">
                            <td colspan="3" class="text-right">Total Amount:</td>
                            <td colspan="3" class="text-right">{{ number_format($transaction->total_before_tax, 2) }}</td>
                        </tr>
                        <tr class="summary-row">
                            <td colspan="3" class="text-right">Less Discount:</td>
                            <td colspan="3" class="text-right">{{ number_format($transaction->discount_amount ?? 0, 2) }}</td>
                        </tr>
                        <tr class="summary-row">
                            <td colspan="3" class="text-right">Add Extra Charges:</td>
                            <td colspan="3" class="text-right">{{ number_format(($transaction->shipping_charges ?? 0) + ($transaction->packing_charge ?? 0), 2) }}</td>
                        </tr>
                        <tr class="net-payable-row">
                            <td colspan="3" class="text-right">Net Payable Amount:</td>
                            <td colspan="3" class="text-right">{{ number_format($transaction->final_total, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endforeach
    @endforeach
</body>
</html>

