@extends('layouts.app')
@section('title', 'Customer Wise Sales Summary')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Customer Wise Sales Summary</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesSummary']), 'method' => 'get', 'id' => 'customer_wise_sales_summary_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'customer_wise_sales_summary_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', ['all' => __('lang_v1.all_customers'), 'single' => __('lang_v1.single_customer')], !empty($customer_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="customer_select_wrapper" style="display: {{ !empty($customer_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesSummary']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseSalesSummary'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id, 'customer_id' => $customer_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($transactions) > 0)
                        @foreach($grouped_data as $contact_id => $customer_transactions)
                            @php
                                $customer = $customer_transactions->first()->contact;
                                $customer_name = 'WALKING CUSTOMER';
                                $customer_address = '';
                                $customer_email = '';
                                
                                if (!empty($customer)) {
                                    $customer_name = !empty($customer->supplier_business_name) 
                                        ? $customer->supplier_business_name 
                                        : ($customer->name ?? 'WALKING CUSTOMER');
                                    $customer_address = $customer->address_line_1 ?? '';
                                    if (!empty($customer->address_line_2)) {
                                        $customer_address .= ($customer_address ? ', ' : '') . $customer->address_line_2;
                                    }
                                    if (!empty($customer->city)) {
                                        $customer_address .= ($customer_address ? ', ' : '') . $customer->city;
                                    }
                                    $customer_email = $customer->email ?? '';
                                }
                            @endphp
                            
                            <div style="margin-bottom: 30px; page-break-after: always;">
                                <!-- Customer Header -->
                                <div style="margin-bottom: 15px;">
                                    <h3 style="text-align: center; text-decoration: underline; font-weight: bold; margin-bottom: 10px;">Customer Wise Sales Summary</h3>
                                    <div style="text-align: center; margin-bottom: 15px;">
                                        @if(!empty($start_date) && !empty($end_date))
                                            {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
                                        @endif
                                    </div>
                                    
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 15px;">
                                        <div style="width: 50%;">
                                            <div style="margin-bottom: 5px;"><strong>Name :</strong> {{ $customer_name }}</div>
                                            <div><strong>Address :</strong> {{ $customer_address }}</div>
                                        </div>
                                        <div style="width: 50%; text-align: right;">
                                            <div><strong>Email :</strong> {{ $customer_email }}</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <hr style="border-top: 1px solid #000; margin: 10px 0;">
                                
                                <!-- Product Table Header -->
                                <table class="table table-bordered" style="font-size: 12px; margin-bottom: 0;">
                                    <thead>
                                        <tr>
                                            <th>Product Caption</th>
                                            <th style="text-align: right;">Qty</th>
                                            <th style="text-align: right;">Unit Price</th>
                                            <th style="text-align: right;">Discount</th>
                                            <th style="text-align: right;">Net Unit Price</th>
                                            <th style="text-align: right;">Amount</th>
                                        </tr>
                                    </thead>
                                </table>
                                
                                <hr style="border-top: 1px solid #000; margin: 0;">
                                
                                @foreach($customer_transactions as $transaction)
                                    @php
                                        $total_qty = $transaction->sell_lines->sum(function($line) {
                                            return $line->quantity - $line->quantity_returned;
                                        });
                                        
                                        $total_amount = $transaction->total_before_tax ?? 0;
                                        $vat = $transaction->tax_amount ?? 0;
                                        $discount = $transaction->discount_amount ?? 0;
                                        $service_charge = ($transaction->shipping_charges ?? 0) + ($transaction->additional_expense_value_1 ?? 0) + ($transaction->additional_expense_value_2 ?? 0);
                                        $net_payable = $transaction->final_total ?? 0;
                                    @endphp
                                    
                                    <!-- Invoice Details Row -->
                                    <div style="background-color: #d3d3d3; padding: 8px; display: flex; justify-content: space-between; border: 1px solid #000; border-top: none;">
                                        <div><strong>Invoice No.</strong> {{ $transaction->invoice_no }}</div>
                                        <div><strong>Ref No.</strong> {{ $transaction->ref_no ?? '' }}</div>
                                        <div><strong>Date :</strong> {{ $util->format_date($transaction->transaction_date, false) }}</div>
                                    </div>
                                    
                                    <!-- Product Lines -->
                                    <table class="table table-bordered" style="font-size: 12px; margin-bottom: 0;">
                                        <tbody>
                                            @foreach($transaction->sell_lines as $line)
                                                @php
                                                    $qty = $line->quantity - $line->quantity_returned;
                                                    $product_name = $line->product->name ?? 'N/A';
                                                    if ($line->product && $line->product->type == 'variable' && $line->variations) {
                                                        $variation_name = $line->variations->name ?? '';
                                                        $product_variation_name = $line->variations->product_variation->name ?? '';
                                                        if ($variation_name || $product_variation_name) {
                                                            $product_name .= ' - ' . ($product_variation_name ? $product_variation_name . ' - ' : '') . $variation_name;
                                                        }
                                                    }
                                                    $unit_price = $line->unit_price_before_discount ?? $line->unit_price_inc_tax ?? 0;
                                                    $line_discount = method_exists($line, 'get_discount_amount') ? $line->get_discount_amount() : ($line->line_discount_amount ?? 0);
                                                    $net_unit_price = $line->unit_price_inc_tax ?? 0;
                                                    $line_amount = $qty * $net_unit_price;
                                                @endphp
                                                <tr>
                                                    <td>{{ $product_name }}</td>
                                                    <td style="text-align: right;">{{ number_format($qty, 2) }}</td>
                                                    <td style="text-align: right;">
                                                        <span class="display_currency" data-currency_symbol="true">{{ $unit_price }}</span>
                                                    </td>
                                                    <td style="text-align: right;">
                                                        <span class="display_currency" data-currency_symbol="true">{{ $line_discount }}</span>
                                                    </td>
                                                    <td style="text-align: right;">
                                                        <span class="display_currency" data-currency_symbol="true">{{ $net_unit_price }}</span>
                                                    </td>
                                                    <td style="text-align: right;">
                                                        <span class="display_currency" data-currency_symbol="true">{{ $line_amount }}</span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    
                                    <!-- Summary Section -->
                                    <div style="display: flex; justify-content: flex-end; margin-top: 10px; margin-bottom: 15px;">
                                        <div style="width: 300px;">
                                            <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                                <strong>Total Amount</strong>
                                                <span class="display_currency" data-currency_symbol="true">{{ $total_amount }}</span>
                                            </div>
                                            <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                                <strong>VAT</strong>
                                                <span class="display_currency" data-currency_symbol="true">{{ $vat }}</span>
                                            </div>
                                            <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                                <strong>Less Discount</strong>
                                                <span class="display_currency" data-currency_symbol="true">{{ $discount }}</span>
                                            </div>
                                            <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                                <strong>Service Charge</strong>
                                                <span class="display_currency" data-currency_symbol="true">{{ $service_charge }}</span>
                                            </div>
                                            <hr style="border-top: 1px solid #000; margin: 10px 0;">
                                            <div style="display: flex; justify-content: space-between; font-weight: bold;">
                                                <strong>Net Payable Amount</strong>
                                                <span class="display_currency" data-currency_symbol="true">{{ $net_payable }}</span>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endforeach
                        
                        <!-- Grand Totals Footer -->
                        <div style="background-color: #d3d3d3; padding: 10px; margin-top: 20px; border: 1px solid #000;">
                            <div style="display: flex; justify-content: space-between;">
                                <div>
                                    <strong>Total VAT:</strong> <span class="display_currency" data-currency_symbol="true">{{ $grand_total_vat }}</span> | 
                                    <strong>Total AIT:</strong> <span class="display_currency" data-currency_symbol="true">{{ $grand_total_ait }}</span> | 
                                    <strong>Total Discount:</strong> <span class="display_currency" data-currency_symbol="true">{{ $grand_total_discount }}</span> | 
                                    <strong>Total Service Charge:</strong> <span class="display_currency" data-currency_symbol="true">{{ $grand_total_service_charge }}</span>
                                </div>
                                <div>
                                    <strong>Total:</strong> <span class="display_currency" data-currency_symbol="true">{{ $grand_total }}</span>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No sales data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#customer_wise_sales_summary_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#customer_wise_sales_summary_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#customer_wise_sales_summary_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#customer_wise_sales_summary_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val('').trigger('change');
            }
        });

        // Reload when date range changes
        $('#customer_wise_sales_summary_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection


