<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Income Statement</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 100%;
            text-align: center;
            padding-left: 0;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #000;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #000;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 5px 0;
            text-transform: uppercase;
            color: #000;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 12px;
            color: #000;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tbody {
            display: table-row-group;
        }
        
        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        th {
            background-color: #f8f9fa;
            font-weight: 700;
            text-align: left;
            padding: 6px 8px;
            border: 1px solid #000;
            font-size: 9pt;
        }
        
        th.text-right {
            text-align: right;
        }
        
        td {
            padding: 5px 8px;
            border: 1px solid #000;
            font-size: 9pt;
        }
        
        td.text-right {
            text-align: right;
        }
        
        .underline {
            border-top: 1px solid #000;
        }
        
        .double-underline {
            border-top: 2px double #000;
        }
        
        .bold {
            font-weight: 700;
        }
        
        .footer {
            margin-top: 15px;
            font-size: 8pt;
            text-align: center;
            color: #666;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? '' }}</div>
                @php
                    $address_parts = [];
                    if (!empty($business->address_line_1)) {
                        $address_parts[] = $business->address_line_1;
                    }
                    if (!empty($business->address_line_2)) {
                        $address_parts[] = $business->address_line_2;
                    }
                    if (!empty($business->city)) {
                        $address_parts[] = $business->city;
                    }
                    if (!empty($business->state)) {
                        $address_parts[] = $business->state;
                    }
                    if (!empty($business->country)) {
                        $address_parts[] = $business->country;
                    }
                    $full_address = implode(', ', $address_parts);
                @endphp
                @if(!empty($full_address))
                    <div class="company-address">{{ $full_address }}</div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">Phone: {{ $business->mobile }}{{ !empty($business->alternate_number) ? ', ' . $business->alternate_number : '' }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">Email: {{ $business->email }}</div>
                @endif
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Income Statement</div>
        
        <!-- Report Date -->
        <div class="report-date">
            @php
                $start_date_formatted = !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : date('d/m/Y');
                $end_date_formatted = !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : date('d/m/Y');
            @endphp
            {{ $start_date_formatted }} To {{ $end_date_formatted }}
        </div>
        
        <!-- Income Statement Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 60%;">A/C Ledger Name</th>
                    <th style="width: 40%; text-align: right;">Amount</th>
                </tr>
            </thead>
            <tbody>
                <!-- Revenue Section -->
                <tr>
                    <td><strong>Sales Accounts</strong></td>
                    <td class="text-right">{{ $util->num_f($sales_accounts, true, null) }}</td>
                </tr>
                <tr>
                    <td>Cost of Goods Sold</td>
                    <td class="text-right">{{ $util->num_f($cost_of_goods_sold, true, null) }}</td>
                </tr>
                <tr>
                    <td>Sales Return A/C</td>
                    <td class="text-right">{{ $util->num_f($sales_return, true, null) }}</td>
                </tr>
                <tr>
                    <td>Cost Of Goods Sales Return</td>
                    <td class="text-right">{{ $util->num_f($cost_of_goods_sales_return, true, null) }}</td>
                </tr>
                <tr>
                    <td>Extracharges On Sales</td>
                    <td class="text-right">{{ $util->num_f($extracharges_on_sales, true, null) }}</td>
                </tr>
                <tr>
                    <td>Extracharges On Purchase</td>
                    <td class="text-right">{{ $util->num_f($extracharges_on_purchase, true, null) }}</td>
                </tr>
                <tr>
                    <td>Discount on Sales</td>
                    <td class="text-right">{{ $util->num_f($discount_on_sales, true, null) }}</td>
                </tr>
                <tr class="underline">
                    <td class="bold">Gross Profit</td>
                    <td class="text-right bold">{{ $util->num_f($gross_profit, true, null) }}</td>
                </tr>
                
                <!-- Expenses Section -->
                @if(count($expenses_by_category) > 0)
                    @foreach($expenses_by_category as $category)
                        <tr>
                            <td colspan="2" style="padding-top: 8px;"><strong>{{ $category['category_name'] }}:</strong></td>
                        </tr>
                        @foreach($category['items'] as $item)
                            <tr>
                                <td style="padding-left: 30px;">{{ $item['name'] }}</td>
                                <td class="text-right">{{ $util->num_f($item['amount'], true, null) }}</td>
                            </tr>
                        @endforeach
                        <tr class="underline">
                            <td class="bold">Expense Sub Total</td>
                            <td class="text-right bold">{{ $util->num_f($category['sub_total'], true, null) }}</td>
                        </tr>
                    @endforeach
                @endif
                
                <!-- Total Expense -->
                <tr class="double-underline">
                    <td class="bold">Total Expense</td>
                    <td class="text-right bold">{{ $util->num_f($total_expense, true, null) }}</td>
                </tr>
                
                <!-- Net Profit -->
                <tr class="double-underline">
                    <td class="bold">Current Period</td>
                    <td class="text-right"></td>
                </tr>
                <tr>
                    <td style="padding-left: 30px;" class="bold">Profit A/C</td>
                    <td class="text-right bold">{{ $util->num_f($net_profit, true, null) }}</td>
                </tr>
            </tbody>
        </table>
        
        <!-- Footer -->
        <div class="footer">
            <div>Print Date & Time: {{ date('d/m/Y h:i:s A') }}</div>
            <div>Page 1 of 1</div>
        </div>
    </div>
    
    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>

