<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date Wise Debit Voucher</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 100%;
            text-align: left;
            padding-left: 0;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #000;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #000;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 5px 0;
            text-transform: uppercase;
            color: #000;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #000;
        }
        
        .payment-type {
            font-size: 10pt;
            font-weight: 700;
            color: #0066cc;
            margin-bottom: 5px;
        }
        
        .payment-method {
            font-size: 9pt;
            margin-bottom: 8px;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table thead {
            background-color: transparent;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: 700;
            font-size: 8pt;
            background-color: transparent;
        }
        
        table th:nth-child(1) {
            text-align: center;
        }
        
        table th:nth-child(2),
        table th:nth-child(3),
        table th:nth-child(4),
        table th:nth-child(5),
        table th:nth-child(6),
        table th:nth-child(7),
        table th:nth-child(8),
        table th:nth-child(9) {
            text-align: left;
        }
        
        table th:nth-child(10) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 4px 3px;
            font-size: 8pt;
        }
        
        table td:nth-child(1) {
            text-align: center;
        }
        
        table td:nth-child(2),
        table td:nth-child(3),
        table td:nth-child(4),
        table td:nth-child(5),
        table td:nth-child(6),
        table td:nth-child(7),
        table td:nth-child(8),
        table td:nth-child(9) {
            text-align: left;
        }
        
        table td:nth-child(10) {
            text-align: right;
        }
        
        tfoot tr {
            background-color: #f0f0f0;
            font-weight: 700;
        }
        
        tfoot tr:last-child {
            background-color: #ffffff;
        }
        
        .sub-total-blue {
            color: #0066cc;
            font-weight: 700;
        }
        
        .total-underline {
            border-top: 2px double #000;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            font-size: 10pt;
            color: #666;
        }
        
        .section-spacing {
            margin-bottom: 20px;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-center">
                <div class="company-name">{{ $business->name }}</div>
                <div class="company-address">
                    @if(!empty($business->address_line_1))
                        {{ $business->address_line_1 }},
                    @endif
                    @if(!empty($business->city))
                        {{ $business->city }},
                    @endif
                    @if(!empty($business->state))
                        {{ $business->state }}
                    @endif
                </div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Phone {{ $business->mobile }}
                    @endif
                    @if(!empty($business->alternate_number))
                        , {{ $business->alternate_number }}
                    @endif
                    @if(!empty($business->email))
                        Email {{ $business->email }}
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Date wise Debit Voucher</div>
        
        <!-- Date Range -->
        <div class="report-date">
            {{ \Carbon\Carbon::parse($start_date)->format('d/m/Y') }} To {{ \Carbon\Carbon::parse($end_date)->format('d/m/Y') }}
        </div>
        
        <!-- Warning if Account module not enabled -->
        @if(empty($account_module_enabled))
            <div class="no-data" style="background-color: #fff3cd; border: 1px solid #ffc107; padding: 15px; margin: 10px 0;">
                <strong>Warning:</strong> This report works only if the Account module is enabled. 
                Please enable the Account module from Business Settings → Modules.
            </div>
        @endif
        
        <!-- Supplier/Customer Payment Section -->
        @if(!empty($account_module_enabled) && count($supplier_customer_payments) > 0)
            <div class="section-spacing">
                <div class="payment-type">Supplier/ Customer Payment</div>
                <div class="payment-method">Cash</div>
                <table>
                    <thead>
                        <tr>
                            <th>SL</th>
                            <th>Date</th>
                            <th>Voucher ID</th>
                            <th>Particulars</th>
                            <th>Narration</th>
                            <th>Ref No.</th>
                            <th>Prepared By</th>
                            <th>Cheque No</th>
                            <th>Chq. Date</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($supplier_customer_payments as $index => $voucher)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $util->format_date($voucher->operation_date, false) }}</td>
                                <td>{{ $voucher->voucher_id }}</td>
                                <td>{{ $voucher->particulars }}</td>
                                <td>{{ $voucher->narration ?? '' }}</td>
                                <td>{{ $voucher->ref_no ?? '' }}</td>
                                <td>{{ $voucher->prepared_by }}</td>
                                <td>{{ $voucher->cheque_number ?? '' }}</td>
                                <td>{{ $voucher->cheque_date ? $util->format_date($voucher->cheque_date, false) : '' }}</td>
                                <td>{{ $util->num_f($voucher->amount, true, null) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="9" style="text-align: right; font-weight: 700; padding: 4px 3px;">Sub Total:</td>
                            <td style="text-align: right; font-weight: 700; padding: 4px 3px;">{{ $util->num_f($total_supplier_customer_amount, true, null) }}</td>
                        </tr>
                        <tr>
                            <td colspan="9" style="text-align: right; font-weight: 700; padding: 4px 3px;">Sub Total:</td>
                            <td style="text-align: right; font-weight: 700; padding: 4px 3px;">{{ $util->num_f($total_supplier_customer_amount, true, null) }}</td>
                        </tr>
                        <tr>
                            <td colspan="9" style="text-align: right; font-weight: 700; padding: 4px 3px; color: #0066cc;">Sub Total:</td>
                            <td style="text-align: right; font-weight: 700; padding: 4px 3px; color: #0066cc;">{{ $util->num_f($total_supplier_customer_amount, true, null) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endif
        
        <!-- General A/C Payment Section -->
        @if(!empty($account_module_enabled) && count($general_ac_payments) > 0)
            <div class="section-spacing">
                <div class="payment-type">General A/C Payment</div>
                <div class="payment-method">Cash</div>
                <table>
                    <thead>
                        <tr>
                            <th>SL</th>
                            <th>Date</th>
                            <th>Voucher ID</th>
                            <th>Particulars</th>
                            <th>Narration</th>
                            <th>Ref No.</th>
                            <th>Prepared By</th>
                            <th>Cheque No</th>
                            <th>Chq. Date</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $general_sl = count($supplier_customer_payments);
                        @endphp
                        @foreach($general_ac_payments as $index => $voucher)
                            <tr>
                                <td>{{ $general_sl + $index + 1 }}</td>
                                <td>{{ $util->format_date($voucher->operation_date, false) }}</td>
                                <td>{{ $voucher->voucher_id }}</td>
                                <td>{{ $voucher->particulars }}</td>
                                <td>{{ $voucher->narration ?? '' }}</td>
                                <td>{{ $voucher->ref_no ?? '' }}</td>
                                <td>{{ $voucher->prepared_by }}</td>
                                <td>{{ $voucher->cheque_number ?? '' }}</td>
                                <td>{{ $voucher->cheque_date ? $util->format_date($voucher->cheque_date, false) : '' }}</td>
                                <td>{{ $util->num_f($voucher->amount, true, null) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="9" style="text-align: right; font-weight: 700; padding: 4px 3px;">Sub Total:</td>
                            <td style="text-align: right; font-weight: 700; padding: 4px 3px;">{{ $util->num_f($total_general_ac_amount, true, null) }}</td>
                        </tr>
                        <tr>
                            <td colspan="9" style="text-align: right; font-weight: 700; padding: 4px 3px;">Sub Total:</td>
                            <td style="text-align: right; font-weight: 700; padding: 4px 3px;">{{ $util->num_f($total_general_ac_amount, true, null) }}</td>
                        </tr>
                        <tr>
                            <td colspan="9" style="text-align: right; font-weight: 700; padding: 4px 3px; color: #0066cc;">Sub Total:</td>
                            <td style="text-align: right; font-weight: 700; padding: 4px 3px; color: #0066cc;">{{ $util->num_f($total_general_ac_amount, true, null) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endif
        
        <!-- Grand Total -->
        @if(!empty($account_module_enabled) && ($total_amount > 0))
            <table>
                <tfoot>
                    <tr>
                        <td colspan="9" style="text-align: right; font-weight: 700; padding: 4px 3px; border-top: 2px double #000;">Total :</td>
                        <td style="text-align: right; font-weight: 700; padding: 4px 3px; border-top: 2px double #000;">{{ $util->num_f($total_amount, true, null) }}</td>
                    </tr>
                </tfoot>
            </table>
        @endif
        
        @if(empty($account_module_enabled))
            <div class="no-data">
                <strong>Warning:</strong> This report works only if the Account module is enabled. 
                Please enable the Account module from Business Settings → Modules.
            </div>
        @elseif($total_amount == 0)
            <div class="no-data">
                No debit vouchers found for the selected date range.
            </div>
        @endif
    </div>
</body>
</html>

