@extends('layouts.app')
@section('title', __('businessmanagement::lang.due_list_without_treatment'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.due_list_without_treatment') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueListWithoutTreatment']), 'method' => 'get', 'id' => 'due_list_without_treatment_filter_form' ]) !!}
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('date', __('businessmanagement::lang.date') . ':') !!}
                        @php
                            $date_value = '';
                            if (!empty($date)) {
                                $date_value = \Carbon\Carbon::parse($date)->format('d/m/Y');
                            } else {
                                $date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('date_display', $date_value, ['class' => 'form-control date-picker', 'id' => 'due_list_without_treatment_date', 'readonly']); !!}
                        {!! Form::hidden('date', $date ?? date('Y-m-d'), ['id' => 'hidden_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('supplier_filter', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_filter', [
                            'all' => __('businessmanagement::lang.all_suppliers'),
                            'single' => __('businessmanagement::lang.single_supplier')
                        ], $supplier_filter ?? 'all', ['class' => 'form-control', 'id' => 'supplier_filter']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="supplier_select_wrapper" style="display: {{ ($supplier_filter ?? 'all') == 'single' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('supplier_id', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, $supplier_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_supplier'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', [
                            'all' => __('businessmanagement::lang.all_customers'),
                            'single' => __('businessmanagement::lang.single_customer')
                        ], $customer_filter ?? 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="customer_select_wrapper" style="display: {{ ($customer_filter ?? 'all') == 'single' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueListWithoutTreatment']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDueListWithoutTreatment'], ['date' => !empty($date) ? \Carbon\Carbon::parse($date)->format('Y-m-d') : date('Y-m-d'), 'supplier_filter' => $supplier_filter ?? 'all', 'supplier_id' => $supplier_id ?? '', 'customer_filter' => $customer_filter ?? 'all', 'customer_id' => $customer_id ?? '', 'location_id' => $location_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($customer_due_data) > 0 || count($supplier_due_data) > 0)
                        <!-- Receivable Section (Customers) -->
                        @if(count($customer_due_data) > 0)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; color: #333;">Receivable</h4>
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th style="width: 50px;">SL</th>
                                        <th>Customer Name</th>
                                        <th>Address</th>
                                        <th>Mobile</th>
                                        <th style="text-align: right;">Due</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $serial = 1;
                                    @endphp
                                    @foreach($customer_due_data as $item)
                                        <tr>
                                            <td>{{ $serial++ }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->address }}</td>
                                            <td>{{ $item->mobile }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->due_amount, true, null) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <table class="table table-bordered" style="font-size: 14px; margin-top: 10px;">
                                <tbody>
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="4" style="text-align: right;"><strong>Group Wise Sub Total:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($customer_total, true, null) }}</strong></td>
                                    </tr>
                                    <tr style="background-color: #d4edda; font-weight: bold;">
                                        <td colspan="4" style="text-align: right;"><strong>Category Wise SubTotal:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($customer_total, true, null) }}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endif

                        <!-- Payable Section (Suppliers) -->
                        @if(count($supplier_due_data) > 0)
                            <h4 style="margin-top: 30px; margin-bottom: 15px; color: #333;">Payable</h4>
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th style="width: 50px;">ID</th>
                                        <th>Company/Trader Name</th>
                                        <th>Address</th>
                                        <th>Phone Number</th>
                                        <th style="text-align: right;">Due Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($supplier_due_data as $item)
                                        <tr>
                                            <td>{{ $item->id }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->address }}</td>
                                            <td>{{ $item->mobile }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->due_amount, true, null) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <table class="table table-bordered" style="font-size: 14px; margin-top: 10px;">
                                <tbody>
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="4" style="text-align: right;"><strong>Group Wise Sub Total:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($supplier_total, true, null) }}</strong></td>
                                    </tr>
                                    <tr style="background-color: #fff3cd; font-weight: bold;">
                                        <td colspan="4" style="text-align: right;"><strong>Category Wise SubTotal:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($supplier_total, true, null) }}</strong></td>
                                    </tr>
                                    <tr style="background-color: #f8d7da; font-weight: bold;">
                                        <td colspan="4" style="text-align: right;"><strong>Payable Sub Total:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($supplier_total, true, null) }}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endif

                        <!-- Grand Total -->
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <tbody>
                                <tr style="background-color: #e9ecef; font-weight: bold; border-top: 2px double #000;">
                                    <td colspan="4" style="text-align: right;"><strong>Grand Total:</strong></td>
                                    <td style="text-align: right; border-top: 2px double #000;"><strong>{{ $util->num_f($grand_total, true, null) }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No due amounts found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('#due_list_without_treatment_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#due_list_without_treatment_date').on('changeDate', function(e) {
            var selected_date = e.format('yyyy-mm-dd');
            $('#hidden_date').val(selected_date);
        });

        // Supplier filter toggle
        $('#supplier_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#supplier_select_wrapper').show();
            } else {
                $('#supplier_select_wrapper').hide();
                $('#supplier_id').val(null).trigger('change');
            }
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date field is populated before form submission
        $('#due_list_without_treatment_filter_form').on('submit', function() {
            var date_val = $('#due_list_without_treatment_date').val();
            if (date_val) {
                var date_parts = date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

