@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_receive'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_receive') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceive']), 'method' => 'get', 'id' => 'date_wise_receive_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'date_wise_receive_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'date_wise_receive_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceive']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(count($all_receipts) > 0)
                                <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseReceive'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'location_id' => $location_id ?? '']) }}" 
                                   target="_blank" 
                                   class="btn btn-success">
                                    <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    @if(count($all_receipts) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr style="background-color: #f5f5f5; font-weight: bold;">
                                        <th>{{ __('businessmanagement::lang.sl') }}</th>
                                        <th>{{ __('businessmanagement::lang.date') }}</th>
                                        <th>{{ __('businessmanagement::lang.receive_id') }}</th>
                                        <th>{{ __('businessmanagement::lang.received_from') }}</th>
                                        <th>{{ __('businessmanagement::lang.narration') }}</th>
                                        <th>{{ __('businessmanagement::lang.ref_no') }}</th>
                                        <th>{{ __('businessmanagement::lang.prepared_by') }}</th>
                                        <th>{{ __('businessmanagement::lang.cheque_no') }}</th>
                                        <th>{{ __('businessmanagement::lang.chq_date') }}</th>
                                        <th style="text-align: right;">{{ __('businessmanagement::lang.amount') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $sl = 1;
                                    @endphp
                                    @foreach($all_receipts as $receipt)
                                        <tr>
                                            <td>{{ $sl++ }}</td>
                                            <td>{{ !empty($receipt->date) ? \Carbon\Carbon::parse($receipt->date)->format('d/m/Y') : '' }}</td>
                                            <td>{{ $receipt->receive_id ?? '' }}</td>
                                            <td>{{ $receipt->received_from ?? '' }}</td>
                                            <td>{{ $receipt->narration ?? '' }}</td>
                                            <td>{{ $receipt->ref_no ?? '' }}</td>
                                            <td>{{ $receipt->prepared_by ?? '' }}</td>
                                            <td>{{ $receipt->cheque_no ?? '' }}</td>
                                            <td>{{ !empty($receipt->cheque_date) ? \Carbon\Carbon::parse($receipt->cheque_date)->format('d/m/Y') : '' }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($receipt->amount, true, null) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr style="font-weight: bold; background-color: #f5f5f5;">
                                        <td colspan="9" style="text-align: right;">Total:</td>
                                        <td style="text-align: right;">{{ $util->num_f($total_amount, true, null) }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <p>{{ __('businessmanagement::lang.no_receipts_found') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Date picker initialization
        $('#date_wise_receive_start_date, #date_wise_receive_end_date').datepicker({
            autoclose: true,
            format: 'dd/mm/yyyy',
            todayHighlight: true
        });

        $('#date_wise_receive_start_date').on('changeDate', function(e) {
            var date = e.format('yyyy-mm-dd');
            $('#hidden_start_date').val(date);
        });

        $('#date_wise_receive_end_date').on('changeDate', function(e) {
            var date = e.format('yyyy-mm-dd');
            $('#hidden_end_date').val(date);
        });
    });
</script>
@endsection

