@extends('layouts.app')
@section('title', __('businessmanagement::lang.cash_book'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.cash_book') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashBook']), 'method' => 'get', 'id' => 'cash_book_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'cash_book_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'cash_book_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('account_id', __('account.account') . ':') !!}
                        {!! Form::select('account_id', $accounts, $account_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_account'), 'id' => 'account_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashBook']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if((!empty($account_id) && !empty($account)) || (!empty($show_all_accounts) && $show_all_accounts))
                                <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCashBook'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'account_id' => $account_id ?? 'all', 'location_id' => $location_id ?? '']) }}" 
                                   target="_blank" 
                                   class="btn btn-success">
                                    <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @if(empty($account_module_enabled))
                <div class="alert alert-warning" style="margin-bottom: 20px;">
                    <i class="fa fa-exclamation-triangle"></i> 
                    <strong>Warning:</strong> This report works only if the Account module is enabled. 
                    Please enable the Account module from <a href="{{ url('/business/settings') }}" target="_blank">Business Settings</a> → Modules.
                </div>
            @endif
            @component('components.widget', ['class' => 'box-primary'])
                @if(((!empty($account_id) && !empty($account)) || (!empty($show_all_accounts) && $show_all_accounts)) && !empty($account_module_enabled))
                    <div class="table-responsive" style="overflow-x: auto;">
                        @if(count($ledger_data) > 0)
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th style="text-align: left;">Date</th>
                                        <th style="text-align: left;">Type</th>
                                        <th style="text-align: left;">Transaction Mode</th>
                                        <th style="text-align: left;">A/C Name</th>
                                        <th style="text-align: left;">Narration</th>
                                        <th style="text-align: left;">Ref No.</th>
                                        <th style="text-align: left;">Voucher No</th>
                                        <th style="text-align: right;">Debit</th>
                                        <th style="text-align: right;">Credit</th>
                                        <th style="text-align: right;">Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($ledger_data as $item)
                                        <tr>
                                            <td>{{ $util->format_date($item->date, false) }}</td>
                                            <td>{{ $item->type }}</td>
                                            <td>{{ $item->transaction_mode }}</td>
                                            <td>{{ $item->ac_name }}</td>
                                            <td>{{ $item->narration }}</td>
                                            <td>{{ $item->ref_no }}</td>
                                            <td>{{ $item->voucher_no }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->credit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->balance, true, null) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="7" style="text-align: right;"><strong>Grand Total :</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_debit ?? 0, true, null) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_credit ?? 0, true, null) }}</strong></td>
                                        <td style="text-align: right;"></td>
                                    </tr>
                                    <tr style="background-color: #e9ecef; font-weight: bold;">
                                        <td colspan="9" style="text-align: right;"><strong>Closing Balance:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($closing_balance ?? 0, true, null) }}</strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                        @else
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No transactions found for the selected account and date range.
                            </div>
                        @endif
                    </div>
                @elseif(empty($account_module_enabled))
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i> 
                        <strong>Account Module Not Enabled:</strong> This report works only if the Account module is enabled. 
                        Please enable the Account module from <a href="{{ url('/business/settings') }}" target="_blank">Business Settings</a> → Modules.
                    </div>
                @else
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i> Please select an account to view the cash book.
                    </div>
                @endif
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#cash_book_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#cash_book_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#cash_book_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#cash_book_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#cash_book_filter_form').on('submit', function() {
            var start_date_val = $('#cash_book_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#cash_book_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

