<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Module Installation Routes
|--------------------------------------------------------------------------
*/
Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/accounting-reports/install', [\Modules\AccountingReports\Http\Controllers\InstallController::class, 'index'])->name('accounting-reports.install');
    Route::get('/accounting-reports/install/update', [\Modules\AccountingReports\Http\Controllers\InstallController::class, 'update'])->name('accounting-reports.install.update');
    Route::get('/accounting-reports/install/uninstall', [\Modules\AccountingReports\Http\Controllers\InstallController::class, 'uninstall'])->name('accounting-reports.install.uninstall');
});

/*
|--------------------------------------------------------------------------
| Main Accounting Reports Routes
|--------------------------------------------------------------------------
*/
Route::prefix('accounting-reports')->middleware(['auth', 'web', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu'])->group(function() {
    
    // Main dashboard/index
    Route::get('/', 'AccountingReportsController@index')->name('accounting-reports.index');
    
    // Trial Balance
    Route::get('/trial-balance', 'TrialBalanceController@index')->name('accounting-reports.trial-balance.index');
    Route::get('/trial-balance/get-data', 'TrialBalanceController@getData')->name('accounting-reports.trial-balance.get-data');
    Route::get('/trial-balance/export', 'TrialBalanceController@export')->name('accounting-reports.trial-balance.export');
    
    // Balance Sheet
    Route::get('/balance-sheet', 'BalanceSheetController@index')->name('accounting-reports.balance-sheet.index');
    Route::get('/balance-sheet/get-data', 'BalanceSheetController@getData')->name('accounting-reports.balance-sheet.get-data');
    Route::get('/balance-sheet/export', 'BalanceSheetController@export')->name('accounting-reports.balance-sheet.export');
    
    // Profit & Loss
    Route::get('/profit-loss', 'ProfitLossController@index')->name('accounting-reports.profit-loss.index');
    Route::get('/profit-loss/get-data', 'ProfitLossController@getData')->name('accounting-reports.profit-loss.get-data');
    Route::get('/profit-loss/export', 'ProfitLossController@export')->name('accounting-reports.profit-loss.export');
    
    // Cash Flow
    Route::get('/cash-flow', 'CashFlowController@index')->name('accounting-reports.cash-flow.index');
    Route::get('/cash-flow/get-data', 'CashFlowController@getData')->name('accounting-reports.cash-flow.get-data');
    Route::get('/cash-flow/export', 'CashFlowController@export')->name('accounting-reports.cash-flow.export');
    
    // Funds Flow
    Route::get('/funds-flow', 'FundsFlowController@index')->name('accounting-reports.funds-flow.index');
    Route::get('/funds-flow/get-data', 'FundsFlowController@getData')->name('accounting-reports.funds-flow.get-data');
    Route::get('/funds-flow/export', 'FundsFlowController@export')->name('accounting-reports.funds-flow.export');
    
    // Receivables
    Route::get('/receivables', 'ReceivablesController@index')->name('accounting-reports.receivables.index');
    Route::get('/receivables/get-data', 'ReceivablesController@getData')->name('accounting-reports.receivables.get-data');
    Route::get('/receivables/aging', 'ReceivablesController@aging')->name('accounting-reports.receivables.aging');
    Route::get('/receivables/statement/{contact_id}', 'ReceivablesController@statement')->name('accounting-reports.receivables.statement');
    Route::get('/receivables/export', 'ReceivablesController@export')->name('accounting-reports.receivables.export');
    
    // Payables
    Route::get('/payables', 'PayablesController@index')->name('accounting-reports.payables.index');
    Route::get('/payables/get-data', 'PayablesController@getData')->name('accounting-reports.payables.get-data');
    Route::get('/payables/aging', 'PayablesController@aging')->name('accounting-reports.payables.aging');
    Route::get('/payables/statement/{contact_id}', 'PayablesController@statement')->name('accounting-reports.payables.statement');
    Route::get('/payables/export', 'PayablesController@export')->name('accounting-reports.payables.export');
    
    // Day Book
    Route::get('/day-book', 'DayBookController@index')->name('accounting-reports.day-book.index');
    Route::get('/day-book/get-data', 'DayBookController@getData')->name('accounting-reports.day-book.get-data');
    Route::get('/day-book/export/pdf', 'DayBookController@exportPdf')->name('accounting-reports.day-book.export-pdf');
    Route::get('/day-book/export/csv', 'DayBookController@exportCsv')->name('accounting-reports.day-book.export-csv');
    Route::get('/day-book/print', 'DayBookController@print')->name('accounting-reports.day-book.print');
    
    // Ratio Analysis
    Route::get('/ratio-analysis', 'RatioAnalysisController@index')->name('accounting-reports.ratio-analysis.index');
    Route::get('/ratio-analysis/get-data', 'RatioAnalysisController@getData')->name('accounting-reports.ratio-analysis.get-data');
    Route::get('/ratio-analysis/export', 'RatioAnalysisController@export')->name('accounting-reports.ratio-analysis.export');
    
    // Cash Book
    Route::get('/cash-book', 'CashBookController@index')->name('accounting-reports.cash-book.index');
    Route::get('/cash-book/get-data', 'CashBookController@getData')->name('accounting-reports.cash-book.get-data');
    Route::get('/cash-book/export', 'CashBookController@export')->name('accounting-reports.cash-book.export');
    
    // Bank Book
    Route::get('/bank-book', 'BankBookController@index')->name('accounting-reports.bank-book.index');
    Route::get('/bank-book/get-data', 'BankBookController@getData')->name('accounting-reports.bank-book.get-data');
    Route::get('/bank-book/reconciliation/{account_id}', 'BankBookController@reconciliation')->name('accounting-reports.bank-book.reconciliation');
    Route::get('/bank-book/reconciliation/{account_id}/get-data', 'BankBookController@getReconciliationData')->name('accounting-reports.bank-book.reconciliation.get-data');
    Route::post('/bank-book/reconciliation/mark', 'BankBookController@markReconciled')->name('accounting-reports.bank-book.reconciliation.mark');
    Route::get('/bank-book/export', 'BankBookController@export')->name('accounting-reports.bank-book.export');
    
    // Cheque Books (Physical Cheque Books)
    Route::get('/cheque-books', 'ChequeBookController@index')->name('accounting-reports.cheque-books.index');
    Route::get('/cheque-books/get-data', 'ChequeBookController@getData')->name('accounting-reports.cheque-books.get-data');
    Route::get('/cheque-books/create', 'ChequeBookController@create')->name('accounting-reports.cheque-books.create');
    Route::post('/cheque-books', 'ChequeBookController@store')->name('accounting-reports.cheque-books.store');
    Route::get('/cheque-books/{id}', 'ChequeBookController@show')->name('accounting-reports.cheque-books.show');
    Route::get('/cheque-books/{id}/edit', 'ChequeBookController@edit')->name('accounting-reports.cheque-books.edit');
    Route::put('/cheque-books/{id}', 'ChequeBookController@update')->name('accounting-reports.cheque-books.update');
    Route::delete('/cheque-books/{id}', 'ChequeBookController@destroy')->name('accounting-reports.cheque-books.destroy');
    Route::post('/cheque-books/{id}/generate-entries', 'ChequeBookController@generateEntries')->name('accounting-reports.cheque-books.generate-entries');
    
    // Cheque Book Entries (Individual Cheques)
    Route::get('/cheque-book', 'ChequeBookEntryController@index')->name('accounting-reports.cheque-book.index');
    Route::get('/cheque-book/get-data', 'ChequeBookEntryController@getData')->name('accounting-reports.cheque-book.get-data');
    Route::get('/cheque-book/create', 'ChequeBookEntryController@create')->name('accounting-reports.cheque-book.create');
    Route::post('/cheque-book', 'ChequeBookEntryController@store')->name('accounting-reports.cheque-book.store');
    Route::get('/cheque-book/{id}/edit', 'ChequeBookEntryController@edit')->name('accounting-reports.cheque-book.edit');
    Route::put('/cheque-book/{id}', 'ChequeBookEntryController@update')->name('accounting-reports.cheque-book.update');
    Route::delete('/cheque-book/{id}', 'ChequeBookEntryController@destroy')->name('accounting-reports.cheque-book.destroy');
    
    // Statistics/Dashboard
    Route::get('/statistics', 'StatisticsController@index')->name('accounting-reports.statistics.index');
    Route::get('/statistics/get-data', 'StatisticsController@getData')->name('accounting-reports.statistics.get-data');
    
    // Batch Print Multi-Account Reports
    Route::get('/batch-print', 'BatchPrintController@index')->name('accounting-reports.batch-print.index');
    Route::post('/batch-print/process', 'BatchPrintController@process')->name('accounting-reports.batch-print.process');
    
    // Integrity & Rebuild Tools
    Route::get('/integrity', 'IntegrityController@index')->name('accounting-reports.integrity.index');
    Route::post('/integrity/validate', 'IntegrityController@runValidation')->name('accounting-reports.integrity.validate');
    Route::post('/integrity/rebuild', 'IntegrityController@rebuild')->name('accounting-reports.integrity.rebuild');
    Route::get('/integrity/reconcile-cogs', 'IntegrityController@reconcileCogs')->name('accounting-reports.integrity.reconcile-cogs');
    
    // Voucher drill-down
    Route::get('/voucher/{voucher_id}', 'AccountingReportsController@viewVoucher')->name('accounting-reports.voucher.view');
    Route::get('/voucher/{voucher_id}/source', 'AccountingReportsController@viewSourceDocument')->name('accounting-reports.voucher.source');
    
    // Direct Expenses Management
    Route::get('/direct-expenses', 'DirectExpenseController@index')->name('accounting-reports.direct-expenses.index');
    Route::get('/direct-expenses/get-data', 'DirectExpenseController@getData')->name('accounting-reports.direct-expenses.get-data');
    Route::get('/direct-expenses/create', 'DirectExpenseController@create')->name('accounting-reports.direct-expenses.create');
    Route::post('/direct-expenses', 'DirectExpenseController@store')->name('accounting-reports.direct-expenses.store');
    Route::get('/direct-expenses/{id}', 'DirectExpenseController@show')->name('accounting-reports.direct-expenses.show');
    Route::get('/direct-expenses/{id}/edit', 'DirectExpenseController@edit')->name('accounting-reports.direct-expenses.edit');
    Route::put('/direct-expenses/{id}', 'DirectExpenseController@update')->name('accounting-reports.direct-expenses.update');
    Route::delete('/direct-expenses/{id}', 'DirectExpenseController@destroy')->name('accounting-reports.direct-expenses.destroy');
    
    // Direct Expense Names Management
    Route::get('/direct-expense-names', 'DirectExpenseNameController@index')->name('accounting-reports.direct-expense-names.index');
    Route::get('/direct-expense-names/get-data', 'DirectExpenseNameController@getData')->name('accounting-reports.direct-expense-names.get-data');
    Route::get('/direct-expense-names/create', 'DirectExpenseNameController@create')->name('accounting-reports.direct-expense-names.create');
    Route::post('/direct-expense-names', 'DirectExpenseNameController@store')->name('accounting-reports.direct-expense-names.store');
    Route::get('/direct-expense-names/{id}', 'DirectExpenseNameController@show')->name('accounting-reports.direct-expense-names.show');
    Route::get('/direct-expense-names/{id}/edit', 'DirectExpenseNameController@edit')->name('accounting-reports.direct-expense-names.edit');
    Route::put('/direct-expense-names/{id}', 'DirectExpenseNameController@update')->name('accounting-reports.direct-expense-names.update');
    Route::delete('/direct-expense-names/{id}', 'DirectExpenseNameController@destroy')->name('accounting-reports.direct-expense-names.destroy');
    
    // Direct Income Names Management
    Route::get('/direct-income-names', 'DirectIncomeNameController@index')->name('accounting-reports.direct-income-names.index');
    Route::get('/direct-income-names/get-data', 'DirectIncomeNameController@getData')->name('accounting-reports.direct-income-names.get-data');
    Route::get('/direct-income-names/create', 'DirectIncomeNameController@create')->name('accounting-reports.direct-income-names.create');
    Route::post('/direct-income-names', 'DirectIncomeNameController@store')->name('accounting-reports.direct-income-names.store');
    Route::get('/direct-income-names/{id}', 'DirectIncomeNameController@show')->name('accounting-reports.direct-income-names.show');
    Route::get('/direct-income-names/{id}/edit', 'DirectIncomeNameController@edit')->name('accounting-reports.direct-income-names.edit');
    Route::put('/direct-income-names/{id}', 'DirectIncomeNameController@update')->name('accounting-reports.direct-income-names.update');
    Route::delete('/direct-income-names/{id}', 'DirectIncomeNameController@destroy')->name('accounting-reports.direct-income-names.destroy');
    
    // Direct Incomes Management
    Route::get('/direct-incomes', 'DirectIncomeController@index')->name('accounting-reports.direct-incomes.index');
    Route::get('/direct-incomes/get-data', 'DirectIncomeController@getData')->name('accounting-reports.direct-incomes.get-data');
    Route::get('/direct-incomes/create', 'DirectIncomeController@create')->name('accounting-reports.direct-incomes.create');
    Route::post('/direct-incomes', 'DirectIncomeController@store')->name('accounting-reports.direct-incomes.store');
    Route::get('/direct-incomes/{id}', 'DirectIncomeController@show')->name('accounting-reports.direct-incomes.show');
    Route::get('/direct-incomes/{id}/edit', 'DirectIncomeController@edit')->name('accounting-reports.direct-incomes.edit');
    Route::put('/direct-incomes/{id}', 'DirectIncomeController@update')->name('accounting-reports.direct-incomes.update');
    Route::delete('/direct-incomes/{id}', 'DirectIncomeController@destroy')->name('accounting-reports.direct-incomes.destroy');
});


