@extends('layouts.app')

@section('title', __('accounting-reports::lang.module_name'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.module_name')</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('accounting-reports::lang.reports')</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="small-box bg-aqua">
                                <div class="inner">
                                    <h3>Trial Balance</h3>
                                    <p>Periodic Trial Balance Report</p>
                                </div>
                                <a href="{{ route('accounting-reports.trial-balance.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-green">
                                <div class="inner">
                                    <h3>Balance Sheet</h3>
                                    <p>Assets, Liabilities & Equity</p>
                                </div>
                                <a href="{{ route('accounting-reports.balance-sheet.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-yellow">
                                <div class="inner">
                                    <h3>Profit & Loss</h3>
                                    <p>Income Statement</p>
                                </div>
                                <a href="{{ route('accounting-reports.profit-loss.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-red">
                                <div class="inner">
                                    <h3>Cash Flow</h3>
                                    <p>Cash Flow Statement</p>
                                </div>
                                <a href="{{ route('accounting-reports.cash-flow.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="small-box bg-purple">
                                <div class="inner">
                                    <h3>Receivables</h3>
                                    <p>AR Aging & Statements</p>
                                </div>
                                <a href="{{ route('accounting-reports.receivables.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-maroon">
                                <div class="inner">
                                    <h3>Payables</h3>
                                    <p>AP Aging & Statements</p>
                                </div>
                                <a href="{{ route('accounting-reports.payables.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-teal">
                                <div class="inner">
                                    <h3>Day Book</h3>
                                    <p>Chronological Vouchers</p>
                                </div>
                                <a href="{{ route('accounting-reports.day-book.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-olive">
                                <div class="inner">
                                    <h3>Ratio Analysis</h3>
                                    <p>Financial Ratios</p>
                                </div>
                                <a href="{{ route('accounting-reports.ratio-analysis.index') }}" class="small-box-footer">
                                    View Report <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection


