<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.direct_expense_details')</h4>
        </div>
        <div class="modal-body">
            <table class="table table-bordered">
                <tr>
                    <th width="30%">@lang('accounting-reports::lang.expense_name')</th>
                    <td>{{ $direct_expense->name }}</td>
                </tr>
                <tr>
                    <th>@lang('accounting-reports::lang.description')</th>
                    <td>{{ $direct_expense->description ?? '-' }}</td>
                </tr>
                <tr>
                    <th>@lang('accounting-reports::lang.amount')</th>
                    <td><span class="display_currency" data-currency_symbol="true">{{ $direct_expense->amount }}</span></td>
                </tr>
                <tr>
                    <th>@lang('accounting-reports::lang.expense_date')</th>
                    <td>{{ @format_date($direct_expense->expense_date) }}</td>
                </tr>
                <tr>
                    <th>@lang('purchase.business_location')</th>
                    <td>{{ $direct_expense->location ? $direct_expense->location->name : __('lang_v1.all') }}</td>
                </tr>
                <tr>
                    <th>@lang('account.account')</th>
                    <td>{{ $direct_expense->account ? $direct_expense->account->name : '-' }}</td>
                </tr>
                <tr>
                    <th>@lang('accounting-reports::lang.reference_no')</th>
                    <td>{{ $direct_expense->reference_no ?? '-' }}</td>
                </tr>
                @if($direct_expense->document)
                <tr>
                    <th>@lang('purchase.attach_document')</th>
                    <td>
                        <a href="{{ asset('uploads/documents/' . $direct_expense->document) }}" target="_blank">
                            <i class="fa fa-file"></i> @lang('lang_v1.view_uploaded_document')
                        </a>
                    </td>
                </tr>
                @endif
                <tr>
                    <th>@lang('messages.created_by')</th>
                    <td>{{ $direct_expense->creator ? $direct_expense->creator->user_full_name : '-' }}</td>
                </tr>
                <tr>
                    <th>@lang('messages.created_at')</th>
                    <td>{{ @format_datetime($direct_expense->created_at) }}</td>
                </tr>
            </table>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>





