<div class="modal-dialog">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\DirectExpenseController::class, 'update'], [$direct_expense->id]), 'method' => 'PUT', 'id' => 'direct_expense_form', 'files' => true]) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.edit_direct_expense')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('name', __('accounting-reports::lang.expense_name') . ':*') !!}
                        {!! Form::text('name', $direct_expense->name, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.expense_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('description', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('description', $direct_expense->description, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', __('accounting-reports::lang.amount') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('amount', @num_format($direct_expense->amount), ['class' => 'form-control input_number', 'id' => 'amount', 'required']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('expense_date', __('accounting-reports::lang.expense_date') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('expense_date', @format_date($direct_expense->expense_date), ['class' => 'form-control date-picker', 'required', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $direct_expense->location_id, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_id', __('account.account') . ':') !!}
                        {!! Form::select('account_id', $accounts, $direct_expense->account_id, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('reference_no', __('accounting-reports::lang.reference_no') . ':') !!}
                        {!! Form::text('reference_no', $direct_expense->reference_no, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reference_no')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('document', __('purchase.attach_document') . ':') !!}
                        {!! Form::file('document', ['class' => 'form-control', 'accept' => 'image/*,.pdf,.doc,.docx,.xls,.xlsx']) !!}
                        @if($direct_expense->document)
                            <p class="help-block">
                                <a href="{{ asset('uploads/documents/' . $direct_expense->document) }}" target="_blank">
                                    <i class="fa fa-file"></i> @lang('lang_v1.view_uploaded_document')
                                </a>
                            </p>
                        @endif
                        <p class="help-block">@lang('lang_v1.max_file_size_10mb')</p>
                    </div>
                </div>
            </div>
            
            <hr>
            <h4>@lang('purchase.add_payment')</h4>
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('payment_amount', __('sale.amount') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('payment_amount', @num_format($direct_expense->payment_amount ?? 0), ['class' => 'form-control input_number payment-amount', 'placeholder' => __('sale.amount')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('paid_on', __('lang_v1.paid_on') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('paid_on', $direct_expense->paid_on ? @format_datetime($direct_expense->paid_on) : @format_datetime('now'), ['class' => 'form-control paid_on', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('payment_method', __('lang_v1.payment_method') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fas fa-money-bill-alt"></i>
                            </span>
                            {!! Form::select('payment_method', $payment_types, $direct_expense->payment_method ?? 'cash', ['class' => 'form-control select2', 'style' => 'width:100%']) !!}
                        </div>
                    </div>
                </div>
                @if(!empty($payment_accounts))
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payment_account_id', __('lang_v1.payment_account') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fas fa-money-bill-alt"></i>
                            </span>
                            {!! Form::select('payment_account_id', $payment_accounts, $direct_expense->payment_account_id, ['class' => 'form-control select2 account-dropdown', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%', 'id' => 'payment_account_id']) !!}
                        </div>
                    </div>
                </div>
                @endif
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payment_note', __('sale.payment_note') . ':') !!}
                        {!! Form::textarea('payment_note', $direct_expense->payment_note, ['class' => 'form-control', 'rows' => '2', 'placeholder' => __('sale.payment_note')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <div class="pull-right">
                            <strong>@lang('purchase.payment_due'):</strong>
                            <span id="payment_due">{{@num_format(0)}}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

