@extends('layouts.app')

@section('title', __('accounting-reports::lang.cheque_books'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.cheque_books')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <a href="{{ route('accounting-reports.cheque-books.create') }}" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_cheque_book')
                    </a>
                    <a href="{{ route('accounting-reports.cheque-book.index') }}" class="btn btn-info">
                        <i class="fa fa-list"></i> @lang('accounting-reports::lang.cheque_book') @lang('accounting-reports::lang.cheque_entry')
                    </a>
                </div>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_account_id', __('accounting-reports::lang.bank_account') . ':') !!}
                    {!! Form::select('filter_account_id', $accounts, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all'), 'id' => 'filter_account_id']) !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_status', __('accounting-reports::lang.status') . ':') !!}
                    {!! Form::select('filter_status', ['active' => __('accounting-reports::lang.active'), 'completed' => 'Completed', 'cancelled' => __('accounting-reports::lang.cancelled')], null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all'), 'id' => 'filter_status']) !!}
                </div>
            </div>
        </div>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="cheque_books_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.book_name')</th>
                        <th>@lang('accounting-reports::lang.bank_account')</th>
                        <th>@lang('accounting-reports::lang.cheque_range')</th>
                        <th>@lang('accounting-reports::lang.total_cheques')</th>
                        <th>@lang('accounting-reports::lang.used_cheques')</th>
                        <th>@lang('accounting-reports::lang.remaining_cheques')</th>
                        <th>@lang('accounting-reports::lang.issue_date')</th>
                        <th>@lang('accounting-reports::lang.status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var cheque_books_table = $('#cheque_books_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("accounting-reports.cheque-books.get-data") }}',
                data: function(d) {
                    d.account_id = $('#filter_account_id').val();
                    d.status = $('#filter_status').val();
                }
            },
            columns: [
                { data: 'book_name', name: 'book_name' },
                { data: 'account_name', name: 'account_id' },
                { data: 'cheque_range', name: 'cheque_range' },
                { data: 'total_cheques', name: 'total_cheques' },
                { data: 'used_cheques', name: 'used_cheques' },
                { data: 'remaining_cheques', name: 'remaining_cheques' },
                { data: 'issue_date', name: 'issue_date' },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        $('#filter_account_id, #filter_status').on('change', function() {
            cheque_books_table.ajax.reload();
        });

        $(document).on('click', '.generate-entries', function() {
            var url = $(this).data('href');
            var bookName = $(this).data('book-name');
            
            swal({
                title: LANG.sure,
                text: 'Generate all cheque entries for "' + bookName + '"?',
                icon: "info",
                buttons: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'POST',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                cheque_books_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('click', '.delete_cheque_book', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                cheque_books_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });
    });
</script>
@endsection

