@extends('layouts.app')

@section('title', __('accounting-reports::lang.add_cheque_book'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.add_cheque_book')</h1>
</section>

<section class="content">
    {!! Form::open(['url' => route('accounting-reports.cheque-books.store'), 'method' => 'post', 'id' => 'add_cheque_book_form']) !!}
    <div class="box box-solid">
        <div class="box-header with-border">
            <h3 class="box-title">@lang('accounting-reports::lang.cheque_book_details')</h3>
        </div>
        <div class="box-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_id', __('accounting-reports::lang.bank_account') . ':*') !!}
                        {!! Form::select('account_id', $accounts, null, ['class' => 'form-control select2', 'required', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('book_name', __('accounting-reports::lang.book_name') . ':*') !!}
                        {!! Form::text('book_name', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.book_name')]) !!}
                        <p class="help-block">@lang('accounting-reports::lang.example'): Book 1, Book A, etc.</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('book_number', __('accounting-reports::lang.book_number') . ':') !!}
                        {!! Form::text('book_number', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.book_number')]) !!}
                        <p class="help-block">@lang('accounting-reports::lang.book_number_from_bank')</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('start_cheque_no', __('accounting-reports::lang.start_cheque_no') . ':*') !!}
                        {!! Form::text('start_cheque_no', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.example') . ': 0001', 'id' => 'start_cheque_no']) !!}
                        <p class="help-block">@lang('accounting-reports::lang.starting_cheque_number')</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('end_cheque_no', __('accounting-reports::lang.end_cheque_no') . ':*') !!}
                        {!! Form::text('end_cheque_no', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.example') . ': 0030', 'id' => 'end_cheque_no']) !!}
                        <p class="help-block">@lang('accounting-reports::lang.ending_cheque_number')</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="alert alert-info" id="total_cheques_info" style="display: none;">
                        <strong>@lang('accounting-reports::lang.total_cheques'):</strong> <span id="total_cheques_count">0</span>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('issue_date', __('accounting-reports::lang.issue_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('issue_date', @format_date('now'), ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('expiry_date', __('accounting-reports::lang.expiry_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('expiry_date', null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('notes', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                {!! Form::checkbox('generate_entries', '1', true) !!}
                                @lang('accounting-reports::lang.generate_all_entries')
                                <p class="help-block">@lang('accounting-reports::lang.generate_all_entries_help')</p>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> @lang('messages.save')
            </button>
            <a href="{{ route('accounting-reports.cheque-books.index') }}" class="btn btn-default">
                <i class="fa fa-times"></i> @lang('messages.cancel')
            </a>
        </div>
    </div>
    {!! Form::close() !!}
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2({width: '100%'});
        $('.date-picker').datepicker(datepicker_params);
        
        // Calculate total cheques
        function calculateTotal() {
            var start = parseInt($('#start_cheque_no').val()) || 0;
            var end = parseInt($('#end_cheque_no').val()) || 0;
            
            if (start > 0 && end > 0 && end >= start) {
                var total = end - start + 1;
                $('#total_cheques_count').text(total);
                $('#total_cheques_info').show();
            } else {
                $('#total_cheques_info').hide();
            }
        }
        
        $('#start_cheque_no, #end_cheque_no').on('keyup change', function() {
            calculateTotal();
        });
        
        // Form validation and submission
        $('#add_cheque_book_form').validate({
            rules: {
                start_cheque_no: {
                    required: true,
                },
                end_cheque_no: {
                    required: true,
                    greaterThan: '#start_cheque_no'
                }
            },
            messages: {
                end_cheque_no: {
                    greaterThan: '@lang("accounting-reports::lang.start_cheque_no_must_be_less_than_end")'
                }
            },
            submitHandler: function(form) {
                $.ajax({
                    method: 'POST',
                    url: $(form).attr('action'),
                    data: $(form).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.msg);
                            window.location.href = response.redirect || '{{ route("accounting-reports.cheque-books.index") }}';
                        } else {
                            toastr.error(response.msg);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, value) {
                                toastr.error(value[0]);
                            });
                        } else {
                            toastr.error('@lang("messages.something_went_wrong")');
                        }
                    }
                });
                return false;
            }
        });
        
        // Add custom validation rule
        $.validator.addMethod("greaterThan", function(value, element, param) {
            var start = parseInt($(param).val());
            var end = parseInt(value);
            return end > start;
        });
    });
</script>
@endsection

