@extends('layouts.app')

@section('title', __('accounting-reports::lang.add_cheque_entry'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.add_cheque_entry')</h1>
</section>

<section class="content">
    {!! Form::open(['url' => route('accounting-reports.cheque-book.store'), 'method' => 'post', 'id' => 'add_cheque_entry_form']) !!}
    <div class="box box-solid">
        <div class="box-header with-border">
            <h3 class="box-title">@lang('accounting-reports::lang.cheque_entry_details')</h3>
        </div>
        <div class="box-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_id', __('accounting-reports::lang.bank_account') . ':*') !!}
                        {!! Form::select('account_id', $accounts, null, ['class' => 'form-control select2', 'required', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('cheque_no', __('accounting-reports::lang.cheque_no') . ':*') !!}
                        {!! Form::text('cheque_no', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.cheque_no')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('cheque_date', __('accounting-reports::lang.cheque_date') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('cheque_date', @format_date('now'), ['class' => 'form-control date-picker', 'required', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', __('accounting-reports::lang.amount') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('amount', null, ['class' => 'form-control input_number', 'required']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('type', __('accounting-reports::lang.cheque_type') . ':*') !!}
                        {!! Form::select('type', ['issued' => __('accounting-reports::lang.issued'), 'received' => __('accounting-reports::lang.received')], 'issued', ['class' => 'form-control select2', 'required', 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('status', __('accounting-reports::lang.cheque_status') . ':*') !!}
                        {!! Form::select('status', ['pending' => __('accounting-reports::lang.pending'), 'cleared' => __('accounting-reports::lang.cleared'), 'bounced' => __('accounting-reports::lang.bounced'), 'cancelled' => __('accounting-reports::lang.cancelled'), 'deposited' => __('accounting-reports::lang.deposited')], 'pending', ['class' => 'form-control select2', 'required', 'style' => 'width:100%', 'id' => 'status']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payee_name', __('accounting-reports::lang.payee_name') . ':') !!}
                        {!! Form::text('payee_name', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.payee_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('reference_no', __('accounting-reports::lang.reference_no') . ':') !!}
                        {!! Form::text('reference_no', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reference_no')]) !!}
                    </div>
                </div>
                <div class="col-sm-6" id="cleared_date_group" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('cleared_date', __('accounting-reports::lang.cleared_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('cleared_date', null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_statement_ref', __('accounting-reports::lang.bank_statement_ref') . ':') !!}
                        {!! Form::text('bank_statement_ref', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.bank_statement_ref')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('narration', __('daybook::lang.narration') . ':') !!}
                        {!! Form::textarea('narration', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('daybook::lang.narration')]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> @lang('messages.save')
            </button>
            <a href="{{ route('accounting-reports.cheque-book.index') }}" class="btn btn-default">
                <i class="fa fa-times"></i> @lang('messages.cancel')
            </a>
        </div>
    </div>
    {!! Form::close() !!}
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2({width: '100%'});
        $('.date-picker').datepicker(datepicker_params);
        
        // Show/hide cleared_date based on status
        $('#status').on('change', function() {
            if ($(this).val() === 'cleared') {
                $('#cleared_date_group').show();
            } else {
                $('#cleared_date_group').hide();
            }
        });
        
        // Form validation and submission
        $('#add_cheque_entry_form').validate({
            submitHandler: function(form) {
                $.ajax({
                    method: 'POST',
                    url: $(form).attr('action'),
                    data: $(form).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.msg);
                            window.location.href = '{{ route("accounting-reports.cheque-book.index") }}';
                        } else {
                            toastr.error(response.msg);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, value) {
                                toastr.error(value[0]);
                            });
                        } else {
                            toastr.error('@lang("messages.something_went_wrong")');
                        }
                    }
                });
            }
        });
    });
</script>
@endsection

