@extends('layouts.app')

@section('title', __('accounting-reports::lang.balance_sheet'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.balance_sheet')</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">Filters</h3>
                </div>
                <div class="box-body">
                    <form id="filter-form">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>@lang('accounting-reports::lang.location')</label>
                                    <select name="location_id" id="location_id" class="form-control select2" style="width:100%">
                                        <option value="">@lang('accounting-reports::lang.all_locations')</option>
                                        @foreach($locations as $locationId => $locationName)
                                            <option value="{{ $locationId }}">{{ $locationName }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-3 col-xs-6">
                                <div class="form-group">
                                    <label for="end_date">@lang('messages.filter_by_date'):</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </span>
                                        <input type="text" id="end_date" value="{{ @format_date('now') }}" class="form-control" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>&nbsp;</label><br>
                                    <button type="button" id="generate-btn" class="btn btn-primary">
                                        <i class="fa fa-refresh"></i> @lang('accounting-reports::lang.view')
                                    </button>
                                    <button type="button" id="export-btn" class="btn btn-success">
                                        <i class="fa fa-download"></i> @lang('accounting-reports::lang.export')
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">Balance Sheet</h3>
                </div>
                <div class="box-body">
                    <div id="loading" style="display:none;">
                        <i class="fa fa-spinner fa-spin"></i> Loading...
                    </div>
                    <div id="balance-sheet-table"></div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script>
$(document).ready(function() {
    // Initialize date picker
    $('#end_date').datepicker({
        autoclose: true,
        format: datepicker_date_format
    });

    // Initialize select2
    $('#location_id').select2();

    // Load on page load
    loadBalanceSheet();

    $('#end_date').change(function() {
        loadBalanceSheet();
    });

    $('#location_id').change(function() {
        loadBalanceSheet();
    });

    $('#generate-btn').click(function() {
        loadBalanceSheet();
    });

    $('#export-btn').click(function() {
        var endDate = $('#end_date').val();
        var locationId = $('#location_id').val() || '';
        window.location.href = '{{ route("accounting-reports.balance-sheet.export") }}?end_date=' + endDate + '&location_id=' + locationId + '&format=pdf';
    });

    function loadBalanceSheet() {
        $('#loading').show();
        $('#balance-sheet-table').html('');
        
        var end_date = $('#end_date').val();
        var location_id = $('#location_id').val() || '';
        
        $.ajax({
            url: '{{ route("accounting-reports.balance-sheet.get-data") }}',
            method: 'GET',
            data: {
                end_date: end_date,
                location_id: location_id
            },
            success: function(response) {
                if (response) {
                    renderBalanceSheet(response);
                } else {
                    $('#balance-sheet-table').html('<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> Invalid response from server.</div>');
                }
                $('#loading').hide();
            },
            error: function(xhr, status, error) {
                $('#loading').hide();
                console.error('Error:', xhr.responseText);
                var errorMsg = 'Error loading balance sheet';
                if (xhr.responseJSON && xhr.responseJSON.error) {
                    errorMsg = xhr.responseJSON.error;
                }
                $('#balance-sheet-table').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ' + errorMsg + '</div>');
            }
        });
    }

    function renderBalanceSheet(data) {
        $('#balance-sheet-table').html('<div class="alert alert-info">Balance Sheet report is being implemented. This will display Assets, Liabilities, and Equity as of the selected date.</div>');
    }
});
</script>
@endsection





