# Accounting Reports Module for UltimatePOS

A comprehensive Tally-style accounting reports module providing complete double-entry bookkeeping, financial reports, and integrity tools for UltimatePOS.

## Features

### 13+ Financial Reports

1. **Trial Balance** - Periodic trial balance with opening, period, and closing balances
2. **Balance Sheet** - Assets, Liabilities, and Equity as of a specific date
3. **Profit & Loss (P&L)** - Income statement with comparative periods
4. **Cash Flow** - Indirect method cash flow statement
5. **Funds Flow** - Working capital change analysis
6. **Receivables** - Aging analysis and customer statements
7. **Payables** - Aging analysis and supplier statements
8. **Day Book** - Chronological listing of all vouchers
9. **Ratio Analysis** - Financial ratios and KPIs
10. **Cash Book** - Cash-in-hand ledger
11. **Bank Book** - Per-bank-account ledger with reconciliation
12. **Statistics/Dashboard** - KPIs and charts
13. **Batch Print** - Print multiple account reports in one go

### Core Features

- **Double-Entry Bookkeeping** - Every transaction ensures Dr = Cr
- **Chart of Accounts** - Hierarchical account structure with standard groups
- **Journal Entries** - Complete audit trail with source tracking
- **FIFO Costing** - Accurate COGS calculation with FIFO method
- **Period Locking** - Prevent edits to closed periods
- **Audit Logging** - Complete trail of all changes
- **Export Options** - PDF, Excel, CSV formats
- **Drill-Down** - Navigate from reports to vouchers to source documents
- **Bank Reconciliation** - Track cleared/uncleared transactions
- **Multi-Currency** - Support for multiple currencies with exchange rates
- **Location Scoping** - Filter reports by business location

## Installation

1. Copy the `AccountingReports` module to `Modules/AccountingReports/`

2. Install via module manager:
   - Go to Settings → Manage Modules
   - Find "Accounting Reports"
   - Click "Install"

3. Run migrations and seeders:
   ```bash
   php artisan migrate --path=Modules/AccountingReports/Database/Migrations
   php artisan db:seed --class=Modules\\AccountingReports\\Database\\Seeders\\AccountingReportsDatabaseSeeder
   ```

4. Set up permissions:
   - Go to Settings → Roles & Permissions
   - Assign appropriate permissions to roles

## Configuration

Edit `config/accounting_reports.php` or set environment variables:

```env
ACCOUNTING_COSTING_METHOD=fifo          # fifo or average
ACCOUNTING_CURRENCY_SYMBOL=Rs          # Currency symbol
ACCOUNTING_ENABLE_PERIOD_LOCK=false    # Enable period locking
ACCOUNTING_CHUNK_SIZE=1000             # For batch processing
ACCOUNTING_MATERIALIZED_LEDGERS=true   # Use materialized views
```

## Posting Rules

The module automatically posts journal entries for:

- **Sales**: Dr AR/Cash, Cr Revenue, Cr Tax, Dr COGS, Cr Inventory
- **Purchases**: Dr Inventory, Dr Tax, Cr AP/Cash
- **Receipts**: Dr Cash/Bank, Cr AR
- **Payments**: Dr AP, Cr Cash/Bank
- **Expenses**: Dr Expense, Cr Cash/Bank
- **Stock Adjustments**: Dr Inventory Loss, Cr Inventory

All postings enforce double-entry (Dr = Cr).

## Usage

### Accessing Reports

Navigate to **Accounting → Reports** in the sidebar menu.

### Generating Reports

1. Select report type from the menu
2. Choose date range, location, and other filters
3. Click "Generate" or "Get Data"
4. Review the report
5. Export as PDF, Excel, or CSV

### Drill-Down

- Click on any account name to view ledger
- Click on voucher number to view journal entry details
- Click "Source Document" to view original invoice/bill

### Batch Printing

1. Go to **Accounting → Reports → Batch Print**
2. Select multiple accounts/ledgers
3. Click "Print All"
4. Receive merged PDF with table of contents

## Migration from Existing Data

The module includes tools to migrate existing UltimatePOS transactions:

1. Go to **Accounting → Integrity Tools**
2. Run "Rebuild Ledgers" to backfill journal entries
3. Run "Rebuild FIFO Layers" to recalculate inventory costing
4. Run "Reconcile COGS" to fix any discrepancies

## Integrity & Validation

### Validation Tools

- **JE Balance Check**: Validates all vouchers balance (Dr = Cr)
- **Opening Balance Check**: Ensures no orphan opening balances
- **COGS Reconcile**: Compares calculated vs posted COGS
- **AR/AP Control Reconcile**: Validates control accounts match subledgers

### Rebuild Tools

- **Rebuild Ledgers**: Recompute all journal entries from transactions
- **Rebuild FIFO Layers**: Recreate FIFO layers from purchase history
- **Rebuild Rollups**: Regenerate materialized ledger rollups

## Permissions

Required permissions:

- `accounting.view_all` - View all reports
- `accounting.view_trial_balance` - View trial balance
- `accounting.view_balance_sheet` - View balance sheet
- `accounting.view_pl` - View profit & loss
- `accounting.view_cashflow` - View cash flow
- `accounting.view_ar` - View receivables
- `accounting.view_ap` - View payables
- `accounting.view_daybook` - View day book
- `accounting.view_cashbook` - View cash book
- `accounting.view_bankbook` - View bank book
- `accounting.export_reports` - Export reports
- `accounting.print_multi_account` - Batch print

## API Endpoints

The module provides REST API endpoints:

- `GET /api/accounting-reports/trial-balance`
- `GET /api/accounting-reports/balance-sheet`
- `GET /api/accounting-reports/profit-loss`

## Database Schema

### Key Tables

- `ar_chart_of_accounts` - Chart of accounts
- `ar_journal_entry_headers` - Journal entry vouchers
- `ar_journal_entry_lines` - Journal entry lines
- `ar_fifo_layers` - FIFO inventory layers
- `ar_ledger_rollups` - Materialized ledger balances
- `ar_receivables_payables` - AR/AP subledger
- `ar_bank_reconciliation` - Bank reconciliation
- `ar_period_locks` - Period locking
- `ar_audit_log` - Audit trail

## Performance

- Uses materialized ledger rollups for fast report generation
- Indexed queries on date, account, location
- Chunked processing for large datasets
- Background jobs for heavy recomputes

## Troubleshooting

### Reports showing zero balances

- Ensure transactions have been posted (check journal entries)
- Verify Chart of Accounts is set up correctly
- Run "Rebuild Ledgers" tool

### COGS incorrect

- Run "Rebuild FIFO Layers" to recalculate from purchases
- Verify purchase prices are entered correctly
- Check for stock adjustments that may affect costing

### Journal entry won't post

- Check that Debit = Credit
- Verify all accounts are active
- Check for period locks

## Support

For issues or questions:
1. Check the audit log for errors
2. Review journal entries for the transaction
3. Use integrity tools to identify discrepancies
4. Contact support with specific voucher numbers

## Version History

- **1.0.0** - Initial release with all 13 reports and core features

## License

MIT License - See LICENSE file for details

## Credits

Developed for UltimatePOS - A comprehensive POS solution built on Laravel.


