<?php

namespace Modules\AccountingReports\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;
use Modules\AccountingReports\Database\Seeders\AccountingReportsDatabaseSeeder;
use Spatie\Permission\Models\Permission;

class InstallController extends Controller
{
    /**
     * Install the module
     */
    public function index()
    {
        try {
            // Run migrations
            Artisan::call('migrate', [
                '--path' => 'Modules/AccountingReports/Database/Migrations',
                '--force' => true,
            ]);
            
            // Run seeders
            $seeder = new AccountingReportsDatabaseSeeder();
            $seeder->run();
            
            // Store module version in system table (required for menu display)
            $system = \App\System::where('key', 'accountingreports_version')->first();
            if (empty($system)) {
                \App\System::create([
                    'key' => 'accountingreports_version',
                    'value' => config('accounting-reports.module_version', '1.0.0'),
                ]);
            } else {
                $system->value = config('accounting-reports.module_version', '1.0.0');
                $system->save();
            }
            
            // Create permissions if they don't exist
            $this->createPermissions();
            
            return redirect()->back()->with('success', __('accounting-reports::lang.installation_success'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', __('accounting-reports::lang.installation_error') . ': ' . $e->getMessage());
        }
    }

    /**
     * Update the module
     */
    public function update()
    {
        try {
            Artisan::call('migrate', [
                '--path' => 'Modules/AccountingReports/Database/Migrations',
                '--force' => true,
            ]);
            
            // Update module version
            $system = \App\System::where('key', 'accountingreports_version')->first();
            if ($system) {
                $system->value = config('accounting-reports.module_version', '1.0.0');
                $system->save();
            }
            
            return redirect()->back()->with('success', __('accounting-reports::lang.update_success'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', __('accounting-reports::lang.update_error') . ': ' . $e->getMessage());
        }
    }

    /**
     * Uninstall the module
     */
    public function uninstall()
    {
        try {
            // Optionally drop tables - be careful with this!
            // Artisan::call('migrate:rollback', [
            //     '--path' => 'Modules/AccountingReports/Database/Migrations',
            //     '--force' => true,
            // ]);
            
            return redirect()->back()->with('success', __('accounting-reports::lang.uninstall_success'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', __('accounting-reports::lang.uninstall_error') . ': ' . $e->getMessage());
        }
    }

    /**
     * Create module permissions
     */
    protected function createPermissions()
    {
        $permissions = [
            'accounting.view_all',
            'accounting.view_trial_balance',
            'accounting.view_balance_sheet',
            'accounting.view_pl',
            'accounting.view_cashflow',
            'accounting.view_ar',
            'accounting.view_ap',
            'accounting.view_daybook',
            'accounting.view_cashbook',
            'accounting.view_bankbook',
            'accounting.export_reports',
            'accounting.print_multi_account',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission, 'guard_name' => 'web']
            );
        }
    }
}


