<?php

namespace Modules\AccountingReports\Http\Controllers;

use Illuminate\Routing\Controller;
use App\Utils\ModuleUtil;
use Menu;
use Modules\AccountingReports\Http\Controllers\DirectExpenseController;
use Modules\AccountingReports\Http\Controllers\DirectExpenseNameController;
use Modules\AccountingReports\Http\Controllers\DirectIncomeController;
use Modules\AccountingReports\Http\Controllers\DirectIncomeNameController;

class DataController extends Controller
{
    /**
     * Defines user permissions for the module.
     * @return array
     */
    public function user_permissions()
    {
        return [
            [
                'value' => 'accounting.view_all',
                'label' => __('accounting-reports::lang.permissions.view_all'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_trial_balance',
                'label' => __('accounting-reports::lang.permissions.view_trial_balance'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_balance_sheet',
                'label' => __('accounting-reports::lang.permissions.view_balance_sheet'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_pl',
                'label' => __('accounting-reports::lang.permissions.view_pl'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_cashflow',
                'label' => __('accounting-reports::lang.permissions.view_cashflow'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_ar',
                'label' => __('accounting-reports::lang.permissions.view_ar'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_ap',
                'label' => __('accounting-reports::lang.permissions.view_ap'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_daybook',
                'label' => __('accounting-reports::lang.permissions.view_daybook'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_cashbook',
                'label' => __('accounting-reports::lang.permissions.view_cashbook'),
                'default' => false
            ],
            [
                'value' => 'accounting.view_bankbook',
                'label' => __('accounting-reports::lang.permissions.view_bankbook'),
                'default' => false
            ],
            [
                'value' => 'accounting.export_reports',
                'label' => __('accounting-reports::lang.permissions.export_reports'),
                'default' => false
            ],
            [
                'value' => 'accounting.print_multi_account',
                'label' => __('accounting-reports::lang.permissions.print_multi_account'),
                'default' => false
            ],
        ];
    }

    /**
     * Add menu items to admin sidebar
     */
    public function modifyAdminMenu()
    {
        try {
            // Check if module is installed
            $is_installed = \App\System::getProperty('accountingreports_version');
            
            if (empty($is_installed)) {
                return; // Module not installed, don't show menu
            }

            // Check if user has any accounting permissions
            $hasPermission = auth()->user()->can('accounting.view_all') ||
                            auth()->user()->can('accounting.view_trial_balance') ||
                            auth()->user()->can('accounting.view_balance_sheet') ||
                            auth()->user()->can('accounting.view_pl') ||
                            auth()->user()->can('accounting.view_cashflow') ||
                            auth()->user()->can('accounting.view_ar') ||
                            auth()->user()->can('accounting.view_ap') ||
                            auth()->user()->can('accounting.view_daybook') ||
                            auth()->user()->can('accounting.view_cashbook') ||
                            auth()->user()->can('accounting.view_bankbook');

            if (!$hasPermission) {
                return; // User doesn't have any accounting permissions
            }

            $menu = Menu::instance('admin-sidebar-menu');

            // Accounting Reports dropdown menu
            $menu->dropdown(
                __('accounting-reports::lang.module_name'),
                function ($sub) {
                    // Main Reports Dashboard
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            route('accounting-reports.index'),
                            __('accounting-reports::lang.reports'),
                            ['active' => request()->routeIs('accounting-reports.index')]
                        );
                    }

                    // Trial Balance
                    if (auth()->user()->can('accounting.view_trial_balance')) {
                        $sub->url(
                            route('accounting-reports.trial-balance.index'),
                            __('accounting-reports::lang.trial_balance'),
                            ['active' => request()->routeIs('accounting-reports.trial-balance.*')]
                        );
                    }

                    // Balance Sheet
                    if (auth()->user()->can('accounting.view_balance_sheet')) {
                        $sub->url(
                            route('accounting-reports.balance-sheet.index'),
                            __('accounting-reports::lang.balance_sheet'),
                            ['active' => request()->routeIs('accounting-reports.balance-sheet.*')]
                        );
                    }

                    // Profit & Loss
                    if (auth()->user()->can('accounting.view_pl')) {
                        $sub->url(
                            route('accounting-reports.profit-loss.index'),
                            __('accounting-reports::lang.profit_loss'),
                            ['active' => request()->routeIs('accounting-reports.profit-loss.*')]
                        );
                    }

                    // Cash Flow
                    if (auth()->user()->can('accounting.view_cashflow')) {
                        $sub->url(
                            route('accounting-reports.cash-flow.index'),
                            __('accounting-reports::lang.cash_flow'),
                            ['active' => request()->routeIs('accounting-reports.cash-flow.*')]
                        );
                    }

                    // Direct Expenses Management
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            action([DirectExpenseController::class, 'index']),
                            __('accounting-reports::lang.direct_expenses'),
                            ['active' => request()->routeIs('accounting-reports.direct-expenses.*')]
                        );
                    }
                    
                    // Direct Expense Names Management
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            action([DirectExpenseNameController::class, 'index']),
                            __('accounting-reports::lang.direct_expense_names'),
                            ['active' => request()->routeIs('accounting-reports.direct-expense-names.*')]
                        );
                    }

                    // Direct Incomes Management
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            action([DirectIncomeController::class, 'index']),
                            __('accounting-reports::lang.direct_incomes'),
                            ['active' => request()->routeIs('accounting-reports.direct-incomes.*')]
                        );
                    }
                    
                    // Direct Income Names Management
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            action([DirectIncomeNameController::class, 'index']),
                            __('accounting-reports::lang.direct_income_names'),
                            ['active' => request()->routeIs('accounting-reports.direct-income-names.*')]
                        );
                    }

                    // Separator
                    $sub->divider();

                    // Receivables
                    if (auth()->user()->can('accounting.view_ar')) {
                        $sub->url(
                            route('accounting-reports.receivables.index'),
                            __('accounting-reports::lang.receivables'),
                            ['active' => request()->routeIs('accounting-reports.receivables.*')]
                        );
                    }

                    // Payables
                    if (auth()->user()->can('accounting.view_ap')) {
                        $sub->url(
                            route('accounting-reports.payables.index'),
                            __('accounting-reports::lang.payables'),
                            ['active' => request()->routeIs('accounting-reports.payables.*')]
                        );
                    }

                    // Separator
                    $sub->divider();

                    // Day Book
                    if (auth()->user()->can('accounting.view_daybook')) {
                        $sub->url(
                            route('accounting-reports.day-book.index'),
                            __('accounting-reports::lang.day_book'),
                            ['active' => request()->routeIs('accounting-reports.day-book.*')]
                        );
                    }

                    // Cash Book
                    if (auth()->user()->can('accounting.view_cashbook')) {
                        $sub->url(
                            route('accounting-reports.cash-book.index'),
                            __('accounting-reports::lang.cash_book'),
                            ['active' => request()->routeIs('accounting-reports.cash-book.*')]
                        );
                    }

                    // Bank Book
                    if (auth()->user()->can('accounting.view_bankbook')) {
                        $sub->url(
                            route('accounting-reports.bank-book.index'),
                            __('accounting-reports::lang.bank_book'),
                            ['active' => request()->routeIs('accounting-reports.bank-book.*')]
                        );
                    }

                    // Separator
                    $sub->divider();

                    // Ratio Analysis
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            route('accounting-reports.ratio-analysis.index'),
                            __('accounting-reports::lang.ratio_analysis'),
                            ['active' => request()->routeIs('accounting-reports.ratio-analysis.*')]
                        );
                    }

                    // Statistics/Dashboard
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            route('accounting-reports.statistics.index'),
                            __('accounting-reports::lang.statistics'),
                            ['active' => request()->routeIs('accounting-reports.statistics.*')]
                        );
                    }

                    // Separator
                    $sub->divider();

                    // Batch Print
                    if (auth()->user()->can('accounting.print_multi_account')) {
                        $sub->url(
                            route('accounting-reports.batch-print.index'),
                            __('accounting-reports::lang.batch_print'),
                            ['active' => request()->routeIs('accounting-reports.batch-print.*')]
                        );
                    }

                    // Integrity Tools
                    if (auth()->user()->can('accounting.view_all')) {
                        $sub->url(
                            route('accounting-reports.integrity.index'),
                            __('accounting-reports::lang.integrity_tools'),
                            ['active' => request()->routeIs('accounting-reports.integrity.*')]
                        );
                    }
                },
                ['active' => request()->routeIs('accounting-reports.*')]
            )
            ->order(40); // Order position in sidebar

        } catch (\Exception $e) {
            // Silently ignore errors to avoid breaking the whole sidebar
            \Log::error('AccountingReports menu error: ' . $e->getMessage());
        }
    }
}

