<?php

namespace Modules\AccountingReports\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class BalanceSheetController extends Controller
{
    public function index()
    {
        if (!auth()->user()->can('accounting.view_balance_sheet')) {
            abort(403, 'Unauthorized action.');
        }

        $businessId = auth()->user()->business_id;
        $locations = \App\BusinessLocation::forDropdown($businessId, true);

        return view('accounting-reports::balance-sheet.index', compact('locations'));
    }

    public function getData(Request $request)
    {
        // TODO: Implement Balance Sheet service
        return response()->json(['message' => 'Not implemented yet']);
    }

    public function export(Request $request)
    {
        // TODO: Implement export
        return redirect()->back();
    }
}


