<?php

namespace Modules\AccountingReports\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AccountingReportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!auth()->user()->can('accounting.view_all')) {
            abort(403, 'Unauthorized action.');
        }

        return view('accounting-reports::index');
    }

    /**
     * View a voucher details
     */
    public function viewVoucher($voucherId)
    {
        $voucher = \Modules\AccountingReports\Entities\JournalEntryHeader::findOrFail($voucherId);
        
        return view('accounting-reports::voucher.view', compact('voucher'));
    }

    /**
     * View source document for a voucher
     */
    public function viewSourceDocument($voucherId)
    {
        $voucher = \Modules\AccountingReports\Entities\JournalEntryHeader::findOrFail($voucherId);
        
        if (!$voucher->source_transaction_id) {
            abort(404, 'No source document found');
        }
        
        $transaction = $voucher->sourceTransaction;
        
        // Redirect to appropriate view based on transaction type
        switch ($transaction->type) {
            case 'sell':
                return redirect()->route('sell.show', $transaction->id);
            case 'purchase':
                return redirect()->route('purchase.show', $transaction->id);
            default:
                return redirect()->back()->with('error', 'Source document not available');
        }
    }
}


