<?php

namespace Modules\AccountingReports\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;

class TrialBalanceExport implements FromArray, WithHeadings, WithStyles, ShouldAutoSize
{
    protected $data;
    protected $fromDate;
    protected $toDate;

    public function __construct($data, $fromDate, $toDate)
    {
        $this->data = $data;
        $this->fromDate = $fromDate;
        $this->toDate = $toDate;
    }

    public function array(): array
    {
        $rows = [];
        
        foreach ($this->data['accounts'] as $account) {
            $rows[] = [
                $account['account_code'],
                $account['account_name'],
                number_format($account['opening_debit'], 2),
                number_format($account['opening_credit'], 2),
                number_format($account['period_debit'], 2),
                number_format($account['period_credit'], 2),
                number_format($account['closing_debit'], 2),
                number_format($account['closing_credit'], 2),
            ];
        }

        // Add totals row
        $totals = $this->data['totals'];
        $rows[] = [
            '',
            'TOTAL',
            number_format($totals['opening_debit'], 2),
            number_format($totals['opening_credit'], 2),
            number_format($totals['period_debit'], 2),
            number_format($totals['period_credit'], 2),
            number_format($totals['closing_debit'], 2),
            number_format($totals['closing_credit'], 2),
        ];

        return $rows;
    }

    public function headings(): array
    {
        return [
            'Account Code',
            'Account Name',
            'Opening Debit',
            'Opening Credit',
            'Period Debit',
            'Period Credit',
            'Closing Debit',
            'Closing Credit',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => [
                'font' => ['bold' => true],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'CCCCCC'],
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                ],
            ],
        ];
    }
}


